/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import java.util.ArrayList;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.engine.IRotatableICTile;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.RedstoneTimerGateTile;

public class StateCellGateTile
extends RedstoneTimerGateTile {
    public StateCellGateTile() {
        super(ICGateTileType.STATE_CELL);
    }

    @Override
    protected boolean canReflect() {
        return true;
    }

    @Override
    protected void reflectAndSend() {
        this.configureShapeAndSend(this.getShape() == 0 ? 1 : 0);
    }

    @Override
    protected int redstoneOutputMask() {
        return this.getShape() == 0 ? 9 : IRotatableICTile.flipMaskZ(9);
    }

    @Override
    protected int redstoneInputMask() {
        return this.getShape() == 0 ? 6 : IRotatableICTile.flipMaskZ(6);
    }

    @Override
    public boolean isPointerStarted() {
        if (!this.getEditor().getStateMachine().isSimulating()) {
            return false;
        }
        long simTime = this.getEditor().getStateMachine().getSimSystemTime();
        return this.getState2() == 2 && simTime < this.pointerStartTime + (long)this.pointerMax;
    }

    public int state2() {
        int s2 = this.getState2();
        return s2 == 0 ? 0 : 1;
    }

    @Override
    protected void collectGate(ICAssemblyTile.Collector collector, int gateId, int[] inputRegisters, int[] outputRegisters) {
        int i;
        ArrayList<Integer> inputRegs = new ArrayList<Integer>();
        ArrayList<Integer> outputRegs = new ArrayList<Integer>();
        inputRegs.add(this.stateReg);
        inputRegs.add(inputRegisters[this.getShape() == 0 ? 1 : 3]);
        inputRegs.add(inputRegisters[2]);
        for (i = 0; i < 8; ++i) {
            inputRegs.add(this.timeRegs[i]);
        }
        for (i = 0; i < 8; ++i) {
            inputRegs.add(PRFabricationEngine.REG_TIME[i]);
        }
        outputRegs.add(this.stateReg);
        outputRegs.add(outputRegisters[0]);
        outputRegs.add(outputRegisters[this.getShape() == 0 ? 3 : 1]);
        for (i = 0; i < 8; ++i) {
            outputRegs.add(this.timeRegs[i]);
        }
        collector.addGate(gateId, new StateCellGate(this.pointerMax), inputRegs, outputRegs);
    }

    public static class StateCellGate
    implements ICGate {
        private final long pointerMax;

        private static byte readState(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[0]);
        }

        private static byte readInputMask(ICSimulation ic, int[] inputs) {
            int mask = 0;
            if (ic.getRegByteVal(inputs[1]) != 0) {
                mask |= 2;
            }
            if (ic.getRegByteVal(inputs[2]) != 0) {
                mask |= 4;
            }
            return (byte)mask;
        }

        private static long readStartTime(ICSimulation ic, int[] inputs) {
            return ic.getRegLongVal(inputs, 3);
        }

        private static long readSysTime(ICSimulation ic, int[] inputs) {
            return ic.getRegLongVal(inputs, 11);
        }

        private static void writeState(ICSimulation ic, int[] outputs, byte state) {
            ic.queueRegByteVal(outputs[0], state);
        }

        private static void writeOutputMask(ICSimulation ic, int[] outputs, byte oMask) {
            ic.queueRegByteVal(outputs[1], (oMask & 1) != 0 ? (byte)1 : 0);
            ic.queueRegByteVal(outputs[2], (oMask & 8) != 0 ? (byte)1 : 0);
        }

        private static void writeStartTime(ICSimulation ic, int[] outputs, long time) {
            ic.queueRegLongVal(outputs, 3, time);
        }

        public StateCellGate(long pointerMax) {
            this.pointerMax = pointerMax;
        }

        @Override
        public void compute(ICSimulation ic, int[] inputs, int[] outputs) {
            byte stateVal = StateCellGate.readState(ic, inputs);
            switch (stateVal) {
                case 0: {
                    if ((StateCellGate.readInputMask(ic, inputs) & 4) == 0) break;
                    StateCellGate.writeState(ic, outputs, (byte)1);
                    StateCellGate.writeOutputMask(ic, outputs, (byte)8);
                    break;
                }
                case 1: {
                    if ((StateCellGate.readInputMask(ic, inputs) & 6) != 0) break;
                    StateCellGate.writeState(ic, outputs, (byte)2);
                    StateCellGate.writeStartTime(ic, outputs, StateCellGate.readSysTime(ic, inputs));
                    break;
                }
                case 2: {
                    if ((StateCellGate.readInputMask(ic, inputs) & 6) != 0) {
                        StateCellGate.writeState(ic, outputs, (byte)1);
                        break;
                    }
                    if (StateCellGate.readSysTime(ic, inputs) < StateCellGate.readStartTime(ic, inputs) + this.pointerMax) break;
                    StateCellGate.writeState(ic, outputs, (byte)3);
                    StateCellGate.writeOutputMask(ic, outputs, (byte)1);
                    break;
                }
                case 3: {
                    if (StateCellGate.readSysTime(ic, inputs) < StateCellGate.readStartTime(ic, inputs) + this.pointerMax + 2L) break;
                    if ((StateCellGate.readInputMask(ic, inputs) & 4) != 0) {
                        StateCellGate.writeState(ic, outputs, (byte)1);
                        StateCellGate.writeOutputMask(ic, outputs, (byte)8);
                        break;
                    }
                    StateCellGate.writeState(ic, outputs, (byte)0);
                    StateCellGate.writeOutputMask(ic, outputs, (byte)0);
                    break;
                }
                default: {
                    ProjectRedFabrication.LOGGER.error("Invalid state value: " + stateVal);
                    StateCellGate.writeState(ic, outputs, (byte)0);
                }
            }
        }
    }
}

