/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.cube;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleCopycatBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedCollapsibleCopycatBlock
extends FramedBlock {
    private static final int UP = Direction.UP.ordinal();
    private static final int DOWN = Direction.DOWN.ordinal();
    private static final int NORTH = Direction.NORTH.ordinal();
    private static final int EAST = Direction.EAST.ordinal();
    private static final int SOUTH = Direction.SOUTH.ordinal();
    private static final int WEST = Direction.WEST.ordinal();
    private static final Map<Integer, VoxelShape> SHAPE_CACHE = new ConcurrentHashMap<Integer, VoxelShape>();
    public static final int ALL_SOLID = 63;

    public FramedCollapsibleCopycatBlock() {
        super(BlockType.FRAMED_COLLAPSIBLE_COPYCAT_BLOCK, IFramedBlock.createProperties(BlockType.FRAMED_COLLAPSIBLE_COPYCAT_BLOCK).m_60988_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.SOLID_FACES, (Comparable)Integer.valueOf(63)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PropertyHolder.SOLID_FACES, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        if (player.m_21205_().m_41720_() == FBContent.ITEM_FRAMED_HAMMER.get() && (blockEntity = level.m_7702_(pos)) instanceof FramedCollapsibleCopycatBlockEntity) {
            FramedCollapsibleCopycatBlockEntity be = (FramedCollapsibleCopycatBlockEntity)blockEntity;
            if (!level.m_5776_()) {
                be.handleDeform(player);
            }
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockEntity blockEntity;
        if (this.isIntangible(state, level, pos, ctx)) {
            return Shapes.m_83040_();
        }
        int solid = (Integer)state.m_61143_((Property)PropertyHolder.SOLID_FACES);
        if (solid != 63 && (blockEntity = level.m_7702_(pos)) instanceof FramedCollapsibleCopycatBlockEntity) {
            FramedCollapsibleCopycatBlockEntity be = (FramedCollapsibleCopycatBlockEntity)blockEntity;
            return SHAPE_CACHE.computeIfAbsent(be.getPackedOffsets(state), key -> {
                byte[] offsets = FramedCollapsibleCopycatBlockEntity.unpackOffsets(key);
                return FramedCollapsibleCopycatBlock.m_49796_((double)offsets[WEST], (double)offsets[DOWN], (double)offsets[NORTH], (double)(16 - offsets[EAST]), (double)(16 - offsets[UP]), (double)(16 - offsets[SOUTH]));
            });
        }
        return Shapes.m_83144_();
    }

    @Override
    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoOcclusionShape(state, level, pos, null);
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.m_5776_() && stack.m_41782_() && stack.m_41783_().m_128441_("BlockEntityTag") && (blockEntity = level.m_7702_(pos)) instanceof FramedCollapsibleCopycatBlockEntity) {
            FramedCollapsibleCopycatBlockEntity be = (FramedCollapsibleCopycatBlockEntity)blockEntity;
            be.updateFaceSolidity();
        }
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedCollapsibleCopycatBlockEntity) {
            FramedCollapsibleCopycatBlockEntity be = (FramedCollapsibleCopycatBlockEntity)blockEntity;
            return be.doesOccludeBeaconBeam();
        }
        return false;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedCollapsibleCopycatBlockEntity(pos, state);
    }
}

