/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;

@CullTest(value={BlockType.FRAMED_WALL})
public final class WallSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            boolean up = (Boolean)state.m_61143_((Property)WallBlock.f_57949_);
            return switch (type) {
                case BlockType.FRAMED_WALL -> WallSkipPredicate.testAgainstWall(state, up, adjState, side);
                case BlockType.FRAMED_PILLAR -> WallSkipPredicate.testAgainstPillar(up, adjState, side);
                case BlockType.FRAMED_HALF_PILLAR -> WallSkipPredicate.testAgainstHalfPillar(up, adjState, side);
                case BlockType.FRAMED_THICK_LATTICE -> WallSkipPredicate.testAgainstThickLattice(up, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_WALL})
    private static boolean testAgainstWall(BlockState state, boolean up, BlockState adjState, Direction side) {
        if (Utils.isY(side)) {
            boolean adjUp = (Boolean)adjState.m_61143_((Property)WallBlock.f_57949_);
            return up == adjUp;
        }
        return WallSkipPredicate.getArm(state, side) == WallSkipPredicate.getArm(adjState, side.m_122424_());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PILLAR})
    private static boolean testAgainstPillar(boolean up, BlockState adjState, Direction side) {
        return Utils.isY(side) && up && adjState.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Y;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_PILLAR})
    private static boolean testAgainstHalfPillar(boolean up, BlockState adjState, Direction side) {
        return Utils.isY(side) && up && adjState.m_61143_((Property)BlockStateProperties.f_61372_) == side.m_122424_();
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THICK_LATTICE})
    private static boolean testAgainstThickLattice(boolean up, BlockState adjState, Direction side) {
        return Utils.isY(side) && up && (Boolean)adjState.m_61143_((Property)FramedProperties.Y_AXIS) != false;
    }

    public static WallSide getArm(BlockState state, Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> (WallSide)state.m_61143_((Property)WallBlock.f_57951_);
            case Direction.EAST -> (WallSide)state.m_61143_((Property)WallBlock.f_57950_);
            case Direction.SOUTH -> (WallSide)state.m_61143_((Property)WallBlock.f_57952_);
            case Direction.WEST -> (WallSide)state.m_61143_((Property)WallBlock.f_57953_);
            default -> throw new IllegalArgumentException("Invalid wall arm direction");
        };
    }
}

