/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.logging;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.connectivity.logging.ReflectiveSafeTypeAdapterFactory;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class GsonErrorHandling
implements TypeAdapterFactory {
    private Map<Integer, Object> currentlySerializing = new HashMap<Integer, Object>();

    public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
        TypeAdapter delegate;
        try {
            delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        }
        catch (Throwable t) {
            if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                Connectivity.LOGGER.warn("Could not create delegate adapter for type:" + type.getType().getTypeName() + " debug error below", t);
            }
            return ReflectiveSafeTypeAdapterFactory.createNew(gson, type);
        }
        TypeAdapter customAdapter = new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                try {
                    String toString;
                    if (!(value instanceof String || value == null || value instanceof Collection || value instanceof Map || value instanceof ByteBuf || value.getClass().getName().startsWith("java.") || value.getClass().isRecord() || (toString = value.toString()).contains(value.getClass().getName() + "@") || GsonErrorHandling.countOccurrences(toString, '@') >= 4L)) {
                        gson.getAdapter(String.class).write(out, (Object)toString);
                        return;
                    }
                    if (value != null && !value.equals(GsonErrorHandling.this.currentlySerializing.get(System.identityHashCode(value)))) {
                        GsonErrorHandling.this.currentlySerializing.put(System.identityHashCode(value), value);
                        delegate.write(out, value);
                        GsonErrorHandling.this.currentlySerializing.remove(System.identityHashCode(value));
                        return;
                    }
                    if (value == null) {
                        delegate.write(out, value);
                    } else {
                        delegate.write(out, null);
                    }
                }
                catch (Exception e) {
                    out.value("Error serializing:" + e.getLocalizedMessage() + " value:" + value);
                }
            }

            public T read(JsonReader in) throws IOException {
                return delegate.read(in);
            }
        };
        return customAdapter;
    }

    public static long countOccurrences(String input, char target) {
        long count = 0L;
        for (char c : input.toCharArray()) {
            if (c != target) continue;
            ++count;
        }
        return count;
    }
}

