/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.google.common.collect.Lists;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.AlchBagItemCapabilityWrapper;
import moze_intel.projecte.capability.AlchChestItemCapabilityWrapper;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.block_entities.EmcBlockEntity;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class BlackHoleBand
extends PEToggleItem
implements IAlchBagItem,
IAlchChestItem,
IPedestalItem {
    public BlackHoleBand(Item.Properties props) {
        super(props);
        this.addItemCapability(AlchBagItemCapabilityWrapper::new);
        this.addItemCapability(AlchChestItemCapabilityWrapper::new);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    private InteractionResult tryPickupFluid(Level level, Player player, ItemStack stack) {
        Block block;
        BlockHitResult result = BlackHoleBand.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        BlockPos fluidPos = result.m_82425_();
        BlockState state = level.m_8055_(fluidPos);
        if (level.m_7966_(player, fluidPos) && player.m_36204_(fluidPos, result.m_82434_(), stack) && (block = state.m_60734_()) instanceof BucketPickup) {
            BucketPickup pickup = (BucketPickup)block;
            Optional sound = pickup.getPickupSound(state);
            ItemStack itemStack = pickup.m_142598_((LevelAccessor)level, fluidPos, state);
            if (!itemStack.m_41619_()) {
                sound.ifPresent(soundEvent -> player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        InteractionResult result = this.tryPickupFluid(level, player, stack);
        if (!result.m_19077_() && this.changeMode(player, stack, hand)) {
            result = InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return ItemHelper.actionResultFromType(result, stack);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean held) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (ItemHelper.checkItemNBT(stack, "Active")) {
                for (ItemEntity item : level.m_45976_(ItemEntity.class, player.m_20191_().m_82400_(7.0))) {
                    if (ItemHelper.simulateFit((NonNullList<ItemStack>)player.m_150109_().f_35974_, item.m_32055_()) >= item.m_32055_().m_41613_()) continue;
                    WorldHelper.gravitateEntityTowards((Entity)item, player.m_20185_(), player.m_20186_(), player.m_20189_());
                }
            }
        }
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        EnumMap<Direction, IItemHandler> nearbyHandlers = new EnumMap<Direction, IItemHandler>(Direction.class);
        block0: for (ItemEntity item : level.m_6443_(ItemEntity.class, ((IDMPedestal)pedestal).getEffectBounds(), ent -> !ent.m_5833_() && ent.m_6084_())) {
            WorldHelper.gravitateEntityTowards((Entity)item, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            if (level.f_46443_ || !(item.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) < 1.21)) continue;
            for (Direction dir : Direction.values()) {
                IItemHandler inv = nearbyHandlers.computeIfAbsent(dir, direction -> {
                    BlockEntity candidate = WorldHelper.getBlockEntity((BlockGetter)level, pos.m_121945_(dir));
                    if (candidate == null) {
                        return null;
                    }
                    return WorldHelper.getItemHandler(candidate, dir);
                });
                ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)item.m_32055_(), (boolean)false);
                if (result.m_41619_()) {
                    item.m_146870_();
                    continue block0;
                }
                item.m_32045_(result);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription() {
        return Lists.newArrayList((Object[])new Component[]{PELang.PEDESTAL_BLACK_HOLE_BAND_1.translateColored(ChatFormatting.BLUE, new Object[0]), PELang.PEDESTAL_BLACK_HOLE_BAND_2.translateColored(ChatFormatting.BLUE, new Object[0])});
    }

    @Override
    public boolean updateInAlchChest(@NotNull Level level, @NotNull BlockPos pos, @NotNull ItemStack stack) {
        EmcBlockEntity chest;
        if (ItemHelper.checkItemNBT(stack, "Active") && (chest = WorldHelper.getBlockEntity(EmcBlockEntity.class, (BlockGetter)level, pos, true)) != null) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            AABB aabb = new AABB((double)(x - 5), (double)(y - 5), (double)(z - 5), (double)(x + 5), (double)(y + 5), (double)(z + 5));
            double centeredX = (double)x + 0.5;
            double centeredY = (double)y + 0.5;
            double centeredZ = (double)z + 0.5;
            for (ItemEntity e : level.m_6443_(ItemEntity.class, aabb, ent -> !ent.m_5833_() && ent.m_6084_())) {
                WorldHelper.gravitateEntityTowards((Entity)e, centeredX, centeredY, centeredZ);
                if (level.f_46443_ || !(e.m_20275_(centeredX, centeredY, centeredZ) < 1.21)) continue;
                chest.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
                    ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)e.m_32055_(), (boolean)false);
                    if (!result.m_41619_()) {
                        e.m_32045_(result);
                    } else {
                        e.m_146870_();
                    }
                });
            }
        }
        return false;
    }

    @Override
    public boolean updateInAlchBag(@NotNull IItemHandler inv, @NotNull Player player, @NotNull ItemStack stack) {
        if (ItemHelper.checkItemNBT(stack, "Active")) {
            for (ItemEntity e : player.m_9236_().m_45976_(ItemEntity.class, player.m_20191_().m_82400_(5.0))) {
                WorldHelper.gravitateEntityTowards((Entity)e, player.m_20185_(), player.m_20186_(), player.m_20189_());
            }
        }
        return false;
    }
}

