/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.renderdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public abstract class RenderInfo {
    private static final String TANKS_TAG = "tanks";
    private static final String BATTERY_TAG = "battery";
    private static final String TANK_POSITION_TAG = "position";
    private static final String TANK_INFO_TAG = "info";
    private static final String ITEM_DISPLAY_TAG = "itemDisplay";
    private static final String UPGRADES_TAG = "upgrades";
    private static final String UPGRADE_ITEMS_TAG = "upgradeItems";
    private static final Map<String, UpgradeRenderDataType<?>> RENDER_DATA_TYPES = Map.of(CookingUpgradeRenderData.TYPE.getName(), CookingUpgradeRenderData.TYPE, JukeboxUpgradeRenderData.TYPE.getName(), JukeboxUpgradeRenderData.TYPE);
    private ItemDisplayRenderInfo itemDisplayRenderInfo;
    private final Supplier<Runnable> getSaveHandler;
    private final boolean showsCountsAndFillRatios;
    private final List<ItemStack> upgradeItems = new ArrayList<ItemStack>();
    private final Map<UpgradeRenderDataType<?>, IUpgradeRenderData> upgradeData = new HashMap();
    private final Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> tankRenderInfos = new LinkedHashMap<TankPosition, IRenderedTankUpgrade.TankRenderInfo>();
    @Nullable
    private IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = null;
    private Consumer<RenderInfo> changeListener = ri -> {};

    protected RenderInfo(Supplier<Runnable> getSaveHandler) {
        this(getSaveHandler, false);
    }

    protected RenderInfo(Supplier<Runnable> getSaveHandler, boolean showsCountsAndFillRatios) {
        this.getSaveHandler = getSaveHandler;
        this.showsCountsAndFillRatios = showsCountsAndFillRatios;
        this.itemDisplayRenderInfo = new ItemDisplayRenderInfo();
    }

    public ItemDisplayRenderInfo getItemDisplayRenderInfo() {
        return this.itemDisplayRenderInfo;
    }

    public void setUpgradeItems(List<ItemStack> upgradeItems) {
        this.upgradeItems.clear();
        this.upgradeItems.addAll(upgradeItems);
        this.serializeUpgradeItems();
        this.save();
    }

    private void serializeUpgradeItems() {
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        ListTag upgradeItemsTag = new ListTag();
        for (ItemStack upgradeItem : this.upgradeItems) {
            upgradeItemsTag.add((Object)upgradeItem.serializeNBT());
        }
        renderInfo.m_128365_(UPGRADE_ITEMS_TAG, (Tag)upgradeItemsTag);
        this.serializeRenderInfo(renderInfo);
    }

    public <T extends IUpgradeRenderData> void setUpgradeRenderData(UpgradeRenderDataType<T> upgradeRenderDataType, T renderData) {
        this.upgradeData.put(upgradeRenderDataType, renderData);
        this.serializeUpgradeData(upgrades -> upgrades.m_128365_(upgradeRenderDataType.getName(), (Tag)renderData.serializeNBT()));
        this.save();
    }

    public <T extends IUpgradeRenderData> Optional<T> getUpgradeRenderData(UpgradeRenderDataType<T> upgradeRenderDataType) {
        if (!this.upgradeData.containsKey(upgradeRenderDataType)) {
            return Optional.empty();
        }
        return upgradeRenderDataType.cast(this.upgradeData.get(upgradeRenderDataType));
    }

    private void serializeUpgradeData(Consumer<CompoundTag> modifyUpgradesTag) {
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        CompoundTag upgrades = renderInfo.m_128469_(UPGRADES_TAG);
        modifyUpgradesTag.accept(upgrades);
        renderInfo.m_128365_(UPGRADES_TAG, (Tag)upgrades);
        this.serializeRenderInfo(renderInfo);
    }

    public void refreshItemDisplayRenderInfo(List<DisplayItem> displayItems, List<Integer> inaccessibleSlots, List<Integer> infiniteSlots, List<Integer> slotCounts, List<Float> slotFillRatios) {
        this.itemDisplayRenderInfo = new ItemDisplayRenderInfo(displayItems, inaccessibleSlots, infiniteSlots, slotCounts, slotFillRatios);
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        renderInfo.m_128365_(ITEM_DISPLAY_TAG, (Tag)this.itemDisplayRenderInfo.serialize());
        this.serializeRenderInfo(renderInfo);
        this.save();
    }

    public void setChangeListener(Consumer<RenderInfo> changeListener) {
        this.changeListener = changeListener;
    }

    protected void save(boolean triggerChangeListener) {
        this.getSaveHandler.get().run();
        if (triggerChangeListener) {
            this.changeListener.accept(this);
        }
    }

    protected void save() {
        this.save(false);
    }

    protected abstract void serializeRenderInfo(CompoundTag var1);

    protected void deserialize() {
        this.getRenderInfoTag().ifPresent(renderInfoTag -> {
            this.deserializeItemDisplay((CompoundTag)renderInfoTag);
            this.deserializeUpgradeItems((CompoundTag)renderInfoTag);
            this.deserializeUpgradeData((CompoundTag)renderInfoTag);
            this.deserializeTanks((CompoundTag)renderInfoTag);
            this.deserializeBattery((CompoundTag)renderInfoTag);
        });
        this.changeListener.accept(this);
    }

    private void deserializeUpgradeItems(CompoundTag renderInfoTag) {
        ListTag upgradeItemsTag = renderInfoTag.m_128437_(UPGRADE_ITEMS_TAG, 10);
        this.upgradeItems.clear();
        for (int i = 0; i < upgradeItemsTag.size(); ++i) {
            this.upgradeItems.add(ItemStack.m_41712_((CompoundTag)upgradeItemsTag.m_128728_(i)));
        }
    }

    private void deserializeItemDisplay(CompoundTag renderInfoTag) {
        this.itemDisplayRenderInfo = ItemDisplayRenderInfo.deserialize(renderInfoTag.m_128469_(ITEM_DISPLAY_TAG));
    }

    protected abstract Optional<CompoundTag> getRenderInfoTag();

    public Map<UpgradeRenderDataType<?>, IUpgradeRenderData> getUpgradeRenderData() {
        return this.upgradeData;
    }

    public void removeUpgradeRenderData(UpgradeRenderDataType<?> type) {
        this.upgradeData.remove(type);
        this.serializeUpgradeData(upgrades -> upgrades.m_128473_(type.getName()));
        this.save();
    }

    private void deserializeUpgradeData(CompoundTag renderInfoTag) {
        CompoundTag upgrades = renderInfoTag.m_128469_(UPGRADES_TAG);
        upgrades.m_128431_().forEach(key -> {
            if (RENDER_DATA_TYPES.containsKey(key)) {
                UpgradeRenderDataType<?> upgradeRenderDataType = RENDER_DATA_TYPES.get(key);
                this.upgradeData.put(upgradeRenderDataType, (IUpgradeRenderData)upgradeRenderDataType.deserialize(upgrades.m_128469_(key)));
            }
        });
    }

    public CompoundTag getNbt() {
        return this.getRenderInfoTag().orElse(new CompoundTag());
    }

    public void deserializeFrom(CompoundTag renderInfoNbt) {
        this.resetUpgradeInfo(false);
        this.upgradeData.clear();
        this.serializeRenderInfo(renderInfoNbt);
        this.deserialize();
    }

    public void resetUpgradeInfo(boolean triggerChangeListener) {
        this.tankRenderInfos.clear();
        this.batteryRenderInfo = null;
        this.getRenderInfoTag().ifPresent(renderInfoTag -> {
            renderInfoTag.m_128473_(TANKS_TAG);
            renderInfoTag.m_128473_(BATTERY_TAG);
        });
        this.save(triggerChangeListener);
    }

    public void setTankRenderInfo(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        this.tankRenderInfos.put(tankPosition, tankRenderInfo);
        this.serializeTank(tankPosition, tankRenderInfo);
        this.save();
    }

    private void deserializeTanks(CompoundTag renderInfoTag) {
        ListTag tanks = renderInfoTag.m_128437_(TANKS_TAG, 10);
        for (int i = 0; i < tanks.size(); ++i) {
            CompoundTag tank = tanks.m_128728_(i);
            this.tankRenderInfos.put(TankPosition.valueOf(tank.m_128461_(TANK_POSITION_TAG).toUpperCase(Locale.ENGLISH)), IRenderedTankUpgrade.TankRenderInfo.deserialize(tank.m_128469_(TANK_INFO_TAG)));
        }
    }

    private void deserializeBattery(CompoundTag renderInfoTag) {
        this.batteryRenderInfo = NBTHelper.getCompound(renderInfoTag, BATTERY_TAG).map(IRenderedBatteryUpgrade.BatteryRenderInfo::deserialize).orElse(null);
    }

    private void serializeTank(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        CompoundTag tankInfo = tankRenderInfo.serialize();
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        ListTag tanks = renderInfo.m_128437_(TANKS_TAG, 10);
        boolean infoSet = false;
        for (int i = 0; i < tanks.size(); ++i) {
            CompoundTag tank = tanks.m_128728_(i);
            if (!tank.m_128461_(TANK_POSITION_TAG).equals(tankPosition.m_7912_())) continue;
            tank.m_128365_(TANK_INFO_TAG, (Tag)tankInfo);
            infoSet = true;
        }
        if (!infoSet) {
            CompoundTag tankPositionInfo = new CompoundTag();
            tankPositionInfo.m_128359_(TANK_POSITION_TAG, tankPosition.m_7912_());
            tankPositionInfo.m_128365_(TANK_INFO_TAG, (Tag)tankInfo);
            tanks.add((Object)tankPositionInfo);
            renderInfo.m_128365_(TANKS_TAG, (Tag)tanks);
        }
        this.serializeRenderInfo(renderInfo);
    }

    public Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> getTankRenderInfos() {
        return this.tankRenderInfos;
    }

    public Optional<IRenderedBatteryUpgrade.BatteryRenderInfo> getBatteryRenderInfo() {
        return Optional.ofNullable(this.batteryRenderInfo);
    }

    public void setBatteryRenderInfo(IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo) {
        this.batteryRenderInfo = batteryRenderInfo;
        CompoundTag batteryInfo = batteryRenderInfo.serialize();
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        renderInfo.m_128365_(BATTERY_TAG, (Tag)batteryInfo);
        this.serializeRenderInfo(renderInfo);
        this.save();
    }

    public List<ItemStack> getUpgradeItems() {
        return this.upgradeItems;
    }

    public boolean showsCountsAndFillRatios() {
        return this.showsCountsAndFillRatios;
    }

    public static class ItemDisplayRenderInfo {
        private static final String ITEMS_TAG = "items";
        private static final String INACCESSIBLE_SLOTS_TAG = "inaccessibleSlots";
        private static final String INFINITE_SLOTS_TAG = "infiniteSlots";
        public static final String SLOT_COUNTS_TAG = "slotCounts";
        public static final String SLOT_FILL_RATIOS_TAG = "slotFillRatios";
        private final List<DisplayItem> displayItems;
        private final List<Integer> inaccessibleSlots;
        private final List<Integer> infiniteSlots;
        private final List<Integer> slotCounts;
        private final List<Float> slotFillRatios;

        private ItemDisplayRenderInfo(DisplayItem displayItem, List<Integer> inaccessibleSlots, List<Integer> infiniteSlots, List<Integer> slotCounts, List<Float> slotFillRatios) {
            this(List.of(displayItem), inaccessibleSlots, infiniteSlots, slotCounts, slotFillRatios);
        }

        private ItemDisplayRenderInfo(List<DisplayItem> displayItems, List<Integer> inaccessibleSlots, List<Integer> infiniteSlots, List<Integer> slotCounts, List<Float> slotFillRatios) {
            this.displayItems = displayItems;
            this.inaccessibleSlots = inaccessibleSlots;
            this.infiniteSlots = infiniteSlots;
            this.slotCounts = slotCounts;
            this.slotFillRatios = slotFillRatios;
        }

        public ItemDisplayRenderInfo() {
            this(new ArrayList<DisplayItem>(), new ArrayList<Integer>(), new ArrayList<Integer>(), Collections.emptyList(), Collections.emptyList());
        }

        public CompoundTag serialize() {
            CompoundTag ret = new CompoundTag();
            if (this.displayItems.size() == 1) {
                this.displayItems.get(0).serialize(ret);
            } else if (this.displayItems.size() > 1) {
                NBTHelper.putList(ret, ITEMS_TAG, this.displayItems, displayItem -> displayItem.serialize(new CompoundTag()));
            }
            NBTHelper.putList(ret, INACCESSIBLE_SLOTS_TAG, this.inaccessibleSlots, IntTag::m_128679_);
            NBTHelper.putList(ret, INFINITE_SLOTS_TAG, this.infiniteSlots, IntTag::m_128679_);
            ret.m_128385_(SLOT_COUNTS_TAG, this.slotCounts.stream().mapToInt(i -> i).toArray());
            NBTHelper.putList(ret, SLOT_FILL_RATIOS_TAG, this.slotFillRatios, FloatTag::m_128566_);
            return ret;
        }

        public static ItemDisplayRenderInfo deserialize(CompoundTag tag) {
            List inaccessibleSlots = NBTHelper.getCollection(tag, INACCESSIBLE_SLOTS_TAG, (byte)3, t -> Optional.of(((IntTag)t).m_7047_()), ArrayList::new).orElseGet(ArrayList::new);
            List infiniteSlots = NBTHelper.getCollection(tag, INFINITE_SLOTS_TAG, (byte)3, t -> Optional.of(((IntTag)t).m_7047_()), ArrayList::new).orElseGet(ArrayList::new);
            List slotCounts = Arrays.stream(tag.m_128465_(SLOT_COUNTS_TAG)).boxed().collect(Collectors.toCollection(ArrayList::new));
            List slotFillRatios = NBTHelper.getCollection(tag, SLOT_FILL_RATIOS_TAG, (byte)5, t -> Optional.of(Float.valueOf(((FloatTag)t).m_7057_())), ArrayList::new).orElseGet(ArrayList::new);
            if (tag.m_128441_("item")) {
                return new ItemDisplayRenderInfo(DisplayItem.deserialize(tag), (List<Integer>)inaccessibleSlots, (List<Integer>)infiniteSlots, (List<Integer>)slotCounts, (List<Float>)slotFillRatios);
            }
            if (tag.m_128441_(ITEMS_TAG)) {
                List items = NBTHelper.getCollection(tag, ITEMS_TAG, (byte)10, stackTag -> Optional.of(DisplayItem.deserialize((CompoundTag)stackTag)), ArrayList::new).orElseGet(ArrayList::new);
                return new ItemDisplayRenderInfo(items, (List<Integer>)inaccessibleSlots, (List<Integer>)infiniteSlots, (List<Integer>)slotCounts, (List<Float>)slotFillRatios);
            }
            return new ItemDisplayRenderInfo();
        }

        public Optional<DisplayItem> getDisplayItem() {
            return this.isValidIndex(this.displayItems, 0) ? Optional.of(this.displayItems.get(0)) : Optional.empty();
        }

        private boolean isValidIndex(List<?> list, int index) {
            return index >= 0 && index < list.size();
        }

        public List<DisplayItem> getDisplayItems() {
            return this.displayItems;
        }

        public List<Integer> getInaccessibleSlots() {
            return this.inaccessibleSlots;
        }

        public List<Integer> getSlotCounts() {
            return this.slotCounts;
        }

        public List<Integer> getInfiniteSlots() {
            return this.infiniteSlots;
        }

        public List<Float> getSlotFillRatios() {
            return this.slotFillRatios;
        }
    }

    public static class DisplayItem {
        private static final String ITEM_TAG = "item";
        private static final String ROTATION_TAG = "rotation";
        private static final String SLOT_INDEX_TAG = "slotIndex";
        private static final String DISPLAY_SIDE_TAG = "displaySide";
        private ItemStack item;
        private int rotation;
        private int slotIndex;
        private DisplaySide displaySide;

        public DisplayItem(ItemStack item, int rotation, int slotIndex, DisplaySide displaySide) {
            this.item = item;
            this.rotation = rotation;
            this.slotIndex = slotIndex;
            this.displaySide = displaySide;
        }

        private CompoundTag serialize(CompoundTag tag) {
            tag.m_128365_(ITEM_TAG, (Tag)this.item.serializeNBT());
            tag.m_128405_(ROTATION_TAG, this.rotation);
            tag.m_128405_(SLOT_INDEX_TAG, this.slotIndex);
            tag.m_128359_(DISPLAY_SIDE_TAG, this.displaySide.m_7912_());
            return tag;
        }

        private static DisplayItem deserialize(CompoundTag tag) {
            return new DisplayItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_(ITEM_TAG)), tag.m_128451_(ROTATION_TAG), tag.m_128451_(SLOT_INDEX_TAG), DisplaySide.fromName(tag.m_128461_(DISPLAY_SIDE_TAG)));
        }

        public ItemStack getItem() {
            return this.item;
        }

        public int getRotation() {
            return this.rotation;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public DisplaySide getDisplaySide() {
            return this.displaySide;
        }
    }
}

