/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.renderer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import li.cil.oc2.common.blockentity.MonitorBlockEntity;
import li.cil.oc2.jcodec.common.model.Picture;
import li.cil.oc2.jcodec.scale.Yuv420jToRgb;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class MonitorGUIRenderer {
    private final transient Set<RendererModel> renderers = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    @OnlyIn(value=Dist.CLIENT)
    public RendererView getRenderer(MonitorBlockEntity monitor) {
        Renderer renderer = new Renderer(monitor);
        this.renderers.add(renderer);
        return renderer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void releaseRenderer(RendererView renderer) {
        if (renderer instanceof RendererModel) {
            RendererModel rendererModel = (RendererModel)((Object)renderer);
            rendererModel.close();
            this.renderers.remove(rendererModel);
        }
    }

    private static void handleProjectorNoLongerRendering(RemovalNotification<MonitorBlockEntity, Renderer.RenderInfo> notification) {
        Renderer.RenderInfo renderInfo;
        MonitorBlockEntity monitor = (MonitorBlockEntity)notification.getKey();
        if (monitor != null) {
            monitor.setFrameConsumer(null);
        }
        if ((renderInfo = (Renderer.RenderInfo)notification.getValue()) != null) {
            renderInfo.close();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private record Renderer(MonitorBlockEntity monitorBlock) implements RendererModel,
    RendererView
    {
        private static final Cache<MonitorBlockEntity, RenderInfo> RENDER_INFO = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(5L)).removalListener(MonitorGUIRenderer::handleProjectorNoLongerRendering).build();

        private static DynamicTexture getColorBuffer(MonitorBlockEntity monitor) {
            try {
                return ((RenderInfo)RENDER_INFO.get((Object)monitor, () -> {
                    DynamicTexture texture = new DynamicTexture(640, 480, false);
                    texture.m_117985_();
                    RenderInfo renderInfo = new RenderInfo(texture);
                    monitor.setFrameConsumer(renderInfo);
                    return renderInfo;
                })).texture();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
        }

        @Override
        public void render(PoseStack stack, Matrix4f projectionMatrix, float width, float height) {
            if (this.monitorBlock.isValid()) {
                DynamicTexture texture = Renderer.getColorBuffer(this.monitorBlock);
                this.monitorBlock.onRendering();
                RenderSystem.backupProjectionMatrix();
                RenderSystem.getModelViewStack().m_85836_();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                ShaderInstance shader = GameRenderer.m_172817_();
                if (shader == null) {
                    return;
                }
                BufferBuilder builder = Tesselator.m_85913_().m_85915_();
                RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (VertexSorting)VertexSorting.f_276633_);
                RenderSystem.setShaderTexture((int)0, (int)texture.m_117963_());
                VertexBuffer buffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                builder.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
                builder.m_5483_(0.0, (double)height, 0.0).m_7421_(0.0f, 1.0f).m_5752_();
                builder.m_5483_((double)width, (double)height, 0.0).m_7421_(1.0f, 1.0f).m_5752_();
                builder.m_5483_((double)width, 0.0, 0.0).m_7421_(1.0f, 0.0f).m_5752_();
                buffer.m_85921_();
                buffer.m_231221_(builder.m_231175_());
                buffer.m_253207_(stack.m_85850_().m_252922_(), projectionMatrix, shader);
                VertexBuffer.m_85931_();
                buffer.close();
                RenderSystem.restoreProjectionMatrix();
                RenderSystem.getModelViewStack().m_85849_();
                RenderSystem.applyModelViewMatrix();
            }
        }

        private record RenderInfo(DynamicTexture texture) implements MonitorBlockEntity.FrameConsumer
        {
            private static final ThreadLocal<byte[]> RGB = ThreadLocal.withInitial(() -> new byte[3]);

            public synchronized void close() {
                this.texture.close();
            }

            @Override
            public synchronized void processFrame(Picture picture) {
                NativeImage image = this.texture.m_117991_();
                if (image == null) {
                    return;
                }
                byte[] y = picture.getPlaneData(0);
                byte[] u = picture.getPlaneData(1);
                byte[] v = picture.getPlaneData(2);
                int lumaIndex = 0;
                int chromaIndex = 0;
                int halfRow = 0;
                while (halfRow < 240) {
                    int row = halfRow * 2;
                    int halfCol = 0;
                    while (halfCol < 320) {
                        int col = halfCol * 2;
                        int yIndex = lumaIndex + col;
                        byte cb = u[chromaIndex];
                        byte cr = v[chromaIndex];
                        RenderInfo.setFromYUV420(image, col, row, y[yIndex], cb, cr);
                        RenderInfo.setFromYUV420(image, col + 1, row, y[yIndex + 1], cb, cr);
                        RenderInfo.setFromYUV420(image, col, row + 1, y[yIndex + 640], cb, cr);
                        RenderInfo.setFromYUV420(image, col + 1, row + 1, y[yIndex + 640 + 1], cb, cr);
                        ++halfCol;
                        ++chromaIndex;
                    }
                    ++halfRow;
                    lumaIndex += 1280;
                }
                this.texture.m_117985_();
            }

            private static void setFromYUV420(NativeImage image, int col, int row, byte y, byte cb, byte cr) {
                byte[] bytes = RGB.get();
                Yuv420jToRgb.YUVJtoRGB(y, cb, cr, bytes, 0);
                int r = bytes[0] + 128;
                int g = bytes[1] + 128;
                int b = bytes[2] + 128;
                image.m_84988_(col, row, r | g << 8 | b << 16 | 0xFF000000);
            }
        }
    }

    private static interface RendererModel {
        public void close();
    }

    public static interface RendererView {
        public void render(PoseStack var1, Matrix4f var2, float var3, float var4);
    }
}

