/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.blockentity;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.annotation.Nullable;
import li.cil.oc2.client.renderer.MonitorGUIRenderer;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.block.MonitorBlock;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.ModBlockEntity;
import li.cil.oc2.common.blockentity.TickableBlockEntity;
import li.cil.oc2.common.bus.device.DeviceGroup;
import li.cil.oc2.common.bus.device.vm.block.KeyboardDevice;
import li.cil.oc2.common.bus.device.vm.block.MonitorDevice;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.container.MonitorDisplayContainer;
import li.cil.oc2.common.energy.FixedEnergyStorage;
import li.cil.oc2.common.network.MonitorLoadBalancer;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.MonitorRequestFramebufferMessage;
import li.cil.oc2.common.network.message.MonitorStateMessage;
import li.cil.oc2.jcodec.codecs.h264.H264Decoder;
import li.cil.oc2.jcodec.codecs.h264.H264Encoder;
import li.cil.oc2.jcodec.codecs.h264.encode.CQPRateControl;
import li.cil.oc2.jcodec.common.model.ColorSpace;
import li.cil.oc2.jcodec.common.model.Picture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.energy.IEnergyStorage;

public final class MonitorBlockEntity
extends ModBlockEntity
implements TickableBlockEntity {
    private static final String STATE_TAG_NAME = "state";
    private static final String ENERGY_TAG_NAME = "energy";
    private static final String IS_RENDERING_TAG_NAME = "projecting";
    private static final String HAS_ENERGY_TAG_NAME = "has_energy";
    private static final ExecutorService DECODER_WORKERS = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName("Monitor Frame Decoder");
        return thread;
    });
    private final FixedEnergyStorage energy = new FixedEnergyStorage(Config.monitorEnergyStorage);
    private boolean hasEnergy;
    private boolean isMounted;
    private boolean isPowered;
    @Nullable
    private CompletableFuture<?> runningDecode;
    private final H264Decoder decoder = new H264Decoder();
    private final ByteBuffer decoderBuffer = ByteBuffer.allocateDirect(614400);
    @Nullable
    private FrameConsumer frameConsumer;
    private boolean needsIDR;
    private final DeviceGroup deviceGroup = new DeviceGroup(this);
    private final MonitorDevice monitorDevice = new MonitorDevice(this, this::handleMountedChanged);
    private final KeyboardDevice<BlockEntity> keyboardDevice = new KeyboardDevice<MonitorBlockEntity>(this);
    private final Picture picture = Picture.create(640, 480, ColorSpace.YUV420J);
    private final MonitorGUIRenderer monitor = new MonitorGUIRenderer();
    private final H264Encoder encoder = new H264Encoder(new CQPRateControl(12));
    private final ByteBuffer encoderBuffer = ByteBuffer.allocateDirect(614400);
    private long lastKeepAliveSentAt;

    public void setRequiresKeyframe() {
        this.needsIDR = true;
    }

    public boolean hasPower() {
        return this.hasEnergy;
    }

    public boolean getPowerState() {
        return this.isPowered;
    }

    public boolean isMounted() {
        return this.isMounted;
    }

    public MonitorGUIRenderer getMonitor() {
        return this.monitor;
    }

    public void handleInput(int keycode, boolean isDown) {
        this.keyboardDevice.sendKeyEvent(keycode, isDown);
    }

    @Nullable
    private ByteBuffer encodeFrame() {
        ByteBuffer frameData;
        boolean hasChanges = this.monitorDevice.applyChanges(this.picture);
        if (!hasChanges && !this.needsIDR) {
            return null;
        }
        this.encoderBuffer.clear();
        try {
            if (this.needsIDR) {
                frameData = this.encoder.encodeIDRFrame(this.picture, this.encoderBuffer);
                this.needsIDR = false;
            } else {
                frameData = this.encoder.encodeFrame(this.picture, this.encoderBuffer).data();
            }
        }
        catch (BufferOverflowException ignored) {
            return null;
        }
        Deflater deflater = new Deflater(9);
        deflater.setInput(frameData);
        deflater.finish();
        ByteBuffer compressedFrameData = ByteBuffer.allocateDirect(0x100000);
        deflater.deflate(compressedFrameData, 3);
        deflater.end();
        compressedFrameData.flip();
        return compressedFrameData;
    }

    private void handleMountedChanged(boolean value) {
        this.updateMonitorState(value, this.hasEnergy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrameConsumer(@Nullable FrameConsumer consumer) {
        if (consumer == this.frameConsumer) {
            return;
        }
        Picture picture = this.picture;
        synchronized (picture) {
            this.frameConsumer = consumer;
            if (this.frameConsumer != null) {
                this.frameConsumer.processFrame(this.picture);
            }
        }
    }

    private void updateMonitorState(boolean isMounted, boolean hasEnergy) {
        if (isMounted == this.isMounted && hasEnergy == this.hasEnergy || !this.isValid()) {
            return;
        }
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && this.f_58857_.m_46749_(this.m_58899_())) {
            if (this.isMounted && !isMounted) {
                Arrays.fill(this.picture.getPlaneData(0), (byte)-128);
            }
            this.isMounted = isMounted;
            this.hasEnergy = hasEnergy;
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)MonitorBlock.LIT, (Comparable)Boolean.valueOf(isMounted)), 2);
            Network.sendToClientsTrackingBlockEntity(new MonitorStateMessage(this, isMounted, hasEnergy), this);
        }
    }

    public void applyMonitorStateClient(boolean isRendering, boolean hasEnergy) {
        if (this.f_58857_ == null || !this.f_58857_.m_5776_()) {
            return;
        }
        this.isMounted = isRendering;
        this.hasEnergy = hasEnergy;
    }

    public MonitorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.MONITOR.get(), pos, state);
        this.deviceGroup.addDevice(this.monitorDevice);
        this.deviceGroup.addDevice(this.keyboardDevice);
        this.encoder.setKeyInterval(100);
        this.setNeedsLevelUnloadEvent();
    }

    public void start() {
        this.isPowered = true;
    }

    public void stop() {
        this.isPowered = false;
    }

    public void openTerminalScreen(ServerPlayer player) {
        MonitorDisplayContainer.createServer(this, (IEnergyStorage)this.energy, player);
    }

    public void onRendering() {
        long now = System.currentTimeMillis();
        if (now - this.lastKeepAliveSentAt > 1000L) {
            this.lastKeepAliveSentAt = now;
            Network.sendToServer(new MonitorRequestFramebufferMessage(this));
        }
    }

    @Override
    public void serverTick() {
        boolean hasPowered;
        if (this.f_58857_ == null || !this.isValid()) {
            return;
        }
        if (Config.monitorsUseEnergy()) {
            boolean bl = hasPowered = this.energy.extractEnergy(Config.monitorEnergyPerTick, true) >= Config.monitorEnergyPerTick;
            if (hasPowered) {
                this.energy.extractEnergy(Config.monitorEnergyPerTick, false);
            }
        } else {
            hasPowered = true;
        }
        this.updateMonitorState(this.isMounted, hasPowered);
        if (!this.hasEnergy || !this.isPowered || !this.monitorDevice.hasChanges() && !this.needsIDR) {
            return;
        }
        MonitorLoadBalancer.offerFrame(this, this::encodeFrame);
    }

    public void applyNextFrameClient(ByteBuffer frameData) {
        if (this.f_58857_ == null || !this.f_58857_.m_5776_()) {
            return;
        }
        CompletableFuture<?> lastDecode = this.runningDecode;
        this.runningDecode = CompletableFuture.runAsync(() -> {
            try {
                try {
                    if (lastDecode != null) {
                        lastDecode.join();
                    }
                }
                catch (CompletionException completionException) {
                    // empty catch block
                }
                Inflater inflater = new Inflater();
                inflater.setInput(frameData);
                this.decoderBuffer.clear();
                inflater.inflate(this.decoderBuffer);
                this.decoderBuffer.flip();
                this.decoder.decodeFrame(this.decoderBuffer, this.picture.getData());
                Picture picture = this.picture;
                synchronized (picture) {
                    if (this.frameConsumer != null) {
                        this.frameConsumer.processFrame(this.picture);
                    }
                }
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }, DECODER_WORKERS);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_(IS_RENDERING_TAG_NAME, this.isMounted);
        tag.m_128379_(HAS_ENERGY_TAG_NAME, this.hasEnergy);
        tag.m_128379_(STATE_TAG_NAME, this.isPowered);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.isMounted = tag.m_128471_(IS_RENDERING_TAG_NAME);
        this.hasEnergy = tag.m_128471_(HAS_ENERGY_TAG_NAME);
        this.isPowered = tag.m_128471_(STATE_TAG_NAME);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ENERGY_TAG_NAME, (Tag)this.energy.serializeNBT());
        tag.m_128379_(IS_RENDERING_TAG_NAME, this.isPowered);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energy.deserializeNBT((Tag)tag.m_128469_(ENERGY_TAG_NAME));
        this.hasEnergy = tag.m_128471_(HAS_ENERGY_TAG_NAME);
        this.isPowered = tag.m_128471_(IS_RENDERING_TAG_NAME);
    }

    @Override
    protected void collectCapabilities(ModBlockEntity.CapabilityCollector collector, @Nullable Direction direction) {
        if (direction != this.m_58900_().m_61143_((Property)MonitorBlock.f_54117_)) {
            collector.offer(Capabilities.device(), this.deviceGroup);
            if (Config.monitorsUseEnergy()) {
                collector.offer(Capabilities.energyStorage(), this.energy);
            }
        }
    }

    @FunctionalInterface
    public static interface FrameConsumer {
        public void processFrame(Picture var1);
    }
}

