/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.data;

import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.data.BlockDeviceData;
import li.cil.oc2.api.util.Registries;
import li.cil.oc2.common.bus.device.data.BuildrootBlockDeviceData;
import li.cil.oc2.common.bus.device.data.FileSystems;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public final class BlockDeviceDataRegistry {
    private static final DeferredRegister<BlockDeviceData> INITIALIZER = DeferredRegister.create(Registries.BLOCK_DEVICE_DATA, (String)"oc2r");
    private static final Supplier<IForgeRegistry<BlockDeviceData>> REGISTRY = INITIALIZER.makeRegistry(RegistryBuilder::new);
    public static final RegistryObject<BlockDeviceData> BUILDROOT = INITIALIZER.register("buildroot", BuildrootBlockDeviceData::new);

    public static void initialize() {
        INITIALIZER.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @Nullable
    public static ResourceLocation getKey(BlockDeviceData data) {
        ResourceLocation location = REGISTRY.get().getKey((Object)data);
        if (location == null) {
            location = FileSystems.getKeyByValue(data);
        }
        return location;
    }

    @Nullable
    public static BlockDeviceData getValue(ResourceLocation location) {
        BlockDeviceData value = (BlockDeviceData)REGISTRY.get().getValue(location);
        if (value != null) {
            return value;
        }
        return FileSystems.getBlockData().get(location);
    }

    public static Stream<BlockDeviceData> values() {
        return Stream.concat(REGISTRY.get().getValues().stream(), FileSystems.getBlockData().values().stream());
    }
}

