/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.container;

import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.container.AbstractRobotContainer;
import li.cil.oc2.common.container.Containers;
import li.cil.oc2.common.container.DeviceTypeSlotItemHandler;
import li.cil.oc2.common.container.IntPrecisionContainerData;
import li.cil.oc2.common.container.RobotSlot;
import li.cil.oc2.common.energy.FixedEnergyStorage;
import li.cil.oc2.common.entity.Robot;
import li.cil.oc2.common.vm.VMItemStackHandlers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public final class RobotInventoryContainer
extends AbstractRobotContainer {
    public static void createServer(final Robot robot, final FixedEnergyStorage energy, final CommonDeviceBusController busController, ServerPlayer player) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return robot.m_7755_();
            }

            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                return new RobotInventoryContainer(id, robot, player, AbstractRobotContainer.createEnergyInfo(energy, busController));
            }
        }, b -> b.m_130130_(robot.m_19879_()));
    }

    public static RobotInventoryContainer createClient(int id, Inventory inventory, FriendlyByteBuf data) {
        int entityId = data.m_130242_();
        Entity entity = inventory.f_35978_.m_9236_().m_6815_(entityId);
        if (entity instanceof Robot) {
            Robot robot = (Robot)entity;
            return new RobotInventoryContainer(id, robot, inventory.f_35978_, RobotInventoryContainer.createClientEnergyInfo());
        }
        throw new IllegalArgumentException();
    }

    private RobotInventoryContainer(int id, Robot robot, Player player, IntPrecisionContainerData energyInfo) {
        super((MenuType)Containers.ROBOT.get(), id, player, robot, energyInfo);
        VMItemStackHandlers handlers = robot.getItemStackHandlers();
        handlers.getItemHandler(DeviceTypes.FLASH_MEMORY).ifPresent(itemHandler -> {
            if (itemHandler.getSlots() > 0) {
                this.m_38897_((Slot)new DeviceTypeSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.FLASH_MEMORY, 0, 34, 78));
            }
        });
        handlers.getItemHandler(DeviceTypes.MEMORY).ifPresent(itemHandler -> {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                this.m_38897_((Slot)new DeviceTypeSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.MEMORY, slot, 34 + slot * 18, 24));
            }
        });
        handlers.getItemHandler(DeviceTypes.HARD_DRIVE).ifPresent(itemHandler -> {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                this.m_38897_((Slot)new DeviceTypeSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.HARD_DRIVE, slot, 70 + slot % 2 * 18, 60 + slot / 2 * 18));
            }
        });
        handlers.getItemHandler(DeviceTypes.ROBOT_MODULE).ifPresent(itemHandler -> {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                this.m_38897_((Slot)new DeviceTypeSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.ROBOT_MODULE, slot, 8, 24 + slot * 18));
            }
        });
        handlers.getItemHandler(DeviceTypes.CPU).ifPresent(itemHandler -> {
            if (itemHandler.getSlots() > 0) {
                this.m_38897_((Slot)new DeviceTypeSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.CPU, 0, 34, 52));
            }
        });
        ItemStackHandler inventory = robot.getInventory();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            int x = 116 + slot % 3 * 18;
            int y = 24 + slot / 3 * 18;
            this.m_38897_((Slot)new RobotSlot((IItemHandler)inventory, slot, x, y));
        }
        this.createPlayerInventoryAndHotbarSlots(player.m_150109_(), 8, 115);
    }
}

