/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.nearby_tracker;

import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.List;
import me.jellysquid.mods.lithium.common.entity.nearby_tracker.NearbyEntityListener;
import me.jellysquid.mods.lithium.common.util.tuples.Range6Int;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class NearbyEntityTracker<T extends LivingEntity>
implements NearbyEntityListener {
    private final Class<T> clazz;
    private final LivingEntity entity;
    private final Reference2LongOpenHashMap<T> nearbyEntities = new Reference2LongOpenHashMap(0);
    private long counter;
    private final Range6Int chunkBoxRadius;

    public NearbyEntityTracker(Class<T> clazz, LivingEntity entity, Vec3i boxRadius) {
        this.clazz = clazz;
        this.entity = entity;
        this.chunkBoxRadius = new Range6Int(1 + SectionPos.m_123171_((int)boxRadius.m_123341_()), 1 + SectionPos.m_123171_((int)boxRadius.m_123342_()), 1 + SectionPos.m_123171_((int)boxRadius.m_123343_()), 1 + SectionPos.m_123171_((int)boxRadius.m_123341_()), 1 + SectionPos.m_123171_((int)boxRadius.m_123342_()), 1 + SectionPos.m_123171_((int)boxRadius.m_123343_()));
    }

    @Override
    public Class<? extends Entity> getEntityClass() {
        return this.clazz;
    }

    @Override
    public Range6Int getChunkRange() {
        return this.chunkBoxRadius;
    }

    @Override
    public void onEntityEnteredRange(Entity entity) {
        if (!this.clazz.isInstance(entity)) {
            return;
        }
        this.nearbyEntities.put((Object)((LivingEntity)entity), this.counter++);
    }

    @Override
    public void onEntityLeftRange(Entity entity) {
        if (this.nearbyEntities.isEmpty() || !this.clazz.isInstance(entity)) {
            return;
        }
        this.nearbyEntities.removeLong((Object)entity);
    }

    public T getClosestEntity(AABB box, TargetingConditions targetPredicate, double x, double y, double z) {
        LivingEntity nearest = null;
        double nearestDistance = Double.POSITIVE_INFINITY;
        for (LivingEntity entity : this.nearbyEntities.keySet()) {
            double d;
            if (box != null && !box.m_82381_(entity.m_20191_())) continue;
            double distance = entity.m_20275_(x, y, z);
            if (!(d <= nearestDistance) || !targetPredicate.m_26885_(this.getEntity(), entity)) continue;
            nearest = distance == nearestDistance ? this.getFirst(nearest, entity) : entity;
            nearestDistance = distance;
        }
        return (T)nearest;
    }

    private T getFirst(T entity1, T entity2) {
        long pos2;
        if (this.getEntityClass() == Player.class) {
            List players = this.getEntity().m_20193_().m_6907_();
            return players.indexOf((Player)entity1) < players.indexOf((Player)entity2) ? entity1 : entity2;
        }
        long pos1 = SectionPos.m_175568_((BlockPos)entity1.m_20183_());
        if (pos1 < (pos2 = SectionPos.m_175568_((BlockPos)entity2.m_20183_()))) {
            return entity1;
        }
        if (pos2 < pos1) {
            return entity2;
        }
        if (this.nearbyEntities.getLong(entity1) < this.nearbyEntities.getLong(entity2)) {
            return entity1;
        }
        return entity2;
    }

    public String toString() {
        return super.toString() + " for entity class: " + this.clazz.getName() + ", around entity: " + this.getEntity().toString() + " with NBT: " + this.getEntity().m_20240_(new CompoundTag());
    }

    LivingEntity getEntity() {
        return this.entity;
    }
}

