/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.world.inline_height;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Level.class})
public abstract class WorldMixin
implements LevelHeightAccessor {
    private int bottomY;
    private int height;
    private int topYInclusive;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initHeightCache(WritableLevelData properties, ResourceKey<?> registryRef, RegistryAccess registryManager, Holder<DimensionType> dimensionEntry, Supplier<?> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates, CallbackInfo ci) {
        this.height = ((DimensionType)dimensionEntry.m_203334_()).f_156648_();
        this.bottomY = ((DimensionType)dimensionEntry.m_203334_()).f_156647_();
        this.topYInclusive = this.bottomY + this.height - 1;
    }

    public int m_141928_() {
        return this.height;
    }

    public int m_141937_() {
        return this.bottomY;
    }

    public int m_151559_() {
        return (this.topYInclusive >> 4) + 1 - (this.bottomY >> 4);
    }

    public int m_151560_() {
        return this.bottomY >> 4;
    }

    public int m_151561_() {
        return (this.topYInclusive >> 4) + 1;
    }

    public boolean m_151570_(BlockPos pos) {
        int y = pos.m_123342_();
        return y < this.bottomY || y > this.topYInclusive;
    }

    public boolean m_151562_(int y) {
        return y < this.bottomY || y > this.topYInclusive;
    }

    public int m_151564_(int y) {
        return (y >> 4) - (this.bottomY >> 4);
    }

    public int m_151566_(int coord) {
        return coord - (this.bottomY >> 4);
    }

    public int m_151568_(int index) {
        return index + (this.bottomY >> 4);
    }

    public int m_151558_() {
        return this.topYInclusive + 1;
    }
}

