/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.PhilosophersStone;
import moze_intel.projecte.rendering.PERenderType;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class TransmutationRenderingOverlay
implements IGuiOverlay {
    private final Minecraft mc = Minecraft.m_91087_();
    @Nullable
    private BlockState transmutationResult;
    private long lastGameTime;

    public TransmutationRenderingOverlay() {
        MinecraftForge.EVENT_BUS.addListener(this::onOverlay);
    }

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        if (!this.mc.f_91066_.f_92062_ && this.transmutationResult != null) {
            long gameTime;
            Block block = this.transmutationResult.m_60734_();
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)liquidBlock.getFluid());
                int color = properties.getTintColor();
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
                TextureAtlasSprite sprite = (TextureAtlasSprite)this.mc.m_91258_(TextureAtlas.f_118259_).apply(properties.getStillTexture());
                graphics.m_280565_(1, 1, 0, 16, 16, sprite, red, green, blue, alpha);
            } else {
                graphics.m_280480_(new ItemStack((ItemLike)this.transmutationResult.m_60734_()), 1, 1);
            }
            long l = gameTime = this.mc.f_91073_ == null ? 0L : this.mc.f_91073_.m_46467_();
            if (this.lastGameTime != gameTime) {
                this.transmutationResult = null;
                this.lastGameTime = gameTime;
            }
        }
    }

    private void onOverlay(RenderHighlightEvent.Block event) {
        Item item;
        Camera activeRenderInfo = event.getCamera();
        Entity entity = activeRenderInfo.m_90592_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        this.lastGameTime = this.mc.f_91073_ == null ? 0L : this.mc.f_91073_.m_46467_();
        Level level = player.m_9236_();
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            stack = player.m_21206_();
        }
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof PhilosophersStone)) {
            this.transmutationResult = null;
            return;
        }
        PhilosophersStone philoStone = (PhilosophersStone)item;
        BlockHitResult rtr = philoStone.getHitBlock(player);
        if (rtr.m_6662_() == HitResult.Type.BLOCK) {
            BlockState current = level.m_8055_(rtr.m_82425_());
            this.transmutationResult = WorldTransmutations.getWorldTransmutation(current, player.m_36341_());
            if (this.transmutationResult != null) {
                Vec3 viewPosition = activeRenderInfo.m_90583_();
                int charge = philoStone.getCharge(stack);
                byte mode = philoStone.getMode(stack);
                float alpha = ProjectEConfig.client.pulsatingOverlay.get() ? this.getPulseProportion() * 0.6f : 0.35f;
                VertexConsumer builder = event.getMultiBufferSource().m_6299_(PERenderType.TRANSMUTATION_OVERLAY);
                PoseStack matrix = event.getPoseStack();
                matrix.m_85836_();
                matrix.m_85837_(-viewPosition.f_82479_, -viewPosition.f_82480_, -viewPosition.f_82481_);
                CollisionContext selectionContext = CollisionContext.m_82750_((Entity)player);
                for (BlockPos pos : PhilosophersStone.getChanges(level, rtr.m_82425_(), player, rtr.m_82434_(), mode, charge).keySet()) {
                    VoxelShape shape;
                    BlockState state = level.m_8055_(pos);
                    if (state.m_60795_() || (shape = state.m_60651_((BlockGetter)level, pos, selectionContext)).m_83281_()) continue;
                    matrix.m_85836_();
                    matrix.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                    Matrix4f matrix4f = matrix.m_85850_().m_252922_();
                    shape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> this.addBox(builder, matrix4f, alpha, (float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ));
                    matrix.m_85849_();
                }
                matrix.m_85849_();
            }
        } else {
            this.transmutationResult = null;
        }
    }

    private void addBox(VertexConsumer builder, Matrix4f matrix4f, float alpha, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        builder.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, minX, minY, minZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, minX, minY, minZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, minX, minY, minZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
    }

    private float getPulseProportion() {
        return (float)(0.5 * Math.sin((double)System.currentTimeMillis() / 350.0) + 0.5);
    }
}

