/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.api.jade;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import net.tarantel.chickenroost.api.jade.JadePlugin;
import net.tarantel.chickenroost.block.tile.Soul_Extractor_Tile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ProgressView;
import snownee.jade.api.view.ViewGroup;

public enum SoulExtractorProgressProvider implements IServerExtensionProvider<Soul_Extractor_Tile, CompoundTag>,
IClientExtensionProvider<CompoundTag, ProgressView>,
IServerDataProvider<BlockAccessor>,
IBlockComponentProvider
{
    INSTANCE;


    public List<ClientViewGroup<ProgressView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> groups) {
        return ClientViewGroup.map(groups, ProgressView::read, (group, clientGroup) -> {
            ProgressView view = (ProgressView)clientGroup.views.get(0);
            view.style.color(-16744448);
            view.text = Component.m_237113_((String)"Progress");
        });
    }

    @Nullable
    public List<ViewGroup<CompoundTag>> getGroups(ServerPlayer serverPlayer, ServerLevel serverLevel, Soul_Extractor_Tile tile, boolean b) {
        float period = tile.getScaledProgress();
        CompoundTag progress1 = ProgressView.create((float)(period / 200.0f));
        period = 200.0f;
        ViewGroup group = new ViewGroup(List.of(progress1));
        return List.of(group);
    }

    public ResourceLocation getUid() {
        return JadePlugin.SOULEXTRACTOR_PROGRESS;
    }

    public void appendTooltip(ITooltip tooltip, @NotNull BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getServerData().m_128441_("soul_extractor.progress")) {
            IElement icon = IElementHelper.get().item(new ItemStack((ItemLike)Items.f_42524_), 0.5f).size(new Vec2(10.0f, 10.0f)).translate(new Vec2(0.0f, -1.0f));
            icon.message(null);
            tooltip.add(icon);
            tooltip.append((Component)Component.m_237110_((String)"soulextractor.fuel", (Object[])new Object[]{accessor.getServerData().m_128451_("soul_extractor.progress")}));
        }
        MutableComponent test1 = Component.m_237113_((String)"1");
        MutableComponent test2 = Component.m_237113_((String)"2");
        MutableComponent test3 = Component.m_237113_((String)"3");
        tooltip.add(IElementHelper.get().text((Component)test2).align(IElement.Align.RIGHT));
        tooltip.add(IElementHelper.get().text((Component)test1).align(IElement.Align.LEFT));
        tooltip.append(IElementHelper.get().text((Component)test1).align(IElement.Align.RIGHT));
        tooltip.append(IElementHelper.get().text((Component)test2).align(IElement.Align.RIGHT));
        tooltip.append(IElementHelper.get().text((Component)test3).align(IElement.Align.RIGHT));
        tooltip.append(IElementHelper.get().text((Component)test2).align(IElement.Align.LEFT));
        tooltip.append(IElementHelper.get().text((Component)test3).align(IElement.Align.LEFT));
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        Soul_Extractor_Tile furnace = (Soul_Extractor_Tile)accessor.getBlockEntity();
        data.m_128405_("soul_extractor.progress", furnace.progress);
    }
}

