/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.tarantel.chickenroost.util.ChickenConfig;

public class BaseChickenEntity
extends Chicken {
    public int eggTime;
    public ItemStack dropStack;
    public Boolean IS_FIRE;
    public Boolean IS_PROJECTILE;
    public Boolean IS_EXPLOSION;
    public Boolean IS_FALL;
    public Boolean IS_DROWNING;
    public Boolean IS_FREEZING;
    public Boolean IS_LIGHTNING;
    public Boolean IS_WITHER;

    public BaseChickenEntity(EntityType<BaseChickenEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
        this.dropStack = ChickenConfig.getDropStack(type);
        this.eggTime = ChickenConfig.getEggTime(type);
        this.IS_FIRE = ChickenConfig.getIsFire(type);
        this.IS_PROJECTILE = ChickenConfig.getIsProjectile(type);
        this.IS_EXPLOSION = ChickenConfig.getIsExplosion(type);
        this.IS_FALL = ChickenConfig.getIsFall(type);
        this.IS_DROWNING = ChickenConfig.getIsDrowning(type);
        this.IS_FREEZING = ChickenConfig.getIsFreezing(type);
        this.IS_LIGHTNING = ChickenConfig.getIsLightning(type);
        this.IS_WITHER = ChickenConfig.getIsWither(type);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(this.dropStack);
    }

    public void m_8107_() {
        super.m_8107_();
        this.f_28229_ = this.f_28226_;
        this.f_28228_ = this.f_28227_;
        this.f_28227_ += (this.m_20096_() ? -1.0f : 4.0f) * 0.3f;
        this.f_28227_ = Mth.m_14036_((float)this.f_28227_, (float)0.0f, (float)1.0f);
        if (!this.m_20096_() && this.f_28230_ < 1.0f) {
            this.f_28230_ = 1.0f;
        }
        this.f_28230_ *= 0.9f;
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.f_28226_ += this.f_28230_ * 2.0f;
        if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && !this.m_28264_() && --this.eggTime <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19983_(this.dropStack);
            this.m_146850_(GameEvent.f_157810_);
            this.eggTime = this.f_19796_.m_188503_(6000) + 6000;
        }
    }

    public int m_213860_() {
        return this.m_28264_() ? 10 : super.m_213860_();
    }

    public void m_7378_(CompoundTag p_28243_) {
        super.m_7378_(p_28243_);
        this.f_28232_ = p_28243_.m_128471_("IsChickenJockey");
        if (p_28243_.m_128441_("EggLayTime")) {
            this.eggTime = p_28243_.m_128451_("EggLayTime");
        }
    }

    public void m_7380_(CompoundTag p_28257_) {
        super.m_7380_(p_28257_);
        p_28257_.m_128379_("IsChickenJockey", this.f_28232_);
        p_28257_.m_128405_("EggLayTime", this.eggTime);
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.chicken.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.chicken.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.chicken.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.chicken.death"));
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (damageSource.m_276093_(DamageTypes.f_268468_) || damageSource.m_276093_(DamageTypes.f_268546_) || damageSource.m_276093_(DamageTypes.f_268631_) || damageSource.m_276093_(DamageTypes.f_268684_) || damageSource.m_276093_(DamageTypes.f_268428_) || damageSource.m_276093_(DamageTypes.f_268556_)) {
            if (this.IS_FIRE.booleanValue()) {
                return super.m_6469_(damageSource, amount);
            }
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268739_) || damageSource.m_276093_(DamageTypes.f_268534_)) {
            if (this.IS_PROJECTILE.booleanValue()) {
                return super.m_6469_(damageSource, amount);
            }
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268565_) || damageSource.m_276093_(DamageTypes.f_268448_)) {
            if (this.IS_EXPLOSION.booleanValue()) {
                return super.m_6469_(damageSource, amount);
            }
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268671_)) {
            if (this.IS_FALL.booleanValue()) {
                return super.m_6469_(damageSource, amount);
            }
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268722_)) {
            if (this.IS_DROWNING.booleanValue()) {
                return super.m_6469_(damageSource, amount);
            }
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268444_)) {
            if (this.IS_FREEZING.booleanValue()) {
                return super.m_6469_(damageSource, amount);
            }
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268450_)) {
            if (this.IS_LIGHTNING.booleanValue()) {
                return super.m_6469_(damageSource, amount);
            }
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268493_) || damageSource.m_276093_(DamageTypes.f_268641_)) {
            if (this.IS_WITHER.booleanValue()) {
                return super.m_6469_(damageSource, amount);
            }
            return false;
        }
        System.out.println("DamageSource: " + damageSource.toString());
        return super.m_6469_(damageSource, amount);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder m_28263_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 3.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }
}

