/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.armory;

import com.enderio.armory.common.config.ArmoryConfig;
import com.enderio.armory.common.init.ArmoryItems;
import com.enderio.armory.common.init.ArmoryLootModifiers;
import com.enderio.armory.common.init.ArmoryRecipes;
import com.enderio.armory.common.tag.ArmoryTags;
import com.enderio.armory.data.loot.ArmoryLootModifiersProvider;
import com.enderio.armory.data.recipe.ItemRecipeProvider;
import com.enderio.armory.data.tags.ArmoryBlockTagsProvider;
import com.enderio.base.data.EIODataProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod.EventBusSubscriber(modid="enderio", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EIOArmory {
    @SubscribeEvent
    public static void onConstruct(FMLConstructModEvent event) {
        ModLoadingContext ctx = ModLoadingContext.get();
        ctx.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ArmoryConfig.COMMON_SPEC, "enderio/armory-common.toml");
        ctx.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ArmoryConfig.CLIENT_SPEC, "enderio/armory-client.toml");
        ArmoryItems.register();
        ArmoryRecipes.register();
        ArmoryLootModifiers.register();
        ArmoryTags.register();
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = event.getGenerator().getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        EIODataProvider provider = new EIODataProvider("armory");
        provider.addSubProvider(event.includeServer(), (DataProvider)new ItemRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ArmoryLootModifiersProvider(packOutput));
        ArmoryBlockTagsProvider b = new ArmoryBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
        provider.addSubProvider(event.includeServer(), (DataProvider)b);
        event.getGenerator().addProvider(true, (DataProvider)provider);
    }
}

