/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.tool;

import com.enderio.base.common.init.EIOFluids;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.base.common.util.ExperienceUtil;
import com.enderio.core.common.network.CoreNetwork;
import com.enderio.core.common.network.EmitParticlePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ExperienceRodItem
extends Item {
    public ExperienceRodItem(Item.Properties pProperties) {
        super(pProperties.m_41487_(1));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        boolean wasSuccess = player.m_6144_() ? ExperienceRodItem.transferFromPlayerToBlock(player, level, pos) : ExperienceRodItem.transferFromBlockToPlayer(player, level, pos);
        if (wasSuccess) {
            CoreNetwork.sendToTracking(level.m_46745_(pos), new EmitParticlePacket((ParticleOptions)ParticleTypes.f_123811_, pos, 0.2, 0.8, 0.2));
            level.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.5f * ((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.7f + 1.8f));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return false;
    }

    private static boolean transferFromBlockToPlayer(Player player, Level level, BlockPos pos) {
        try {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity != null) {
                return blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).map(fluidHandler -> {
                    int requiredXp;
                    int fluidVolume;
                    FluidStack drained;
                    FluidStack availableFluid = fluidHandler.getFluidInTank(0);
                    if (availableFluid.getFluid().m_205067_(EIOTags.Fluids.EXPERIENCE) && availableFluid.getAmount() > 0 && !(drained = fluidHandler.drain(fluidVolume = (requiredXp = player.m_36323_()) * ExperienceUtil.EXP_TO_FLUID, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                        player.m_6756_(drained.getAmount() / ExperienceUtil.EXP_TO_FLUID);
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
        }
        catch (ArithmeticException ex) {
            player.m_5661_(EIOLang.TOO_MANY_LEVELS, true);
        }
        return false;
    }

    private static boolean transferFromPlayerToBlock(Player player, Level level, BlockPos pos) {
        try {
            if (player.f_36078_ <= 0 && player.f_36080_ <= 0.0f) {
                return false;
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity != null) {
                return blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).map(fluidHandler -> {
                    long fluidVolume = ExperienceUtil.getPlayerTotalXp(player) * (long)ExperienceUtil.EXP_TO_FLUID;
                    int cappedVolume = (int)Math.min(Integer.MAX_VALUE, fluidVolume);
                    FluidStack fs = new FluidStack((Fluid)EIOFluids.XP_JUICE.getSource(), cappedVolume);
                    int takenVolume = fluidHandler.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                    if (takenVolume > 0) {
                        player.m_6756_(-takenVolume / ExperienceUtil.EXP_TO_FLUID);
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
        }
        catch (ArithmeticException ex) {
            player.m_5661_(EIOLang.TOO_MANY_LEVELS, true);
        }
        return false;
    }
}

