/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules.entries;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.FloatingRectangle;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.modules.AbstractMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class SubMenuEntry
extends AbstractMenuEntry {
    public final Component text;
    private int textWidth = -69;
    protected List<FavoriteMenuEntry> entries;
    protected Menu parent;
    protected Menu childMenu;

    public SubMenuEntry(Component text) {
        this(text, Collections.emptyList());
    }

    public SubMenuEntry(Component text, Supplier<List<FavoriteMenuEntry>> entries) {
        this(text, entries.get());
    }

    public SubMenuEntry(Component text, List<FavoriteMenuEntry> entries) {
        this.text = (Component)MoreObjects.firstNonNull((Object)text, (Object)Component.m_237119_());
        this.entries = entries;
    }

    public void setParent(Menu parent) {
        this.parent = parent;
    }

    private int getTextWidth() {
        if (this.textWidth == -69) {
            this.textWidth = Math.max(0, this.font.m_92852_((FormattedText)this.text));
        }
        return this.textWidth;
    }

    public Menu getChildMenu() {
        if (this.childMenu == null) {
            this.childMenu = new Menu(new Rectangle(this.parent.getBounds().x + 1, this.getY() - 1, this.parent.getBounds().width - 2, this.getEntryHeight() - 2), this.entries, false);
        }
        return this.childMenu;
    }

    @Override
    public int getEntryWidth() {
        return 12 + this.getTextWidth() + 4;
    }

    @Override
    public int getEntryHeight() {
        return 12;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, this.getX(), this.getY(), this.getWidth(), this.getEntryHeight());
        if (this.isSelected()) {
            if (!this.entries.isEmpty()) {
                int newX;
                int newY;
                Menu menu = this.getChildMenu();
                Rectangle menuStart = new Rectangle(this.parent.getBounds().x, this.getY(), this.parent.getBounds().width, this.getEntryHeight());
                int fullWidth = Minecraft.m_91087_().f_91080_.f_96543_;
                int fullHeight = Minecraft.m_91087_().f_91080_.f_96544_;
                boolean facingRight = this.parent.facingRight;
                int menuWidth = menu.getMaxEntryWidth() + 2 + (menu.hasScrollBar() ? 6 : 0);
                if (facingRight && fullWidth - menuStart.getMaxX() < menuWidth + 10) {
                    facingRight = false;
                } else if (!facingRight && menuStart.x < menuWidth + 10) {
                    facingRight = true;
                }
                boolean facingDownwards = fullHeight - menuStart.getMaxY() > menuStart.y;
                int n = newY = facingDownwards ? menuStart.y - 1 : menuStart.getMaxY() - (menu.scrolling.getMaxScrollHeight() + 1);
                int n2 = facingRight ? menuStart.getMaxX() : (newX = menuStart.x - (menu.getMaxEntryWidth() + 2 + (menu.scrolling.getMaxScrollHeight() > menu.getInnerHeight(menu.menuStartPoint.y) ? 6 : 0)));
                if (!menu.menuStartPoint.equals((Object)new Point(newX, newY))) {
                    menu.menuStartPoint.setLocation((double)newX, (double)newY);
                    Rectangle createBounds = menu.createBounds();
                    menu.bounds.setAs((Object)new FloatingRectangle(facingRight ? (double)createBounds.x : (double)createBounds.getMaxX(), facingDownwards ? (double)createBounds.y : (double)createBounds.getMaxY(), 0.1, 0.1));
                }
                ArrayList areas = Lists.newArrayList((Iterable)ScissorsHandler.INSTANCE.getScissorsAreas());
                ScissorsHandler.INSTANCE.clearScissors();
                menu.m_88315_(graphics, mouseX, mouseY, delta);
                for (Rectangle area : areas) {
                    ScissorsHandler.INSTANCE.scissor(area);
                }
            }
        } else {
            this.childMenu = null;
        }
        graphics.m_280614_(this.font, this.text, this.getX() + 2, this.getY() + 2, this.isSelected() ? 0xFFFFFF : 0x888888, false);
        if (!this.entries.isEmpty()) {
            graphics.m_280218_(InternalTextures.CHEST_GUI_TEXTURE, this.getX() + this.getWidth() - 15, this.getY() - 2, 0, 28, 18, 18);
        }
    }

    protected void renderBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        if (this.isSelected()) {
            graphics.m_280509_(x, y, x + width, y + height, -12237499);
        }
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        if (super.containsMouse(mouseX, mouseY)) {
            return true;
        }
        if (this.childMenu != null && !this.childMenu.m_6702_().isEmpty() && this.isSelected()) {
            return this.childMenu.containsMouse(mouseX, mouseY);
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        return this.childMenu != null && !this.childMenu.m_6702_().isEmpty() && this.isSelected() && this.childMenu.m_6050_(mouseX, mouseY, amount);
    }

    public List<? extends GuiEventListener> m_6702_() {
        if (this.childMenu != null && !this.childMenu.m_6702_().isEmpty() && this.isSelected()) {
            return Collections.singletonList(this.childMenu);
        }
        return Collections.emptyList();
    }
}

