/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.movingelevators.elevator.ElevatorCabinLevel;
import com.supermartijn642.movingelevators.elevator.ElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ClientElevatorCage
extends ElevatorCage {
    private static ElevatorCabinLevel level;
    private BlockPos renderPos = null;
    public final BlockEntity[][][] blockEntities;

    public static Level getFakeLevel() {
        return level;
    }

    public ClientElevatorCage(int xSize, int ySize, int zSize, BlockState[][][] states, CompoundTag[][][] blockEntityData, CompoundTag[][][] blockEntityStacks, List<AABB> collisionBoxes) {
        super(xSize, ySize, zSize, states, blockEntityData, blockEntityStacks, collisionBoxes);
        this.blockEntities = new BlockEntity[xSize][ySize][zSize];
    }

    public void loadRenderInfo(BlockPos renderPos, ElevatorGroup group) {
        if (level == null) {
            level = new ElevatorCabinLevel(ClientUtils.getWorld());
        }
        level.setCabinAndPos(ClientUtils.getWorld(), this, group, renderPos);
        if (renderPos.equals((Object)this.renderPos)) {
            return;
        }
        this.renderPos = renderPos;
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    CompoundTag entityData;
                    String identifier;
                    BlockEntityType entityType;
                    this.blockEntities[x][y][z] = null;
                    if (this.blockStates[x][y][z] == null || this.blockEntityData[x][y][z] == null || (entityType = (BlockEntityType)Registries.BLOCK_ENTITY_TYPES.getValue(new ResourceLocation(identifier = (entityData = this.blockEntityData[x][y][z]).m_128461_("id")))) == null) continue;
                    BlockState state = this.blockStates[x][y][z];
                    BlockPos pos = new BlockPos(renderPos.m_123341_() + x, renderPos.m_123342_() + y, renderPos.m_123343_() + z);
                    BlockEntity entity = entityType.m_155264_(pos, state);
                    if (entity == null) continue;
                    entity.m_142466_(entityData);
                    entity.m_142339_((Level)level);
                    this.blockEntities[x][y][z] = entity;
                }
            }
        }
    }
}

