/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.movingelevators.elevator.ClientElevatorCage;
import com.supermartijn642.movingelevators.extensions.MovingElevatorsLevelChunk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ElevatorCage {
    public final int xSize;
    public final int ySize;
    public final int zSize;
    public final BlockState[][][] blockStates;
    public final CompoundTag[][][] blockEntityData;
    public final CompoundTag[][][] blockEntityStacks;
    public final VoxelShape shape;
    public final List<AABB> collisionBoxes;
    public final AABB bounds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElevatorCage createCageAndClear(Level level, BlockPos startPos, int xSize, int ySize, int zSize) {
        BlockPos pos;
        int z;
        int y;
        int x;
        if (!ElevatorCage.canCreateCage(level, startPos, xSize, ySize, zSize)) {
            return null;
        }
        BlockState[][][] states = new BlockState[xSize][ySize][zSize];
        CompoundTag[][][] entities = new CompoundTag[xSize][ySize][zSize];
        CompoundTag[][][] entityItemStacks = new CompoundTag[xSize][ySize][zSize];
        VoxelShape shape = Shapes.m_83040_();
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    pos = startPos.m_7918_(x, y, z);
                    if (ElevatorCage.canBlockBeIgnored(level, pos)) continue;
                    states[x][y][z] = level.m_8055_(pos);
                    VoxelShape blockShape = states[x][y][z].m_60812_((BlockGetter)level, pos);
                    blockShape = blockShape.m_83216_((double)x, (double)y, (double)z);
                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)blockShape, (BooleanOp)BooleanOp.f_82695_);
                    BlockEntity entity = level.m_7702_(pos);
                    if (entity == null) continue;
                    CompoundTag tag = entity.m_187480_();
                    tag.m_128405_("x", x);
                    tag.m_128405_("y", y);
                    tag.m_128405_("z", z);
                    entities[x][y][z] = tag;
                    ItemStack stack = new ItemStack((ItemLike)states[x][y][z].m_60734_());
                    tag = tag.m_6426_();
                    tag.m_128473_("x");
                    tag.m_128473_("y");
                    tag.m_128473_("z");
                    stack.m_41700_("BlockEntityTag", (Tag)tag);
                    CompoundTag displayTag = new CompoundTag();
                    ListTag loreTag = new ListTag();
                    loreTag.add((Object)StringTag.m_129297_((String)"\"(+NBT)\""));
                    displayTag.m_128365_("Lore", (Tag)loreTag);
                    stack.m_41700_("display", (Tag)displayTag);
                    entityItemStacks[x][y][z] = stack.serializeNBT();
                }
            }
        }
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    LevelChunk chunk;
                    pos = startPos.m_7918_(x, y, z);
                    if (states[x][y][z] == null) continue;
                    BlockEntity entity = level.m_7702_(pos);
                    if (entity != null) {
                        Clearable.m_18908_((Object)entity);
                        level.m_46747_(pos);
                    }
                    if ((chunk = level.m_46745_(pos)) != null) {
                        ((MovingElevatorsLevelChunk)chunk).movingElevatorsSuppressBlockUpdates(true);
                        try {
                            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 20);
                            continue;
                        }
                        finally {
                            ((MovingElevatorsLevelChunk)chunk).movingElevatorsSuppressBlockUpdates(false);
                        }
                    }
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 20);
                }
            }
        }
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    pos = startPos.m_7918_(x, y, z);
                    BlockState state = states[x][y][z];
                    if (states[x][y][z] == null) continue;
                    BlockState newState = level.m_8055_(pos);
                    state.m_60753_(level, pos, newState, false);
                    level.markAndNotifyBlock(pos, level.m_46745_(pos), states[x][y][z], newState, 3, 512);
                }
            }
        }
        shape.m_83296_();
        return level.f_46443_ ? new ClientElevatorCage(xSize, ySize, zSize, states, entities, entityItemStacks, shape.m_83299_()) : new ElevatorCage(xSize, ySize, zSize, states, entities, entityItemStacks, shape.m_83299_());
    }

    public static boolean canCreateCage(Level level, BlockPos startPos, int xSize, int ySize, int zSize) {
        boolean hasBlocks = false;
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    if (ElevatorCage.canBlockBeIgnored(level, startPos.m_7918_(x, y, z))) continue;
                    if (!ElevatorCage.canBlockBeInCage(level, startPos.m_7918_(x, y, z))) {
                        return false;
                    }
                    hasBlocks = true;
                }
            }
        }
        return hasBlocks;
    }

    public static boolean canBlockBeIgnored(Level level, BlockPos pos) {
        return level.m_46859_(pos) || level.m_8055_(pos).m_60713_(Blocks.f_152480_);
    }

    public static boolean canBlockBeInCage(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60819_().m_76178_() && state.m_60800_((BlockGetter)level, pos) >= 0.0f;
    }

    public ElevatorCage(int xSize, int ySize, int zSize, BlockState[][][] states, CompoundTag[][][] blockEntityData, CompoundTag[][][] blockEntityStacks, List<AABB> collisionBoxes) {
        this.blockEntityData = blockEntityData;
        this.blockEntityStacks = blockEntityStacks;
        if (states.length != xSize || states[0].length != ySize || states[0][0].length != zSize) {
            throw new IllegalArgumentException("Given size and block state array do not match!");
        }
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.blockStates = states;
        this.collisionBoxes = Collections.unmodifiableList(collisionBoxes);
        VoxelShape shape = Shapes.m_83040_();
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (AABB box : collisionBoxes) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)box), (BooleanOp)BooleanOp.f_82695_);
            minX = Math.min(minX, box.f_82288_);
            minY = Math.min(minY, box.f_82289_);
            minZ = Math.min(minZ, box.f_82290_);
            maxX = Math.max(maxX, box.f_82291_);
            maxY = Math.max(maxY, box.f_82292_);
            maxZ = Math.max(maxZ, box.f_82293_);
        }
        this.shape = shape.m_83296_();
        this.bounds = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void place(Level level, BlockPos startPos) {
        BlockPos pos;
        int z;
        int y;
        int x;
        BlockState[][][] oldStates = new BlockState[this.xSize][this.ySize][this.zSize];
        for (x = 0; x < this.xSize; ++x) {
            for (y = 0; y < this.ySize; ++y) {
                for (z = 0; z < this.zSize; ++z) {
                    BlockState state = this.blockStates[x][y][z];
                    if (state == null) continue;
                    pos = startPos.m_7918_(x, y, z);
                    BlockState currentState = level.m_8055_(pos);
                    if (ElevatorCage.canBlockBeIgnored(level, pos) || currentState.m_60800_((BlockGetter)level, pos) >= 0.0f) {
                        BlockEntity entity;
                        LevelChunk chunk;
                        oldStates[x][y][z] = currentState;
                        if (!level.m_46859_(pos)) {
                            level.m_46961_(pos, true);
                        }
                        if ((chunk = level.m_46745_(pos)) != null) {
                            ((MovingElevatorsLevelChunk)chunk).movingElevatorsSuppressBlockUpdates(true);
                            try {
                                level.m_7731_(pos, state, 20);
                            }
                            finally {
                                ((MovingElevatorsLevelChunk)chunk).movingElevatorsSuppressBlockUpdates(false);
                            }
                        } else {
                            level.m_7731_(pos, state, 20);
                        }
                        if (this.blockEntityData[x][y][z] == null || (entity = BlockEntity.m_155241_((BlockPos)pos, (BlockState)state, (CompoundTag)this.blockEntityData[x][y][z])) == null) continue;
                        level.m_151523_(entity);
                        continue;
                    }
                    CompoundTag itemTag = this.blockEntityStacks[x][y][z];
                    ItemStack stack = itemTag == null ? new ItemStack((ItemLike)state.m_60734_()) : ItemStack.m_41712_((CompoundTag)itemTag);
                    Containers.m_18992_((Level)level, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
                }
            }
        }
        for (x = 0; x < this.xSize; ++x) {
            for (y = 0; y < this.ySize; ++y) {
                for (z = 0; z < this.zSize; ++z) {
                    BlockState previousState = oldStates[x][y][z];
                    if (previousState == null) continue;
                    pos = startPos.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    state.m_60696_(level, pos, previousState, true);
                    boolean isOnTheBoundary = x == 0 || x == this.xSize - 1 || y == 0 || y == this.ySize - 1 || z == 0 || z == this.zSize - 1;
                    int flags = isOnTheBoundary ? 3 : 22;
                    level.markAndNotifyBlock(pos, level.m_46745_(pos), previousState, state, flags, 512);
                    if (!level.f_46443_ && state.m_60734_() instanceof ButtonBlock && state.m_61138_((Property)ButtonBlock.f_51045_) && ((Boolean)state.m_61143_((Property)ButtonBlock.f_51045_)).booleanValue()) {
                        state.m_222963_((ServerLevel)level, pos, level.f_46441_);
                    }
                    if (!level.f_46443_ && state.m_60734_() instanceof PressurePlateBlock && state.m_61138_((Property)PressurePlateBlock.f_55249_) && ((Boolean)state.m_61143_((Property)PressurePlateBlock.f_55249_)).booleanValue()) {
                        state.m_222963_((ServerLevel)level, pos, level.f_46441_);
                    }
                    if (!state.m_60713_(Blocks.f_50088_)) continue;
                    boolean[] updateDirections = new boolean[6];
                    updateDirections[4] = x == 0;
                    updateDirections[5] = x == this.xSize - 1;
                    updateDirections[0] = y == 0;
                    updateDirections[1] = y == this.ySize - 1;
                    updateDirections[2] = z == 0;
                    updateDirections[3] = z == this.zSize - 1;
                    for (int i = 0; i < updateDirections.length; ++i) {
                        if (!updateDirections[i]) continue;
                        Direction direction = Direction.values()[i];
                        level.m_46672_(pos.m_121945_(direction), Blocks.f_50088_);
                    }
                }
            }
        }
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    if (this.blockStates[x][y][z] == null) continue;
                    if (this.blockEntityStacks[x][y][z] != null) {
                        drops.add(ItemStack.m_41712_((CompoundTag)this.blockEntityStacks[x][y][z]));
                        continue;
                    }
                    drops.add(new ItemStack((ItemLike)this.blockStates[x][y][z].m_60734_()));
                }
            }
        }
        return drops;
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("xSize", this.xSize);
        compound.m_128405_("ySize", this.ySize);
        compound.m_128405_("zSize", this.zSize);
        int[] stateIds = new int[this.xSize * this.ySize * this.zSize];
        ListTag entityData = new ListTag();
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    int index = x * this.ySize * this.zSize + y * this.zSize + z;
                    BlockState state = this.blockStates[x][y][z];
                    stateIds[index] = Block.m_49956_((BlockState)(state == null || state.m_60734_() == Blocks.f_50016_ ? Blocks.f_50016_.m_49966_() : state));
                    if (this.blockEntityData[x][y][z] == null) continue;
                    CompoundTag tag = new CompoundTag();
                    tag.m_128405_("x", x);
                    tag.m_128405_("y", y);
                    tag.m_128405_("z", z);
                    tag.m_128365_("data", (Tag)this.blockEntityData[x][y][z]);
                    tag.m_128365_("stack", (Tag)this.blockEntityStacks[x][y][z]);
                    entityData.add((Object)tag);
                }
            }
        }
        compound.m_128385_("blockStates", stateIds);
        compound.m_128365_("entityData", (Tag)entityData);
        ListTag collisionBoxList = new ListTag();
        this.collisionBoxes.forEach(box -> collisionBoxList.add((Object)ElevatorCage.writeBox(box)));
        compound.m_128365_("collisionBoxes", (Tag)collisionBoxList);
        return compound;
    }

    public static ElevatorCage read(CompoundTag compound, boolean isClientSide) {
        int xSize = compound.m_128451_("xSize");
        int ySize = compound.m_128451_("ySize");
        int zSize = compound.m_128451_("zSize");
        int[] stateIds = compound.m_128465_("blockStates");
        BlockState[][][] blockStates = new BlockState[xSize][ySize][zSize];
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    int index = x * ySize * zSize + y * zSize + z;
                    BlockState state = Block.m_49803_((int)stateIds[index]);
                    blockStates[x][y][z] = state.m_60734_() == Blocks.f_50016_ ? null : state;
                }
            }
        }
        CompoundTag[][][] entityTags = new CompoundTag[xSize][ySize][zSize];
        CompoundTag[][][] stackTags = new CompoundTag[xSize][ySize][zSize];
        if (compound.m_128425_("entityData", 9)) {
            ListTag entityData = compound.m_128437_("entityData", 10);
            for (Tag tag : entityData) {
                int x = ((CompoundTag)tag).m_128451_("x");
                int y = ((CompoundTag)tag).m_128451_("y");
                int z = ((CompoundTag)tag).m_128451_("z");
                entityTags[x][y][z] = ((CompoundTag)tag).m_128469_("data");
                stackTags[x][y][z] = ((CompoundTag)tag).m_128469_("stack");
            }
        }
        ListTag collisionBoxList = compound.m_128437_("collisionBoxes", 10);
        List<AABB> collisionBoxes = collisionBoxList.stream().map(CompoundTag.class::cast).map(ElevatorCage::readBox).collect(Collectors.toList());
        return isClientSide ? new ClientElevatorCage(xSize, ySize, zSize, blockStates, entityTags, stackTags, collisionBoxes) : new ElevatorCage(xSize, ySize, zSize, blockStates, entityTags, stackTags, collisionBoxes);
    }

    private static CompoundTag writeBox(AABB box) {
        CompoundTag compound = new CompoundTag();
        compound.m_128347_("x1", box.f_82288_);
        compound.m_128347_("y1", box.f_82289_);
        compound.m_128347_("z1", box.f_82290_);
        compound.m_128347_("x2", box.f_82291_);
        compound.m_128347_("y2", box.f_82292_);
        compound.m_128347_("z2", box.f_82293_);
        return compound;
    }

    private static AABB readBox(CompoundTag compound) {
        return new AABB(compound.m_128459_("x1"), compound.m_128459_("y1"), compound.m_128459_("z1"), compound.m_128459_("x2"), compound.m_128459_("y2"), compound.m_128459_("z2"));
    }
}

