/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderHighlightEvent;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import xfacthd.framedblocks.api.render.OutlineRenderer;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.render.util.FramedRenderTypes;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.NullableDirection;

public final class CollapsibleBlockIndicatorRenderer {
    private static final double[] VERTEX_NO_OFFSET = new double[]{1.0, 1.0, 1.0, 1.0};

    public static void onRenderBlockHighlight(RenderHighlightEvent.Block event) {
        ItemStack heldItem = Minecraft.m_91087_().f_91074_.m_21205_();
        if (heldItem.m_41720_() != FBContent.ITEM_FRAMED_HAMMER.get()) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        BlockHitResult hit = event.getTarget();
        BlockState state = level.m_8055_(hit.m_82425_());
        if (state.m_60734_() != FBContent.BLOCK_FRAMED_COLLAPSIBLE_BLOCK.get()) {
            return;
        }
        NullableDirection face = (NullableDirection)((Object)state.m_61143_(PropertyHolder.NULLABLE_FACE));
        Direction faceDir = hit.m_82434_();
        if (face != NullableDirection.NONE && face.toDirection() != faceDir) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Vec3 offset = Vec3.m_82528_((Vec3i)hit.m_82425_()).m_82546_(event.getCamera().m_90583_());
        VertexConsumer builder = event.getMultiBufferSource().m_6299_(FramedRenderTypes.LINES_NO_DEPTH);
        poseStack.m_85836_();
        poseStack.m_85837_(offset.f_82479_ + 0.5, offset.f_82480_ + 0.5, offset.f_82481_ + 0.5);
        if (faceDir == Direction.DOWN) {
            poseStack.m_252781_(Quaternions.XP_180);
        } else if (faceDir != Direction.UP) {
            poseStack.m_252781_(OutlineRenderer.YN_DIR[faceDir.m_122416_()]);
            poseStack.m_252781_(Quaternions.XP_90);
        }
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        double[] vY = CollapsibleBlockIndicatorRenderer.getVertexHeights((Level)level, hit.m_82425_(), face);
        CollapsibleBlockIndicatorRenderer.drawSectionOverlay(builder, poseStack, vY);
        CollapsibleBlockIndicatorRenderer.drawCornerMarkers(builder, poseStack, faceDir, hit, vY);
        poseStack.m_85849_();
    }

    private static double[] getVertexHeights(Level level, BlockPos pos, NullableDirection face) {
        BlockEntity blockEntity;
        if (face == NullableDirection.NONE || !((blockEntity = level.m_7702_(pos)) instanceof FramedCollapsibleBlockEntity)) {
            return VERTEX_NO_OFFSET;
        }
        FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
        byte[] offsets = be.getVertexOffsets();
        return new double[]{1.0 - (double)offsets[0] / 16.0, 1.0 - (double)offsets[1] / 16.0, 1.0 - (double)offsets[2] / 16.0, 1.0 - (double)offsets[3] / 16.0};
    }

    private static void drawSectionOverlay(VertexConsumer builder, PoseStack poseStack, double[] vY) {
        double cenx = Mth.m_14139_((double)0.5, (double)vY[0], (double)vY[1]);
        double cepx = Mth.m_14139_((double)0.5, (double)vY[3], (double)vY[2]);
        double cenz = Mth.m_14139_((double)0.5, (double)vY[0], (double)vY[3]);
        double cepz = Mth.m_14139_((double)0.5, (double)vY[1], (double)vY[2]);
        double cinx = Mth.m_14139_((double)0.25, (double)cenx, (double)cepx);
        double cipx = Mth.m_14139_((double)0.75, (double)cenx, (double)cepx);
        double cinz = Mth.m_14139_((double)0.25, (double)cenz, (double)cepz);
        double cipz = Mth.m_14139_((double)0.75, (double)cenz, (double)cepz);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.5, cenz, 0.0, 0.5, cinz, 0.25);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.5, cipz, 0.75, 0.5, cepz, 1.0);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.0, cenx, 0.5, 0.25, cinx, 0.5);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.75, cipx, 0.5, 1.0, cepx, 0.5);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.5, cinz, 0.25, 0.25, cinx, 0.5);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.5, cinz, 0.25, 0.75, cipx, 0.5);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.5, cipz, 0.75, 0.25, cinx, 0.5);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.5, cipz, 0.75, 0.75, cipx, 0.5);
    }

    private static void drawCornerMarkers(VertexConsumer builder, PoseStack poseStack, Direction faceDir, BlockHitResult hit, double[] vY) {
        int vert = FramedCollapsibleBlockEntity.vertexFromHit(faceDir, Utils.fraction(hit.m_82450_()));
        if (vert == 0 || vert == 4) {
            CollapsibleBlockIndicatorRenderer.drawCubeFrame(builder, poseStack, 0.015625, 0.015625, vY[0]);
        }
        if (vert == 1 || vert == 4) {
            CollapsibleBlockIndicatorRenderer.drawCubeFrame(builder, poseStack, 0.015625, 0.984375, vY[1]);
        }
        if (vert == 2 || vert == 4) {
            CollapsibleBlockIndicatorRenderer.drawCubeFrame(builder, poseStack, 0.984375, 0.984375, vY[2]);
        }
        if (vert == 3 || vert == 4) {
            CollapsibleBlockIndicatorRenderer.drawCubeFrame(builder, poseStack, 0.984375, 0.015625, vY[3]);
        }
    }

    private static void drawCubeFrame(VertexConsumer builder, PoseStack poseStack, double x, double z, double vY) {
        double minX = x - 0.03125;
        double maxX = x + 0.03125;
        double minZ = z - 0.03125;
        double maxZ = z + 0.03125;
        double minY = vY - 0.046875;
        double maxY = vY + 0.015625;
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, minY, minZ, minX, minY, maxZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, minY, minZ, maxX, minY, minZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, maxX, minY, minZ, maxX, minY, maxZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, minY, maxZ, maxX, minY, maxZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, maxY, minZ, minX, maxY, maxZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, maxY, minZ, maxX, maxY, minZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, maxX, maxY, minZ, maxX, maxY, maxZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, maxY, maxZ, maxX, maxY, maxZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, minY, minZ, minX, maxY, minZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, minY, maxZ, minX, maxY, maxZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, maxX, minY, minZ, maxX, maxY, minZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, maxX, minY, maxZ, maxX, maxY, maxZ);
    }

    private static void drawLine(VertexConsumer builder, PoseStack poseStack, double x1, double y1, double z1, double x2, double y2, double z2) {
        float nX = (float)(x2 - x1);
        float nY = (float)(y2 - y1);
        float nZ = (float)(z2 - z1);
        float nLen = Mth.m_14116_((float)(nX * nX + nY * nY + nZ * nZ));
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        builder.m_252986_(pose, (float)x1, (float)y1, (float)z1).m_85950_(1.0f, 0.0f, 0.0f, 0.6f).m_252939_(normal, nX /= nLen, nY /= nLen, nZ /= nLen).m_5752_();
        builder.m_252986_(pose, (float)x2, (float)y2, (float)z2).m_85950_(1.0f, 0.0f, 0.0f, 0.6f).m_252939_(normal, nX, nY, nZ).m_5752_();
    }

    private CollapsibleBlockIndicatorRenderer() {
    }
}

