/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.mifa.client;

import com.buuz135.industrial.item.addon.EfficiencyAddonItem;
import com.buuz135.industrial.item.addon.ProcessingAddonItem;
import com.buuz135.industrial.item.addon.SpeedAddonItem;
import com.buuz135.industrial.module.ModuleCore;
import com.christofmeg.mifa.common.item.ModEfficiencyAddonItem;
import com.christofmeg.mifa.common.item.ModProcessingAddonItem;
import com.christofmeg.mifa.common.item.ModSpeedAddonItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="mifa", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientForgeEvents {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (item instanceof EfficiencyAddonItem) {
            float tier = 0.0f;
            if (item == ModuleCore.EFFICIENCY_ADDON_1.get()) {
                tier = 1.0f;
            } else if (item == ModuleCore.EFFICIENCY_ADDON_2.get()) {
                tier = 2.0f;
            } else if (item instanceof ModEfficiencyAddonItem) {
                ModEfficiencyAddonItem addonItem = (ModEfficiencyAddonItem)item;
                tier = addonItem.tier;
            }
            float reduction = tier * -10.0f;
            event.getToolTip().add(Component.m_237115_((String)(Component.m_237115_((String)"item.mifa.cooldown_amount").getString() + ": " + reduction + "%")).m_130940_(ChatFormatting.GRAY));
        } else if (item instanceof ProcessingAddonItem) {
            float tier = 0.0f;
            if (item == ModuleCore.PROCESSING_ADDON_1.get()) {
                tier = 1.0f;
            } else if (item == ModuleCore.PROCESSING_ADDON_2.get()) {
                tier = 2.0f;
            } else if (item instanceof ModProcessingAddonItem) {
                ModProcessingAddonItem addonItem = (ModProcessingAddonItem)item;
                tier = addonItem.tier;
            }
            float upgrade = 1.0f + tier;
            event.getToolTip().add(Component.m_237115_((String)(Component.m_237115_((String)"item.industrialforegoing.processing").getString().replace(" ", "") + ": x" + upgrade)).m_130940_(ChatFormatting.GRAY));
        } else if (item instanceof SpeedAddonItem) {
            float tier = 0.0f;
            if (item == ModuleCore.SPEED_ADDON_1.get()) {
                tier = 1.0f;
            } else if (item == ModuleCore.SPEED_ADDON_2.get()) {
                tier = 2.0f;
            } else if (item instanceof ModSpeedAddonItem) {
                ModSpeedAddonItem addonItem = (ModSpeedAddonItem)item;
                tier = addonItem.tier;
            }
            float reduction = (1.0f - 1.0f / (1.0f + tier)) * -100.0f;
            event.getToolTip().add(Component.m_237115_((String)(Component.m_237115_((String)"item.mifa.cooldown_time").getString() + ": " + String.valueOf(reduction).substring(0, 3) + "%")).m_130940_(ChatFormatting.GRAY));
        }
    }
}

