# 方块操作模块
![快速破坏和替换](item:oc2r:block_operations_module)

方块操作模块为 [机器人](robot.md) 提供了在世界中破坏和放置方块的能力。

## API
设备名称：`block_operations`

这是一个高级 API 设备。可以在默认的 Linux 发行版中使用 Lua 进行控制。例如：  
`local d = require("devices")`  
`local m = d:find("block_operations")`  
`m:excavate("front")`

### 面
以下方法中的侧面参数表示从机器人视角的方向。有效值包括：`front`、`up` 和 `down`。

### 方法
`excavate([side]):boolean` 尝试在指定方向上破坏一个方块。收集到的方块将从当前选择的库存槽开始插入。如果选择的槽已满，将使用下一个槽，依此类推。如果库存没有空间容纳掉落的方块，方块将掉落到世界中。
- `side` 是相对方向，用于破坏方块。可选，默认值为 `front`。参见“面”部分。
- 返回操作是否成功。

`place([side]):boolean` 尝试在指定方向上放置一个方块。方块将从当前选择的库存槽中放置。如果槽为空，则不会放置任何方块。
- `side` 是相对方向，用于放置方块。可选，默认值为 `front`。参见“面”部分。
- 返回操作是否成功。

`durability():number` 返回模块挖掘工具的剩余耐久度。一旦耐久度降到零，无法再进行挖掘操作，直到工具被修复。
- 返回模块挖掘工具的剩余耐久度。

`repair():boolean` 尝试使用当前选择的库存槽中的材料修复模块的挖掘工具。此方法将一次消耗一个物品。任何常规工具都可以作为修复材料的来源，例如镐和铲子。工具的质量直接影响修复的耐久度。
- 返回是否有材料可以用来修复模块的挖掘工具。
