# 网络
要建立一个[计算机](block/computer.md)网络，使用[网络连接口](block/network_connector.md)和[网络电缆](item/network_cable.md)将连接器连接起来。最后，确保每台要加入网络的计算机都安装了[网卡](item/network_interface_card.md)。

连接器必须连接在计算机的前面以外的任何一面。这使得安装在计算机中的网络卡能够通过连接器发送和接收数据包。

通过电缆连接的连接器会相互转发数据包。对于更复杂的网络设置，可能需要使用[网络集线器](block/network_hub.md)。它允许将多个连接器互相连接。

## 跳数
网络数据包只能经过一定数量的“跳数”。一个跳数通常可以理解为一次转发操作。例如，连接器转发一个数据包会使用一次跳数。网络集线器将数据包转发到除接收源以外的每个连接器也会使用一次跳数。一旦剩余跳数达到零，数据包将不再被转发。这可以避免数据包在包含循环的网络中无限循环。尽管如此，这只是一个安全机制。任何网络都不应包含循环，因为这会导致同一个数据包在接收计算机上多次到达。

## 计算机设置
要为网络配置计算机，首先确保安装了网络卡。之后，在默认的 Linux 发行版中，运行命令 `setup-network.lua`。这将提供一个向导，用于配置计算机如何连接到网络。或者，如果你知道自己在做什么，可以像在常规 Linux 安装中那样设置网络。

## DHCP
DHCP 是一种允许简化网络设置的协议。整个网络中只需要一台计算机具有静态配置的网络地址，网络中的其他所有计算机都可以自动分配地址。使用此设置时，确保只有一台计算机充当 DHCP 服务器。同时确保没有计算机使用落在动态分配 IP 地址范围内的静态 IP 地址。

## 工具
一旦你拥有一个运行中的网络，且有多个计算机在同一网络中，你就有了无限的可能性。例如，你可以使用 `scp` 在计算机之间复制文件，使用 `ssh` 登录到远程计算机，并使用 `socket` 库在 Lua 中编写自定义网络程序。有关如何使用 `socket` 库的示例，请参阅[官方仓库中的示例](https://github.com/diegonehab/luasocket/tree/master/samples)。
