/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.client.renderer;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tarantel.chickenroost.client.renderer.BaseChickenRenderer;
import net.tarantel.chickenroost.entity.ModEntities;
import net.tarantel.chickenroost.util.ChickenData;
import net.tarantel.chickenroost.util.GsonChickenReader;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModEntityRenderers {
    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        List<ChickenData> readItems = GsonChickenReader.readItemsFromFile();
        if (!readItems.isEmpty()) {
            for (ChickenData etherItem : readItems) {
                String id = etherItem.getId();
                String mobtexture = etherItem.getMobtexture();
                ResourceLocation resourceLocation = new ResourceLocation("chicken_roost", id);
                EntityType entityType = EntityType.m_20632_((String)resourceLocation.toString()).orElse(EntityType.f_20555_);
                event.registerEntityRenderer(entityType, context -> new BaseChickenRenderer(context, mobtexture));
            }
        }
        event.registerEntityRenderer((EntityType)ModEntities.A_CHICKEN_LAVA.get(), context -> new BaseChickenRenderer(context, "lavachicken"));
        event.registerEntityRenderer((EntityType)ModEntities.A_CHICKEN_WATER.get(), context -> new BaseChickenRenderer(context, "waterchicken"));
    }
}

