/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.api.prefab.provider;

import java.util.Optional;
import li.cil.manual.api.provider.PathProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class NamespacePathProvider
implements PathProvider {
    private static final String NAMESPACE = "%NAMESPACE%";
    private static final String PATH = "%PATH%";
    private static final String BLOCK_PATH_WITH_NAMESPACE = "%LANGUAGE%/%NAMESPACE%/block/%PATH%.md";
    private static final String BLOCK_PATH = "%LANGUAGE%/block/%PATH%.md";
    private static final String ITEM_PATH_WITH_NAMESPACE = "%LANGUAGE%/%NAMESPACE%/item/%PATH%.md";
    private static final String ITEM_PATH = "%LANGUAGE%/item/%PATH%.md";
    private final String namespace;
    private final boolean keepNamespaceInPath;

    public NamespacePathProvider(String namespace) {
        this(namespace, false);
    }

    public NamespacePathProvider(String namespace, boolean keepNamespaceInPath) {
        this.namespace = namespace;
        this.keepNamespaceInPath = keepNamespaceInPath;
    }

    @Override
    public Optional<String> pathFor(ItemStack stack) {
        if (stack.m_41619_()) {
            return Optional.empty();
        }
        Item item = stack.m_41720_();
        Block block = Block.m_49814_((Item)item);
        if (block != Blocks.f_50016_) {
            ResourceLocation blockId = Registry.f_122824_.m_7981_((Object)block);
            if (blockId == Registry.f_122824_.m_122315_()) {
                return Optional.empty();
            }
            String blockNamespace = blockId.m_135827_();
            if (this.namespace.equals(blockNamespace)) {
                String template = this.keepNamespaceInPath ? BLOCK_PATH_WITH_NAMESPACE : BLOCK_PATH;
                return Optional.of(template.replace(NAMESPACE, this.namespace).replace(PATH, blockId.m_135815_()));
            }
        } else {
            ResourceLocation itemId = Registry.f_122827_.m_7981_((Object)item);
            if (itemId == Registry.f_122827_.m_122315_()) {
                return Optional.empty();
            }
            String itemNamespace = itemId.m_135827_();
            if (this.namespace.equals(itemNamespace)) {
                String template = this.keepNamespaceInPath ? ITEM_PATH_WITH_NAMESPACE : ITEM_PATH;
                return Optional.of(template.replace(NAMESPACE, this.namespace).replace(PATH, itemId.m_135815_()));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> pathFor(Level world, BlockPos pos, Direction face) {
        Block block = world.m_8055_(pos).m_60734_();
        ResourceLocation blockId = Registry.f_122824_.m_7981_((Object)block);
        if (blockId == Registry.f_122824_.m_122315_()) {
            return Optional.empty();
        }
        String blockNamespace = blockId.m_135827_();
        if (this.namespace.equals(blockNamespace)) {
            String template = this.keepNamespaceInPath ? BLOCK_PATH_WITH_NAMESPACE : BLOCK_PATH;
            return Optional.of(template.replace(NAMESPACE, this.namespace).replace(PATH, blockId.m_135815_()));
        }
        return Optional.empty();
    }
}

