/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.document;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import li.cil.manual.api.ManualModel;
import li.cil.manual.api.ManualStyle;
import li.cil.manual.api.content.Document;
import li.cil.manual.client.document.segment.BoldSegment;
import li.cil.manual.client.document.segment.HeaderSegment;
import li.cil.manual.client.document.segment.InteractiveSegment;
import li.cil.manual.client.document.segment.ItalicSegment;
import li.cil.manual.client.document.segment.LinkSegment;
import li.cil.manual.client.document.segment.MonospaceSegment;
import li.cil.manual.client.document.segment.NextSegmentInfo;
import li.cil.manual.client.document.segment.RenderSegment;
import li.cil.manual.client.document.segment.Segment;
import li.cil.manual.client.document.segment.SegmentRefiner;
import li.cil.manual.client.document.segment.StrikethroughSegment;
import li.cil.manual.client.document.segment.TextSegment;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public final class DocumentRenderer {
    private final ManualModel model;
    private final ManualStyle style;
    @Nullable
    private ResourceLocation location;
    @Nullable
    private Segment root;
    @Nullable
    private InteractiveSegment lastHovered;
    private int lastScrollY;
    private int lastGlobalY;
    @Nullable
    private NextSegmentInfo lastFirstVisible;
    private static final PatternMapping[] SEGMENT_TYPES = new PatternMapping[]{new PatternMapping("^(#+)\\s(.*)", DocumentRenderer::HeaderSegment), new PatternMapping("(`)(.*?)\\1", DocumentRenderer::CodeSegment), new PatternMapping("!\\[([^\\[]*)\\]\\(([^\\)]+)\\)", DocumentRenderer::ImageSegment), new PatternMapping("\\[([^\\[]+)\\]\\(([^\\)]+)\\)", DocumentRenderer::LinkSegment), new PatternMapping("(\\*\\*|__)(\\S.*?\\S|$)\\1", DocumentRenderer::BoldSegment), new PatternMapping("(\\*|_)(\\S.*?\\S|$)\\1", DocumentRenderer::ItalicSegment), new PatternMapping("~~(\\S.*?\\S|$)~~", DocumentRenderer::StrikethroughSegment)};

    public DocumentRenderer(ManualModel model, ManualStyle style) {
        this.model = model;
        this.style = style;
    }

    public ManualModel getModel() {
        return this.model;
    }

    public ManualStyle getStyle() {
        return this.style;
    }

    @Nullable
    public ResourceLocation getLocation() {
        return this.location;
    }

    /*
     * WARNING - void declaration
     */
    public void parse(Document document) {
        void var4_7;
        this.location = document.getLocation();
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        for (String string : document.getLines()) {
            segments.add(new TextSegment(this, null, StringUtils.stripEnd((String)string, null)));
        }
        ArrayList workSegments = new ArrayList();
        for (PatternMapping type : SEGMENT_TYPES) {
            for (Segment segment : segments) {
                segment.refine(type.pattern, type.refiner).forEach(workSegments::add);
            }
            ArrayList<TextSegment> tmp = segments;
            segments = workSegments;
            workSegments = tmp;
            workSegments.clear();
        }
        boolean bl = false;
        while (var4_7 < segments.size() - 1) {
            ((Segment)segments.get((int)var4_7)).setNext((Segment)segments.get((int)(var4_7 + true)));
            ++var4_7;
        }
        Segment segment = this.root = segments.size() > 0 ? (Segment)segments.get(0) : new TextSegment(this, null, "");
        if (this.lastHovered != null) {
            this.lastHovered.setMouseHovered(false);
            this.lastHovered = null;
        }
        this.lastFirstVisible = null;
    }

    public int height(int width) {
        if (this.root == null) {
            return 0;
        }
        int globalY = 0;
        int lineHeight = 0;
        NextSegmentInfo current = new NextSegmentInfo(this.root);
        while (current.segment != null) {
            boolean isFirstSegmentOnNewLine;
            Segment segment = current.segment;
            int localX = current.absoluteX;
            int relativeY = current.relativeY;
            int segmentHeight = segment.getLineHeight(localX, width);
            globalY += relativeY;
            current = segment.getNext(localX, lineHeight, width);
            boolean bl = isFirstSegmentOnNewLine = current.relativeY > 0;
            lineHeight = isFirstSegmentOnNewLine ? (current.absoluteX > 0 ? segmentHeight : 0) : Math.max(lineHeight, segmentHeight);
            if (current.segment != null) continue;
            if (current.relativeY > 0) {
                if (current.absoluteX > 0) {
                    globalY += current.relativeY + segmentHeight;
                    continue;
                }
                globalY += current.relativeY;
                continue;
            }
            globalY += lineHeight;
        }
        return globalY;
    }

    public Optional<InteractiveSegment> render(PoseStack matrixStack, int scrollY, int width, int height, int mouseX, int mouseY) {
        int globalY;
        NextSegmentInfo current;
        if (this.root == null) {
            return Optional.empty();
        }
        RenderSystem.m_69421_((int)256, (boolean)false);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 500.0);
        Screen.m_93172_((PoseStack)matrixStack, (int)-10, (int)-1000, (int)(width + 20), (int)0, (int)-1);
        Screen.m_93172_((PoseStack)matrixStack, (int)-10, (int)height, (int)(width + 20), (int)(height + 1000), (int)-1);
        matrixStack.m_85849_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        boolean isMouseOverDocument = mouseX >= 0 || mouseX <= width || mouseY >= 0 || mouseY <= height;
        Optional<InteractiveSegment> hovered = Optional.empty();
        int lineHeight = 0;
        if (scrollY != this.lastScrollY || this.lastFirstVisible == null) {
            current = new NextSegmentInfo(this.root);
            this.lastScrollY = scrollY;
            globalY = -scrollY;
            this.lastFirstVisible = null;
        } else {
            globalY = this.lastGlobalY;
            current = this.lastFirstVisible;
        }
        while (current.segment != null) {
            boolean isFirstSegmentOnNewLine;
            boolean isVisible;
            NextSegmentInfo info = current;
            Segment segment = current.segment;
            int localX = current.absoluteX;
            int relativeY = current.relativeY;
            int segmentHeight = segment.getLineHeight(localX, width);
            current = segment.getNext(localX, lineHeight, width);
            int segmentTop = globalY += relativeY;
            int segmentBottom = current.relativeY > 0 ? (current.absoluteX > 0 ? segmentTop + current.relativeY + segmentHeight : segmentTop + current.relativeY) : segmentTop + segmentHeight;
            boolean bl = isVisible = segmentBottom >= 0 && segmentTop <= height;
            if (isVisible) {
                if (this.lastFirstVisible == null) {
                    this.lastGlobalY = globalY - relativeY;
                    this.lastFirstVisible = info;
                }
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.0, (double)globalY, 0.0);
                Optional<InteractiveSegment> result = segment.render(matrixStack, localX, lineHeight, width, mouseX, mouseY - globalY);
                matrixStack.m_85849_();
                if (isMouseOverDocument && hovered.isEmpty()) {
                    hovered = result;
                }
            }
            if (segmentTop > height) break;
            boolean bl2 = isFirstSegmentOnNewLine = current.relativeY > 0;
            if (isFirstSegmentOnNewLine) {
                lineHeight = current.absoluteX > 0 ? segmentHeight : 0;
                continue;
            }
            lineHeight = Math.max(lineHeight, segmentHeight);
        }
        this.setHoveredSegment(hovered.orElse(null));
        RenderSystem.m_69421_((int)256, (boolean)false);
        return hovered;
    }

    private void setHoveredSegment(@Nullable InteractiveSegment hovered) {
        if (hovered == this.lastHovered) {
            return;
        }
        if (this.lastHovered != null) {
            this.lastHovered.setMouseHovered(false);
        }
        this.lastHovered = hovered;
        if (this.lastHovered != null) {
            this.lastHovered.setMouseHovered(true);
        }
    }

    private static Segment HeaderSegment(DocumentRenderer d, Segment s, Matcher t) {
        return new HeaderSegment(d, s, t.group(2), t.group(1).length());
    }

    private static Segment CodeSegment(DocumentRenderer d, Segment s, Matcher t) {
        return new MonospaceSegment(d, s, t.group(2));
    }

    private static Segment LinkSegment(DocumentRenderer d, Segment s, Matcher t) {
        return new LinkSegment(d, s, t.group(1), t.group(2));
    }

    private static Segment BoldSegment(DocumentRenderer d, Segment s, Matcher t) {
        return new BoldSegment(d, s, t.group(2));
    }

    private static Segment ItalicSegment(DocumentRenderer d, Segment s, Matcher t) {
        return new ItalicSegment(d, s, t.group(2));
    }

    private static Segment StrikethroughSegment(DocumentRenderer d, Segment s, Matcher t) {
        return new StrikethroughSegment(d, s, t.group(1));
    }

    private static Segment ImageSegment(DocumentRenderer d, Segment s, Matcher t) {
        return new RenderSegment(d, s, t.group(1), t.group(2));
    }

    private static final class PatternMapping {
        final Pattern pattern;
        final SegmentRefiner refiner;

        PatternMapping(String pattern, SegmentRefiner refiner) {
            this.pattern = Pattern.compile(pattern);
            this.refiner = refiner;
        }
    }
}

