/*
 * Decompiled with CFR 0.152.
 */
package com.kapiteon.clearvision;

import com.kapiteon.clearvision.Helper;
import com.kapiteon.clearvision.classes.ClearCamera;
import com.kapiteon.clearvision.classes.NightVisionHashMap;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.User;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.ArrayUtils;

@Mod(value="clearvision")
public class ClearVision {
    public static String modName = "clearvision";
    private final KeyMapping[] keys = new KeyMapping[1];
    private Map<MobEffect, MobEffectInstance> activeEffectsMap;
    private boolean isNightVisionEnabled;
    private Camera originalCamera;
    public Minecraft mc;

    public ClearVision() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        this.keys[0] = new KeyMapping("Night vision(ON/OFF)", 296, modName);
        Options options = Minecraft.m_91087_().f_91066_;
        for (KeyMapping key : this.keys) {
            options.f_92059_ = (KeyMapping[])ArrayUtils.add((Object[])options.f_92059_, (Object)key);
        }
        this.mc = Minecraft.m_91087_();
        User user = this.mc.m_91094_();
        if (user.m_92546_().equals("Dev")) {
            Helper.setValueToFinal(this.mc, User.class, new User("kapiteon", user.m_92545_(), user.m_92547_(), user.m_193806_(), user.m_193805_(), user.m_168638_()));
        }
    }

    @SubscribeEvent
    public void onLevelLoad(ClientPlayerNetworkEvent.Clone event) {
        this.disableNightVision();
        this.enableNightVision();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(InputEvent.Key event) {
        if (this.keys[0].m_90857_()) {
            if (this.isNightVisionEnabled) {
                this.disableNightVision();
            } else {
                this.enableNightVision();
            }
        }
    }

    @SubscribeEvent
    public void onFogRender(ViewportEvent.RenderFog event) {
        if (this.isNightVisionEnabled && this.mc.f_91063_ != null) {
            event.setFarPlaneDistance(event.getFarPlaneDistance() + 32.0f);
            event.setNearPlaneDistance(event.getFarPlaneDistance());
            event.setCanceled(true);
        }
    }

    public void disableNightVision() {
        if (this.activeEffectsMap != null && this.mc.f_91074_ != null && this.mc.f_91074_.m_21221_() != null) {
            this.activeEffectsMap.clear();
            this.activeEffectsMap.putAll(this.mc.f_91074_.m_21221_());
            Helper.setValueToFinal(this.mc.f_91074_, LivingEntity.class, Map.class, this.activeEffectsMap);
            this.activeEffectsMap = null;
        }
        if (this.originalCamera != null) {
            Helper.setValueToFinal(this.mc.f_91063_, Camera.class, this.originalCamera);
        }
        this.isNightVisionEnabled = false;
    }

    private void enableNightVision() {
        if (this.mc.f_91074_ != null) {
            Map original;
            this.activeEffectsMap = original = this.mc.f_91074_.m_21221_();
            Helper.setValueToFinal(this.mc.f_91074_, LivingEntity.class, Map.class, new NightVisionHashMap(original));
        }
        if (this.mc.f_91073_ != null) {
            this.originalCamera = this.mc.f_91063_.m_109153_();
            ClearCamera clearCamera = new ClearCamera();
            clearCamera.m_90575_((BlockGetter)this.mc.f_91073_, (Entity)this.mc.f_91074_, !this.mc.f_91066_.m_92176_().m_90612_(), this.mc.f_91066_.m_92176_().m_90613_(), 1.0f);
            for (int i = 0; i < 10; ++i) {
                clearCamera.m_90565_();
            }
            Helper.setValueToFinal(this.mc.f_91063_, Camera.class, (Object)clearCamera);
        }
        this.isNightVisionEnabled = true;
    }
}

