/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.unascribed.ears.NotRandom119;
import com.unascribed.ears.api.features.EarsFeatures;
import com.unascribed.ears.common.EarsCommon;
import com.unascribed.ears.common.EarsFeaturesHolder;
import com.unascribed.ears.common.EarsFeaturesStorage;
import com.unascribed.ears.common.debug.EarsLog;
import com.unascribed.ears.common.render.EarsRenderDelegate;
import com.unascribed.ears.common.render.IndirectEarsRenderDelegate;
import com.unascribed.ears.common.util.Decider;
import com.unascribed.ears.mixin.AccessorPlayerModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ElytraItem;

public class EarsLayerRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final IndirectEarsRenderDelegate<PoseStack, MultiBufferSource, VertexConsumer, AbstractClientPlayer, ModelPart> delegate = new IndirectEarsRenderDelegate<PoseStack, MultiBufferSource, VertexConsumer, AbstractClientPlayer, ModelPart>(){
        private final Matrix3f IDENTITY3 = new Matrix3f();
        {
            this.IDENTITY3.m_8180_();
        }

        @Override
        protected Decider<EarsRenderDelegate.BodyPart, ModelPart> decideModelPart(Decider<EarsRenderDelegate.BodyPart, ModelPart> d) {
            PlayerModel model = (PlayerModel)EarsLayerRenderer.this.m_117386_();
            return d.map(EarsRenderDelegate.BodyPart.HEAD, model.f_102808_).map(EarsRenderDelegate.BodyPart.LEFT_ARM, model.f_102812_).map(EarsRenderDelegate.BodyPart.LEFT_LEG, model.f_102814_).map(EarsRenderDelegate.BodyPart.RIGHT_ARM, model.f_102811_).map(EarsRenderDelegate.BodyPart.RIGHT_LEG, model.f_102813_).map(EarsRenderDelegate.BodyPart.TORSO, model.f_102810_);
        }

        @Override
        protected void doAnchorTo(EarsRenderDelegate.BodyPart part, ModelPart modelPart) {
            modelPart.m_104299_((PoseStack)this.matrices);
            ModelPart.Cube cuboid = modelPart.m_233558_((RandomSource)NotRandom119.INSTANCE);
            ((PoseStack)this.matrices).m_85841_(0.0625f, 0.0625f, 0.0625f);
            ((PoseStack)this.matrices).m_85837_((double)cuboid.f_104335_, (double)cuboid.f_104339_, (double)cuboid.f_104337_);
        }

        @Override
        protected boolean isVisible(ModelPart modelPart) {
            return modelPart.f_104207_;
        }

        @Override
        protected EarsFeatures getEarsFeatures() {
            return EarsLayerRenderer.getEarsFeatures((AbstractClientPlayer)this.peer);
        }

        @Override
        public boolean isSlim() {
            return ((AccessorPlayerModel)EarsLayerRenderer.this.m_117386_()).ears$isSlim();
        }

        @Override
        protected void pushMatrix() {
            ((PoseStack)this.matrices).m_85836_();
        }

        @Override
        protected void popMatrix() {
            ((PoseStack)this.matrices).m_85849_();
        }

        @Override
        protected void doTranslate(float x, float y, float z) {
            ((PoseStack)this.matrices).m_85837_((double)x, (double)y, (double)z);
        }

        @Override
        protected void doRotate(float ang, float x, float y, float z) {
            ((PoseStack)this.matrices).m_85845_(new Vector3f(x, y, z).m_122240_(ang));
        }

        @Override
        protected void doScale(float x, float y, float z) {
            ((PoseStack)this.matrices).m_85841_(x, y, z);
        }

        @Override
        protected void doUploadAux(EarsRenderDelegate.TexSource src, byte[] pngData) {
            ResourceLocation skin = ((AbstractClientPlayer)this.peer).m_108560_();
            ResourceLocation id = new ResourceLocation(skin.m_135827_(), src.addSuffix(skin.m_135815_()));
            if (pngData != null && Minecraft.m_91087_().m_91097_().m_174786_(id, null) == null) {
                try {
                    Minecraft.m_91087_().m_91097_().m_118495_(id, (AbstractTexture)new DynamicTexture(NativeImage.m_85062_((ByteBuffer)1.toNativeBuffer(pngData))));
                }
                catch (IOException e) {
                    Minecraft.m_91087_().m_91097_().m_118495_(id, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
                }
            }
        }

        @Override
        protected void addVertex(float x, float y, int z, float r, float g, float b, float a, float u, float v, float nX, float nY, float nZ) {
            Matrix4f mm = ((PoseStack)this.matrices).m_85850_().m_85861_();
            Matrix3f mn = this.emissive ? this.IDENTITY3 : ((PoseStack)this.matrices).m_85850_().m_85864_();
            ((VertexConsumer)this.vc).m_85982_(mm, x, y, (float)z).m_85950_(r, g, b, a).m_7421_(u, v).m_86008_(this.overlay).m_85969_(this.emissive ? LightTexture.m_109885_((int)15, (int)15) : this.light).m_85977_(mn, nX, nY, nZ).m_5752_();
        }

        @Override
        protected void commitQuads() {
            if (this.vcp instanceof MultiBufferSource.BufferSource) {
                ((MultiBufferSource.BufferSource)this.vcp).m_173043_();
            }
        }

        @Override
        protected void doRenderDebugDot(float r, float g, float b, float a) {
        }

        @Override
        protected VertexConsumer getVertexConsumer(EarsRenderDelegate.TexSource src) {
            ResourceLocation id = ((AbstractClientPlayer)this.peer).m_108560_();
            if (src != EarsRenderDelegate.TexSource.SKIN) {
                id = new ResourceLocation(id.m_135827_(), src.addSuffix(id.m_135815_()));
            }
            return ((MultiBufferSource)this.vcp).m_6299_(RenderType.m_110470_((ResourceLocation)id));
        }

        @Override
        public float getTime() {
            return (float)((AbstractClientPlayer)this.peer).f_19797_ + Minecraft.m_91087_().m_91296_();
        }

        @Override
        public boolean isFlying() {
            return ((AbstractClientPlayer)this.peer).m_150110_().f_35935_;
        }

        @Override
        public boolean isGliding() {
            return ((AbstractClientPlayer)this.peer).m_21255_();
        }

        @Override
        public boolean isJacketEnabled() {
            return ((AbstractClientPlayer)this.peer).m_36170_(PlayerModelPart.JACKET);
        }

        @Override
        public boolean isWearingBoots() {
            return ((AbstractClientPlayer)this.peer).m_6844_(EquipmentSlot.FEET).m_41720_() instanceof ArmorItem;
        }

        @Override
        public boolean isWearingChestplate() {
            return ((AbstractClientPlayer)this.peer).m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ArmorItem;
        }

        @Override
        public boolean isWearingElytra() {
            return ((AbstractClientPlayer)this.peer).m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ElytraItem;
        }

        @Override
        public float getHorizontalSpeed() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).f_19867_, ((AbstractClientPlayer)this.peer).f_19787_, Minecraft.m_91087_().m_91296_());
        }

        @Override
        public float getLimbSwing() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).f_20923_, ((AbstractClientPlayer)this.peer).f_20924_, Minecraft.m_91087_().m_91296_());
        }

        @Override
        public float getStride() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).f_36099_, ((AbstractClientPlayer)this.peer).f_36100_, Minecraft.m_91087_().m_91296_());
        }

        @Override
        public float getBodyYaw() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).f_20884_, ((AbstractClientPlayer)this.peer).f_20883_, Minecraft.m_91087_().m_91296_());
        }

        @Override
        public double getCapeX() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).f_36102_, ((AbstractClientPlayer)this.peer).f_36105_, Minecraft.m_91087_().m_91296_());
        }

        @Override
        public double getCapeY() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).f_36103_, ((AbstractClientPlayer)this.peer).f_36106_, Minecraft.m_91087_().m_91296_());
        }

        @Override
        public double getCapeZ() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).f_36104_, ((AbstractClientPlayer)this.peer).f_36075_, Minecraft.m_91087_().m_91296_());
        }

        @Override
        public double getX() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).f_19790_, ((AbstractClientPlayer)this.peer).m_20185_(), Minecraft.m_91087_().m_91296_());
        }

        @Override
        public double getY() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).f_19791_, ((AbstractClientPlayer)this.peer).m_20186_(), Minecraft.m_91087_().m_91296_());
        }

        @Override
        public double getZ() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).f_19792_, ((AbstractClientPlayer)this.peer).m_20189_(), Minecraft.m_91087_().m_91296_());
        }
    };

    public EarsLayerRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> context) {
        super(context);
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "Constructed");
    }

    public void render(PoseStack m, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "render({}, {}, {}, {}, {}, {}, {}, {}, {})", m, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch);
        this.delegate.render(m, vertexConsumers, entity, light, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f));
    }

    public void renderLeftArm(PoseStack m, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer entity) {
        this.delegate.render(m, vertexConsumers, entity, light, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), EarsRenderDelegate.BodyPart.LEFT_ARM);
    }

    public void renderRightArm(PoseStack m, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer entity) {
        this.delegate.render(m, vertexConsumers, entity, light, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), EarsRenderDelegate.BodyPart.RIGHT_ARM);
    }

    public static EarsFeatures getEarsFeatures(AbstractClientPlayer peer) {
        ResourceLocation skin = peer.m_108560_();
        AbstractTexture tex = Minecraft.m_91087_().m_91097_().m_118506_(skin);
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "getEarsFeatures(): skin={}, tex={}", (Object)skin, (Object)tex);
        if (tex instanceof EarsFeaturesHolder) {
            EarsFeatures feat = ((EarsFeaturesHolder)tex).getEarsFeatures();
            EarsFeaturesStorage.INSTANCE.put(peer.m_36316_().getName(), peer.m_36316_().getId(), feat);
            if (!peer.m_20145_()) {
                return feat;
            }
        }
        return EarsFeatures.DISABLED;
    }
}

