/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.item.BYGItems;

public class FruitBlock
extends Block
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public static final int MAX_AGE = 3;
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private final FruitType fruitType;

    public FruitBlock(FruitType fruitType, BlockBehaviour.Properties properties) {
        super(properties);
        this.fruitType = fruitType;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return new ItemStack((ItemLike)this.fruitType.getFruitItem());
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        boolean maxAge;
        int age = (Integer)state.m_61143_((Property)AGE);
        boolean bl = maxAge = age == 3;
        if (!maxAge && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (maxAge) {
            FruitBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.fruitType.getFruitItem()));
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public boolean m_7898_(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7494_()).m_60713_(this.fruitType.getLeavesBlock());
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos neighborPos) {
        return !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public void m_213898_(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 3 && level.m_45524_(pos.m_7494_(), 0) >= 9 && random.m_188503_(5) == 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
        }
    }

    public boolean m_7370_(@NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, BlockState blockState, boolean b) {
        return (Integer)blockState.m_61143_((Property)AGE) < 3;
    }

    public boolean m_214167_(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.m_61143_((Property)AGE) + 1);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public static enum FruitType implements StringRepresentable
    {
        BAOBAB("baobab_fruit", () -> BYGItems.BAOBAB_FRUIT, BYGBlocks.RIPE_BAOBAB_LEAVES),
        JOSHUA("joshua_fruit", () -> BYGItems.JOSHUA_FRUIT, BYGBlocks.RIPE_JOSHUA_LEAVES),
        GREEN_APPLE("green_apple", () -> BYGItems.GREEN_APPLE, BYGBlocks.SKYRIS_LEAVES_GREEN_APPLE),
        APPLE("apple", () -> () -> Items.f_42410_, BYGBlocks.RIPE_ORCHARD_LEAVES);

        private final String name;
        private final Supplier<Supplier<Item>> fruitItem;
        private final Supplier<Block> leavesBlock;

        private FruitType(String name, Supplier<Supplier<Item>> fruitItem, Supplier<Block> leavesBlock) {
            this.name = name;
            this.fruitItem = fruitItem;
            this.leavesBlock = leavesBlock;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public Item getFruitItem() {
            return this.fruitItem.get().get();
        }

        public Block getLeavesBlock() {
            return this.leavesBlock.get();
        }
    }
}

