/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.end.islands.shattered;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Material;
import potionstudios.byg.common.world.feature.config.FloatingIslandConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class ShatteredFloatingIslands2
extends Feature<FloatingIslandConfig> {
    FastNoise perlin = null;

    public ShatteredFloatingIslands2(Codec<FloatingIslandConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FloatingIslandConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_225041_(), featurePlaceContext.m_159777_(), (FloatingIslandConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, RandomSource rand, BlockPos pos, FloatingIslandConfig config) {
        double scaledNoise;
        double noise;
        double z;
        double y;
        double x;
        this.setSeed(world.m_7328_());
        double radius = rand.m_188503_(config.getMaxPossibleRadius()) + config.getMinRadius();
        double halfRadius = radius / 2.0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_()) > 4) {
            return false;
        }
        for (x = -halfRadius - 2.0; x <= halfRadius + 8.0; x += 1.0) {
            for (y = -radius - 2.0; y <= radius + 8.0; y += 1.0) {
                for (z = -halfRadius - 2.0; z <= halfRadius + 8.0; z += 1.0) {
                    double squareNoise1 = this.perlin.GetNoise((float)x, (float)y, (float)z) * 12.0f - 6.0f;
                    double distanceSqt1 = x * x + y * y + z * z + squareNoise1 * squareNoise1;
                    if (!(distanceSqt1 <= halfRadius * radius)) continue;
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)y, (int)z);
                    if (world.m_8055_((BlockPos)mutable).m_60767_() != Material.f_76296_) continue;
                    if (y >= 1.0) {
                        world.m_7731_((BlockPos)mutable, config.getBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
                    }
                    if (!(y >= 2.0)) continue;
                    world.m_7731_((BlockPos)mutable, config.getTopBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (x = -radius - 2.0; x <= radius + 2.0; x += 1.0) {
            for (y = -radius - 2.0; y <= radius + 11.0; y += 1.0) {
                for (z = -radius - 2.0; z <= radius + 2.0; z += 1.0) {
                    noise = this.perlin.GetNoise((float)x, (float)y, (float)z) * 12.0f;
                    scaledNoise = noise / 11.0 * (y * 3.0 / (x * x + z * z));
                    if (!(scaledNoise >= 0.5) || !(y >= 1.0)) continue;
                    world.m_7731_(pos.m_7637_(x, y - 22.0, z), config.getBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
                    if (!(y >= 20.0)) continue;
                    world.m_7731_(pos.m_7637_(x, y - 22.0, z), config.getBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
                    if (!(y >= 22.0)) continue;
                    world.m_7731_(pos.m_7637_(x, y - 22.0, z), config.getBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (double z2 = -halfRadius; z2 <= halfRadius - 7.0; z2 += 1.0) {
            double x2 = 0.0;
            double y2 = 23.0;
            noise = this.perlin.GetNoise((float)x2, (float)y2, (float)z2) * 12.0f;
            scaledNoise = noise + x2 + y2 + z2;
            if (!(scaledNoise >= 0.5)) continue;
            world.m_7731_(pos.m_7637_(x2, y2 - 22.0, z2), config.getBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
        }
        return false;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = new FastNoise((int)seed);
            this.perlin.SetNoiseType(FastNoise.NoiseType.Perlin);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

