/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.nether.quartzdesert;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;
import potionstudios.byg.common.block.BYGBlocks;

public class RawQuartzColumnFeature
extends Feature<ColumnFeatureConfiguration> {
    private static final ImmutableList<Block> CANNOT_PLACE_ON = ImmutableList.of((Object)Blocks.f_49991_, (Object)Blocks.f_50752_, (Object)Blocks.f_50450_, (Object)Blocks.f_50135_, (Object)Blocks.f_50197_, (Object)Blocks.f_50198_, (Object)Blocks.f_50199_, (Object)Blocks.f_50200_, (Object)Blocks.f_50087_, (Object)Blocks.f_50085_);

    public RawQuartzColumnFeature(Codec<ColumnFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ColumnFeatureConfiguration> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_225041_(), featurePlaceContext.m_159777_(), (ColumnFeatureConfiguration)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel reader, ChunkGenerator generator, RandomSource rand, BlockPos pos, ColumnFeatureConfiguration config) {
        int i = generator.m_6337_();
        if (!RawQuartzColumnFeature.canPlaceAt((LevelAccessor)reader, i, pos.m_122032_())) {
            return false;
        }
        int j = config.m_160720_().m_214085_(rand);
        boolean flag = rand.m_188501_() < 0.9f;
        int k = Math.min(j, flag ? 5 : 8);
        int l = flag ? 50 : 15;
        boolean flag1 = false;
        for (BlockPos blockpos : BlockPos.m_235641_((RandomSource)rand, (int)l, (int)(pos.m_123341_() - k), (int)pos.m_123342_(), (int)(pos.m_123343_() - k), (int)(pos.m_123341_() + k), (int)pos.m_123342_(), (int)(pos.m_123343_() + k))) {
            int i1 = j - blockpos.m_123333_((Vec3i)pos);
            if (i1 < 0) continue;
            flag1 |= this.placeColumn((LevelAccessor)reader, i, blockpos, i1, config.m_160717_().m_214085_(rand));
        }
        return flag1;
    }

    private boolean placeColumn(LevelAccessor p_236248_1_, int p_236248_2_, BlockPos p_236248_3_, int p_236248_4_, int p_236248_5_) {
        boolean flag = false;
        block0: for (BlockPos blockpos : BlockPos.m_121976_((int)(p_236248_3_.m_123341_() - p_236248_5_), (int)p_236248_3_.m_123342_(), (int)(p_236248_3_.m_123343_() - p_236248_5_), (int)(p_236248_3_.m_123341_() + p_236248_5_), (int)p_236248_3_.m_123342_(), (int)(p_236248_3_.m_123343_() + p_236248_5_))) {
            int i = blockpos.m_123333_((Vec3i)p_236248_3_);
            BlockPos blockpos1 = RawQuartzColumnFeature.isAirOrLavaOcean(p_236248_1_, p_236248_2_, blockpos) ? RawQuartzColumnFeature.findSurface(p_236248_1_, p_236248_2_, blockpos.m_122032_(), i) : RawQuartzColumnFeature.findAir(p_236248_1_, blockpos.m_122032_(), i);
            if (blockpos1 == null) continue;
            BlockPos.MutableBlockPos blockpos$mutable = blockpos1.m_122032_();
            for (int j = p_236248_4_ - i / 2; j >= 0; --j) {
                if (RawQuartzColumnFeature.isAirOrLavaOcean(p_236248_1_, p_236248_2_, (BlockPos)blockpos$mutable)) {
                    this.m_5974_((LevelWriter)p_236248_1_, (BlockPos)blockpos$mutable, BYGBlocks.RAW_QUARTZ_BLOCK.defaultBlockState());
                    blockpos$mutable.m_122173_(Direction.UP);
                    flag = true;
                    continue;
                }
                if (!p_236248_1_.m_8055_((BlockPos)blockpos$mutable).m_60713_((Block)BYGBlocks.RAW_QUARTZ_BLOCK.get())) continue block0;
                blockpos$mutable.m_122173_(Direction.UP);
            }
        }
        return flag;
    }

    @Nullable
    private static BlockPos findSurface(LevelAccessor p_236246_0_, int p_236246_1_, BlockPos.MutableBlockPos p_236246_2_, int p_236246_3_) {
        while (p_236246_2_.m_123342_() > 1 && p_236246_3_ > 0) {
            --p_236246_3_;
            if (RawQuartzColumnFeature.canPlaceAt(p_236246_0_, p_236246_1_, p_236246_2_)) {
                return p_236246_2_;
            }
            p_236246_2_.m_122173_(Direction.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(LevelAccessor p_242762_0_, int p_242762_1_, BlockPos.MutableBlockPos p_242762_2_) {
        if (!RawQuartzColumnFeature.isAirOrLavaOcean(p_242762_0_, p_242762_1_, (BlockPos)p_242762_2_)) {
            return false;
        }
        BlockState blockstate = p_242762_0_.m_8055_((BlockPos)p_242762_2_.m_122173_(Direction.DOWN));
        p_242762_2_.m_122173_(Direction.UP);
        return !blockstate.m_60795_() && !CANNOT_PLACE_ON.contains((Object)blockstate.m_60734_());
    }

    @Nullable
    private static BlockPos findAir(LevelAccessor p_236249_0_, BlockPos.MutableBlockPos p_236249_1_, int p_236249_2_) {
        while (p_236249_1_.m_123342_() < p_236249_0_.m_151558_() && p_236249_2_ > 0) {
            --p_236249_2_;
            BlockState blockstate = p_236249_0_.m_8055_((BlockPos)p_236249_1_);
            if (CANNOT_PLACE_ON.contains((Object)blockstate.m_60734_())) {
                return null;
            }
            if (blockstate.m_60795_()) {
                return p_236249_1_;
            }
            p_236249_1_.m_122173_(Direction.UP);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(LevelAccessor p_236247_0_, int p_236247_1_, BlockPos p_236247_2_) {
        BlockState blockstate = p_236247_0_.m_8055_(p_236247_2_);
        return blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_49991_) && p_236247_2_.m_123342_() <= p_236247_1_;
    }
}

