/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.HostileConfig;
import shadows.hostilenetworks.block.LootFabBlock;
import shadows.hostilenetworks.block.SimChamberBlock;
import shadows.hostilenetworks.curios.CuriosCompat;
import shadows.hostilenetworks.data.DataModelManager;
import shadows.hostilenetworks.gui.DeepLearnerContainer;
import shadows.hostilenetworks.gui.LootFabContainer;
import shadows.hostilenetworks.gui.SimChamberContainer;
import shadows.hostilenetworks.item.BlankDataModelItem;
import shadows.hostilenetworks.item.DataModelItem;
import shadows.hostilenetworks.item.DeepLearnerItem;
import shadows.hostilenetworks.item.MobPredictionItem;
import shadows.hostilenetworks.tile.LootFabTileEntity;
import shadows.hostilenetworks.tile.SimChamberTileEntity;
import shadows.placebo.block_entity.TickingBlockEntityType;
import shadows.placebo.container.ContainerUtil;
import shadows.placebo.loot.LootSystem;

@Mod(value="hostilenetworks")
public class HostileNetworks {
    public static final String MODID = "hostilenetworks";
    public static final String VERSION = ((ModContainer)ModList.get().getModContainerById("hostilenetworks").get()).getModInfo().getVersion().toString();
    public static final Logger LOGGER = LogManager.getLogger((String)"hostilenetworks");
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("hostilenetworks", "hostilenetworks")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
    public static final CreativeModeTab TAB = new CreativeModeTab("hostilenetworks"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)Hostile.Blocks.SIM_CHAMBER.get());
        }
    };

    public HostileNetworks() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        HostileConfig.load();
    }

    @SubscribeEvent
    public void register(RegisterEvent e) {
        if (e.getForgeRegistry() == ForgeRegistries.BLOCKS) {
            this.blocks();
        }
        if (e.getForgeRegistry() == ForgeRegistries.BLOCK_ENTITY_TYPES) {
            this.tiles();
        }
        if (e.getForgeRegistry() == ForgeRegistries.ITEMS) {
            this.items();
        }
        if (e.getForgeRegistry() == ForgeRegistries.MENU_TYPES) {
            this.containers();
        }
    }

    public void blocks() {
        IForgeRegistry reg = ForgeRegistries.BLOCKS;
        reg.register("sim_chamber", (Object)new SimChamberBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60953_(s -> 1).m_60913_(4.0f, 3000.0f).m_60955_()));
        reg.register("loot_fabricator", (Object)new LootFabBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60953_(s -> 1).m_60913_(4.0f, 3000.0f).m_60955_()));
    }

    public void tiles() {
        IForgeRegistry reg = ForgeRegistries.BLOCK_ENTITY_TYPES;
        reg.register("sim_chamber", (Object)new TickingBlockEntityType(SimChamberTileEntity::new, (Set)ImmutableSet.of((Object)((Block)Hostile.Blocks.SIM_CHAMBER.get())), false, true));
        reg.register("loot_fabricator", (Object)new TickingBlockEntityType(LootFabTileEntity::new, (Set)ImmutableSet.of((Object)((Block)Hostile.Blocks.LOOT_FABRICATOR.get())), false, true));
    }

    public void items() {
        IForgeRegistry reg = ForgeRegistries.ITEMS;
        reg.register("deep_learner", (Object)new DeepLearnerItem(new Item.Properties().m_41487_(1).m_41491_(TAB)));
        reg.register("blank_data_model", (Object)new BlankDataModelItem(new Item.Properties().m_41487_(1).m_41491_(TAB)));
        reg.register("empty_prediction", (Object)new Item(new Item.Properties().m_41491_(TAB)));
        reg.register("overworld_prediction", (Object)new Item(new Item.Properties().m_41491_(TAB)));
        reg.register("nether_prediction", (Object)new Item(new Item.Properties().m_41491_(TAB)));
        reg.register("end_prediction", (Object)new Item(new Item.Properties().m_41491_(TAB)));
        reg.register("twilight_prediction", (Object)new Item(new Item.Properties().m_41491_(TAB)));
        reg.register("sim_chamber", (Object)new BlockItem((Block)Hostile.Blocks.SIM_CHAMBER.get(), new Item.Properties().m_41491_(TAB)));
        reg.register("loot_fabricator", (Object)new BlockItem((Block)Hostile.Blocks.LOOT_FABRICATOR.get(), new Item.Properties().m_41491_(TAB)));
        reg.register("data_model", (Object)new DataModelItem(new Item.Properties().m_41487_(1).m_41491_(TAB)));
        reg.register("prediction", (Object)new MobPredictionItem(new Item.Properties().m_41491_(TAB)));
    }

    public void containers() {
        IForgeRegistry reg = ForgeRegistries.MENU_TYPES;
        reg.register("deep_learner", (Object)new MenuType((MenuType.MenuSupplier)((IContainerFactory)(id, inv, buf) -> new DeepLearnerContainer(id, inv, buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND))));
        reg.register("sim_chamber", (Object)ContainerUtil.makeType(SimChamberContainer::new));
        reg.register("loot_fabricator", (Object)ContainerUtil.makeType(LootFabContainer::new));
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        LootSystem.defaultBlockTable((Block)((Block)Hostile.Blocks.LOOT_FABRICATOR.get()));
        LootSystem.defaultBlockTable((Block)((Block)Hostile.Blocks.SIM_CHAMBER.get()));
        DataModelManager.INSTANCE.registerToBus();
    }

    @SubscribeEvent
    public void imcEvent(InterModEnqueueEvent e) {
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.sendIMC();
        }
    }
}

