/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.client.WeirdRenderThings;
import shadows.hostilenetworks.curios.CuriosCompat;
import shadows.hostilenetworks.data.CachedModel;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.item.DeepLearnerItem;

public class DeepLearnerHudRenderer
implements IGuiOverlay {
    private static final ResourceLocation DL_HUD = new ResourceLocation("hostilenetworks", "textures/gui/deep_learner_hud.png");

    public void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        CachedModel cModel;
        int i;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !(mc.f_91080_ instanceof ChatScreen) && mc.f_91080_ != null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() != Hostile.Items.DEEP_LEARNER.get()) {
            stack = player.m_21206_();
        }
        if (stack.m_41720_() != Hostile.Items.DEEP_LEARNER.get() && ModList.get().isLoaded("curios")) {
            stack = CuriosCompat.getDeepLearner((Player)player);
        }
        if (stack.m_41720_() != Hostile.Items.DEEP_LEARNER.get()) {
            return;
        }
        ItemStackHandler inv = DeepLearnerItem.getItemHandler(stack);
        ArrayList<Pair> renderable = new ArrayList<Pair>(4);
        for (int i2 = 0; i2 < 4; ++i2) {
            CachedModel cModel2;
            ItemStack model = inv.getStackInSlot(i2);
            if (model.m_41619_() || (cModel2 = new CachedModel(model, 0)).getModel() == null) continue;
            renderable.add(Pair.of((Object)cModel2, (Object)model));
        }
        if (renderable.isEmpty()) {
            return;
        }
        int spacing = 28;
        int x = 6;
        int y = 6;
        WeirdRenderThings.TRANSLUCENT_TRANSPARENCY.m_110185_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)DL_HUD);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)3, (int)3, (float)0.0f, (float)23.0f, (int)113, (int)1, (int)256, (int)256);
        for (i = 0; i < renderable.size(); ++i) {
            GuiComponent.m_93133_((PoseStack)poseStack, (int)3, (int)(4 + spacing * i), (float)0.0f, (float)24.0f, (int)113, (int)spacing, (int)256, (int)256);
            cModel = (CachedModel)((Pair)renderable.get(i)).getLeft();
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + 18), (int)(y + i * spacing + 10), (float)0.0f, (float)0.0f, (int)89, (int)12, (int)256, (int)256);
            int width = 87;
            if (cModel.getTier() != ModelTier.SELF_AWARE) {
                int prev = cModel.getTierData();
                width = Mth.m_14167_((float)((float)(width * (cModel.getData() - prev)) / (float)(cModel.getNextTierData() - prev)));
            }
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + 19), (int)(y + i * spacing + 11), (float)0.0f, (float)12.0f, (int)width, (int)10, (int)256, (int)256);
        }
        GuiComponent.m_93133_((PoseStack)poseStack, (int)3, (int)(4 + spacing * renderable.size()), (float)0.0f, (float)122.0f, (int)113, (int)2, (int)256, (int)256);
        WeirdRenderThings.TRANSLUCENT_TRANSPARENCY.m_110188_();
        for (i = 0; i < renderable.size(); ++i) {
            ItemStack dModel = (ItemStack)((Pair)renderable.get(i)).getRight();
            mc.m_91291_().m_115203_(dModel, x, y + i * spacing + 9);
        }
        for (i = 0; i < renderable.size(); ++i) {
            cModel = (CachedModel)((Pair)renderable.get(i)).getLeft();
            Component comp = cModel.getTier().getComponent();
            mc.f_91062_.m_92763_(poseStack, comp, (float)(x + 4), (float)(y + spacing * i), 0xFFFFFF);
            mc.f_91062_.m_92763_(poseStack, (Component)Component.m_237115_((String)"hostilenetworks.hud.model"), (float)(x + mc.f_91062_.m_92852_((FormattedText)comp) + 4), (float)(y + spacing * i), 0xFFFFFF);
            if (cModel.getTier() == ModelTier.SELF_AWARE) continue;
            mc.f_91062_.m_92750_(poseStack, I18n.m_118938_((String)"hostilenetworks.hud.kills", (Object[])new Object[]{cModel.getKillsNeeded()}), (float)(x + 21), (float)(y + 12 + i * spacing), 0xFFFFFF);
        }
    }

    public static void drawModel(Minecraft mc, int x, int y, ItemStack stack, CachedModel model) {
        mc.m_91291_().m_115203_(stack, x, y + 9);
        Component comp = model.getTier().getComponent();
        PoseStack matrix = new PoseStack();
        mc.f_91062_.m_92763_(matrix, comp, (float)(x + 4), (float)y, 0xFFFFFF);
        mc.f_91062_.m_92763_(matrix, (Component)Component.m_237115_((String)"hostilenetworks.hud.model"), (float)(x + mc.f_91062_.m_92852_((FormattedText)comp) + 4), (float)y, 0xFFFFFF);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)DL_HUD);
        GuiComponent.m_93133_((PoseStack)matrix, (int)(x + 18), (int)(y + 10), (float)0.0f, (float)0.0f, (int)89, (int)12, (int)256, (int)256);
        int width = 87;
        if (model.getTier() != ModelTier.SELF_AWARE) {
            width = Mth.m_14167_((float)((float)(width * model.getData()) / (float)model.getNextTierData()));
        }
        GuiComponent.m_93133_((PoseStack)matrix, (int)(x + 19), (int)(y + 11), (float)0.0f, (float)12.0f, (int)width, (int)10, (int)256, (int)256);
    }
}

