/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.palettes.AllPaletteBlocks;
import com.simibubi.create.foundation.block.CopperBlockSet;
import com.simibubi.create.foundation.utility.Iterate;
import com.tterrag.registrate.providers.ProviderType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.material.Fluid;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.base.tag_utils.ForcedTagEntry;
import rbasamoyai.createbigcannons.mixin.TagAppenderAccessor;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class CBCTags {
    public static void register() {
        CBCBlockTags.sectionRegister();
        CBCItemTags.sectionRegister();
    }

    private static ResourceLocation alloyed(String path) {
        return CBCUtils.location("alloyed", path);
    }

    private static ResourceLocation createdeco(String path) {
        return CBCUtils.location("createdeco", path);
    }

    private static <T> void addTag(TagsProvider.TagAppender<T> app, TagKey<T> tag) {
        TagAppenderAccessor accessor = (TagAppenderAccessor)app;
        TagBuilder builder = accessor.getBuilder();
        builder.m_215902_((TagEntry)new ForcedTagEntry(TagEntry.m_215949_((ResourceLocation)tag.f_203868_())));
    }

    public static class CBCBlockTags {
        public static final TagKey<Block> THICK_TUBING = CBCBlockTags.makeTag("thick_tubing");
        public static final TagKey<Block> REDUCES_SPREAD = CBCBlockTags.makeTag("reduces_spread");
        public static final TagKey<Block> DRILL_CAN_PASS_THROUGH = CBCBlockTags.makeTag("drill_can_pass_through");
        public static final TagKey<Block> OBSIDIAN = CBCBlockTags.commonTag("obsidian", "obsidian", "obsidian");
        public static final TagKey<Block> SANDSTONE = CBCBlockTags.commonTag("sandstone", "sandstone", "sandstone");
        public static final TagKey<Block> CONCRETE = CBCBlockTags.commonTag("concrete", "concrete", "concrete");
        public static final TagKey<Block> NETHERRACK = CBCBlockTags.commonTag("netherrack", "netherrack", "netherrack");
        public static final TagKey<Block> SPARK_EFFECT_ON_IMPACT = CBCBlockTags.makeTag("spark_effect_on_impact");
        public static final TagKey<Block> SPLINTER_EFFECT_ON_IMPACT = CBCBlockTags.makeTag("splinter_effect_on_impact");
        public static final TagKey<Block> GLASS_EFFECT_ON_IMPACT = CBCBlockTags.makeTag("glass_effect_on_impact");

        public static TagKey<Block> makeTag(String path) {
            TagKey tag = TagKey.m_203882_(CBCRegistryUtils.getBlockRegistryKey(), (ResourceLocation)CreateBigCannons.resource(path));
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(tag));
            return tag;
        }

        public static TagKey<Block> commonTag(String mainPath, String forgePath, String fabricPath) {
            TagKey<Block> mainTag = CBCBlockTags.makeTag(mainPath);
            CBCBlockTags.addOptionalTagsToBlockTag(mainTag, Arrays.asList(CBCUtils.location("forge", forgePath), CBCUtils.location("c", forgePath), CBCUtils.location("c", fabricPath)));
            return mainTag;
        }

        public static void addBlocksToBlockTag(TagKey<Block> tag, Block ... blocks) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(tag).m_126584_((Object[])blocks));
        }

        public static void addBlocksToBlockTag(TagKey<Block> tag, Supplier<List<? extends Block>> blocks) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (Block b : (List)blocks.get()) {
                    app.m_126582_((Object)b);
                }
            });
        }

        @SafeVarargs
        public static void addBlocksToBlockTag(TagKey<Block> tag, Supplier<? extends Block> ... blocks) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (Supplier b : blocks) {
                    app.m_126582_((Object)((Block)b.get()));
                }
            });
        }

        @SafeVarargs
        public static void addTagsToBlockTag(TagKey<Block> tag, TagKey<Block> ... tags) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (TagKey t : tags) {
                    CBCTags.addTag(app, t);
                }
            });
        }

        public static void addOptionalTagsToBlockTag(TagKey<Block> tag, List<ResourceLocation> ops) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                ops.forEach(arg_0 -> ((TagsProvider.TagAppender)app).m_176841_(arg_0));
            });
        }

        public static void addOptionalTagsToBlockTag(TagKey<Block> tag, ResourceLocation ... ops) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (ResourceLocation op : ops) {
                    app.m_176841_(op);
                }
            });
        }

        public static void sectionRegister() {
            CBCBlockTags.addBlocksToBlockTag(CONCRETE, Blocks.f_50542_, Blocks.f_50543_, Blocks.f_50544_, Blocks.f_50545_, Blocks.f_50494_, Blocks.f_50495_, Blocks.f_50496_, Blocks.f_50497_, Blocks.f_50498_, Blocks.f_50499_, Blocks.f_50500_, Blocks.f_50501_, Blocks.f_50502_, Blocks.f_50503_, Blocks.f_50504_, Blocks.f_50505_);
            CBCBlockTags.addBlocksToBlockTag(SPARK_EFFECT_ON_IMPACT, Blocks.f_50075_, Blocks.f_50166_, Blocks.f_50183_, Blocks.f_50376_, Blocks.f_50327_, Blocks.f_152598_, Blocks.f_50074_, Blocks.f_152600_, Blocks.f_50326_, Blocks.f_50721_, Blocks.f_50722_, Blocks.f_152599_, Blocks.f_152504_, Blocks.f_152503_, Blocks.f_152502_, Blocks.f_152501_, Blocks.f_152510_, Blocks.f_152509_, Blocks.f_152508_, Blocks.f_152507_, Blocks.f_152566_, Blocks.f_152565_, Blocks.f_152564_, Blocks.f_152563_, Blocks.f_152570_, Blocks.f_152569_, Blocks.f_152568_, Blocks.f_152567_, Blocks.f_152571_, Blocks.f_152573_, Blocks.f_152572_, Blocks.f_152574_, Blocks.f_152578_, Blocks.f_152577_, Blocks.f_152576_, Blocks.f_152575_, Blocks.f_152582_, Blocks.f_152581_, Blocks.f_152580_, Blocks.f_152579_, Blocks.f_152586_, Blocks.f_152585_, Blocks.f_152584_, Blocks.f_152583_);
            CBCBlockTags.addBlocksToBlockTag(SPARK_EFFECT_ON_IMPACT, new Supplier[]{AllBlocks.ZINC_BLOCK, AllBlocks.ANDESITE_ALLOY_BLOCK, AllBlocks.INDUSTRIAL_IRON_BLOCK, AllBlocks.RAILWAY_CASING, AllBlocks.BRASS_BLOCK, AllBlocks.ANDESITE_BARS, AllBlocks.BRASS_BARS, AllBlocks.COPPER_BARS, AllBlocks.METAL_GIRDER, AllBlocks.METAL_GIRDER_ENCASED_SHAFT, AllBlocks.ITEM_VAULT, AllBlocks.FLUID_TANK, AllBlocks.FLUID_PIPE, AllBlocks.FLUID_VALVE, AllBlocks.MECHANICAL_PUMP});
            CBCBlockTags.iterateOverCopperSet(AllBlocks.COPPER_SHINGLES, SPARK_EFFECT_ON_IMPACT);
            CBCBlockTags.iterateOverCopperSet(AllBlocks.COPPER_TILES, SPARK_EFFECT_ON_IMPACT);
            CBCBlockTags.addTagsToBlockTag(SPLINTER_EFFECT_ON_IMPACT, BlockTags.f_13090_, BlockTags.f_13106_, BlockTags.f_13096_, BlockTags.f_13097_, BlockTags.f_13095_, BlockTags.f_13102_, BlockTags.f_13098_, BlockTags.f_13055_, BlockTags.f_13100_, BlockTags.f_13092_);
            CBCBlockTags.addBlocksToBlockTag(SPLINTER_EFFECT_ON_IMPACT, new Supplier[]{AllBlocks.ANDESITE_CASING, AllBlocks.COPPER_CASING, AllBlocks.BRASS_CASING, AllBlocks.ANDESITE_ENCASED_SHAFT, AllBlocks.ANDESITE_ENCASED_COGWHEEL, AllBlocks.ANDESITE_ENCASED_LARGE_COGWHEEL, AllBlocks.BRASS_ENCASED_SHAFT, AllBlocks.BRASS_ENCASED_COGWHEEL, AllBlocks.BRASS_ENCASED_LARGE_COGWHEEL, AllBlocks.ENCASED_FLUID_PIPE, AllBlocks.ENCASED_CHAIN_DRIVE, AllBlocks.ADJUSTABLE_CHAIN_GEARSHIFT, AllBlocks.COGWHEEL, AllBlocks.LARGE_COGWHEEL, AllBlocks.WATER_WHEEL, AllBlocks.LARGE_WATER_WHEEL, AllBlocks.WATER_WHEEL_STRUCTURAL, AllBlocks.LINEAR_CHASSIS, AllBlocks.SECONDARY_LINEAR_CHASSIS, AllBlocks.RADIAL_CHASSIS, AllBlocks.ANDESITE_DOOR, AllBlocks.COPPER_DOOR, AllBlocks.BRASS_DOOR});
            CBCBlockTags.addOptionalTagsToBlockTag(GLASS_EFFECT_ON_IMPACT, CBCUtils.location("c", "glass"), CBCUtils.location("forge", "glass"), CBCUtils.location("c", "glass_panes"), CBCUtils.location("forge", "glass_panes"));
            CBCBlockTags.addBlocksToBlockTag(GLASS_EFFECT_ON_IMPACT, new Supplier[]{AllBlocks.FRAMED_GLASS_DOOR, AllBlocks.FRAMED_GLASS_TRAPDOOR, AllPaletteBlocks.OAK_WINDOW, AllPaletteBlocks.OAK_WINDOW_PANE, AllPaletteBlocks.SPRUCE_WINDOW, AllPaletteBlocks.SPRUCE_WINDOW_PANE, AllPaletteBlocks.BIRCH_WINDOW, AllPaletteBlocks.BIRCH_WINDOW_PANE, AllPaletteBlocks.JUNGLE_WINDOW, AllPaletteBlocks.JUNGLE_WINDOW_PANE, AllPaletteBlocks.DARK_OAK_WINDOW, AllPaletteBlocks.DARK_OAK_WINDOW_PANE, AllPaletteBlocks.ACACIA_WINDOW, AllPaletteBlocks.ACACIA_WINDOW_PANE, AllPaletteBlocks.WARPED_WINDOW, AllPaletteBlocks.WARPED_WINDOW_PANE, AllPaletteBlocks.CRIMSON_WINDOW, AllPaletteBlocks.CRIMSON_WINDOW_PANE, AllPaletteBlocks.ORNATE_IRON_WINDOW, AllPaletteBlocks.ORNATE_IRON_WINDOW_PANE});
        }

        private static void iterateOverCopperSet(CopperBlockSet set, TagKey<Block> tag) {
            for (boolean waxed : Iterate.falseAndTrue) {
                for (CopperBlockSet.Variant variant : set.getVariants()) {
                    for (WeatheringCopper.WeatherState weathering : WeatheringCopper.WeatherState.values()) {
                        CBCBlockTags.addBlocksToBlockTag(tag, new Supplier[]{set.get(variant, weathering, waxed)});
                    }
                }
            }
        }
    }

    public static class CBCItemTags {
        public static final TagKey<Item> IMPACT_FUZE_HEAD = CBCItemTags.makeTag("impact_fuze_head");
        public static final TagKey<Item> NUGGET_CAST_IRON = CBCItemTags.commonTag("nugget_cast_iron", "nuggets/cast_iron", "cast_iron_nuggets");
        public static final TagKey<Item> INGOT_CAST_IRON = CBCItemTags.commonTag("ingot_cast_iron", "ingots/cast_iron", "cast_iron_ingots");
        public static final TagKey<Item> BLOCK_CAST_IRON = CBCItemTags.commonTag("block_cast_iron", "storage_blocks/cast_iron", "cast_iron_blocks");
        public static final TagKey<Item> NUGGET_BRONZE = CBCItemTags.commonTag("nugget_bronze", "nuggets/bronze", "bronze_nuggets");
        public static final TagKey<Item> INGOT_BRONZE = CBCItemTags.commonTag("ingot_bronze", "ingots/bronze", "bronze_ingots");
        public static final TagKey<Item> BLOCK_BRONZE = CBCItemTags.commonTag("block_bronze", "storage_blocks/bronze", "bronze_blocks");
        public static final TagKey<Item> NUGGET_STEEL = CBCItemTags.commonTag("nugget_steel", "nuggets/steel", "steel_nuggets");
        public static final TagKey<Item> INGOT_STEEL = CBCItemTags.commonTag("ingot_steel", "ingots/steel", "steel_ingots");
        public static final TagKey<Item> BLOCK_STEEL = CBCItemTags.commonTag("block_steel", "storage_blocks/steel", "steel_blocks");
        public static final TagKey<Item> NUGGET_NETHERSTEEL = CBCItemTags.commonTag("nugget_nethersteel", "nuggets/nethersteel", "nethersteel_nuggets");
        public static final TagKey<Item> INGOT_NETHERSTEEL = CBCItemTags.commonTag("ingot_nethersteel", "ingots/nethersteel", "nethersteel_ingots");
        public static final TagKey<Item> BLOCK_NETHERSTEEL = CBCItemTags.commonTag("block_nethersteel", "blocks/nethersteel", "nethersteel_blocks");
        public static final TagKey<Item> INGOT_IRON = CBCItemTags.commonTag("ingot_iron", "ingots/iron", "iron_ingots");
        public static final TagKey<Item> NUGGET_IRON = CBCItemTags.commonTag("nugget_iron", "nuggets/iron", "iron_nuggets");
        public static final TagKey<Item> SHEET_IRON = CBCItemTags.commonTag("sheet_iron", "plates/iron", "iron_plates");
        public static final TagKey<Item> NUGGET_COPPER = CBCItemTags.commonTag("nugget_copper", "nuggets/copper", "copper_nuggets");
        public static final TagKey<Item> GUNPOWDER = CBCItemTags.commonTag("gunpowder", "gunpowder", "gunpowder");
        public static final TagKey<Item> GEMS_QUARTZ = CBCItemTags.commonTag("gems_quartz", "gems/quartz", "quartz");
        public static final TagKey<Item> DUSTS_REDSTONE = CBCItemTags.commonTag("dusts_redstone", "dusts/redstone", "redstone_dusts");
        public static final TagKey<Item> STONE = CBCItemTags.commonTag("stone", "stone", "stone");
        public static final TagKey<Item> SHEET_BRASS = CBCItemTags.commonTag("sheet_brass", "plates/brass", "brass_plates");
        public static final TagKey<Item> INGOT_BRASS = CBCItemTags.commonTag("ingot_brass", "ingots/brass", "brass_ingots");
        public static final TagKey<Item> SHEET_COPPER = CBCItemTags.commonTag("sheet_copper", "plates/copper", "copper_plates");
        public static final TagKey<Item> SHEET_GOLD = CBCItemTags.commonTag("sheet_copper", "plates/gold", "gold_plates");
        public static final TagKey<Item> SHEET_STEEL = CBCItemTags.commonTag("sheet_steel", "plates/steel", "steel_plates");
        public static final TagKey<Item> DUST_GLOWSTONE = CBCItemTags.commonTag("dust_glowstone", "dusts/glowstone", "glowstone_dusts");
        public static final TagKey<Item> GLASS = CBCItemTags.commonTag("glass", "glass", "glass");
        public static final TagKey<Item> INEXPENSIVE_BIG_CARTRIDGE_SHEET = CBCItemTags.makeTag("inexpensive_big_cartridge_sheet");
        public static final TagKey<Item> NITROPOWDER = CBCItemTags.makeTag("nitropowder");
        public static final TagKey<Item> BIG_CANNON_PROPELLANT = CBCItemTags.makeTag("big_cannon_propellant");
        public static final TagKey<Item> BIG_CANNON_PROPELLANT_BAGS = CBCItemTags.makeTag("big_cannon_propellant_bags");
        public static final TagKey<Item> BIG_CANNON_CARTRIDGES = CBCItemTags.makeTag("big_cannon_cartridges");
        public static final TagKey<Item> BIG_CANNON_PROJECTILES = CBCItemTags.makeTag("big_cannon_projectiles");
        public static final TagKey<Item> AUTOCANNON_AMMO_CONTAINERS = CBCItemTags.makeTag("autocannon_ammo_containers");
        public static final TagKey<Item> FUZES = CBCItemTags.makeTag("fuzes");
        public static final TagKey<Item> SPENT_AUTOCANNON_CASINGS = CBCItemTags.makeTag("spent_autocannon_casings");
        public static final TagKey<Item> AUTOCANNON_CARTRIDGES = CBCItemTags.makeTag("autocannon_cartridges");
        public static final TagKey<Item> AUTOCANNON_ROUNDS = CBCItemTags.makeTag("autocannon_rounds");
        public static final TagKey<Item> GUNPOWDER_PINCH = CBCItemTags.makeTag("gunpowder_pinch");
        public static final TagKey<Item> GUNCOTTON = CBCItemTags.makeTag("guncotton");
        public static final TagKey<Item> CAN_BE_NITRATED = CBCItemTags.makeTag("can_be_nitrated");
        public static final TagKey<Item> HIGH_EXPLOSIVE_MATERIALS = CBCItemTags.makeTag("high_explosive_materials");
        public static final TagKey<Item> NITRO_ACIDIFIERS = CBCItemTags.makeTag("nitro_acidifiers");
        public static final TagKey<Item> GELATINIZERS = CBCItemTags.makeTag("gelatinizers");
        public static final TagKey<Item> GAS_MASKS = CBCItemTags.makeTag("gas_masks");

        public static TagKey<Item> makeTag(String loc) {
            TagKey<Item> tag = CBCRegistryUtils.createItemTag(CreateBigCannons.resource(loc));
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(tag));
            return tag;
        }

        public static TagKey<Item> commonTag(String mainPath, String forgePath, String fabricPath) {
            TagKey<Item> mainTag = CBCItemTags.makeTag(mainPath);
            CBCItemTags.addOptionalTagsToItemTag(mainTag, Arrays.asList(CBCUtils.location("forge", forgePath), CBCUtils.location("c", forgePath), CBCUtils.location("c", fabricPath)));
            return mainTag;
        }

        public static void addItemsToItemTag(TagKey<Item> tag, Item ... items) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(tag).m_126584_((Object[])items));
        }

        public static void addItemsToItemTag(TagKey<Item> tag, ItemLike ... items) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (ItemLike bp : items) {
                    app.m_126582_((Object)bp.m_5456_());
                }
            });
        }

        @SafeVarargs
        public static void addTagsToItemTag(TagKey<Item> tag, TagKey<Item> ... tags) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (TagKey t : tags) {
                    CBCTags.addTag(app, t);
                }
            });
        }

        public static void addIdsToItemTag(TagKey<Item> tag, ResourceLocation ... ids) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (ResourceLocation id : ids) {
                    app.m_176839_(id);
                }
            });
        }

        public static void addOptionalTagsToItemTag(TagKey<Item> tag, List<ResourceLocation> ops) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                ops.forEach(arg_0 -> ((TagsProvider.TagAppender)app).m_176841_(arg_0));
            });
        }

        public static void sectionRegister() {
            CBCItemTags.addItemsToItemTag(IMPACT_FUZE_HEAD, Items.f_42083_, Items.f_42145_);
            CBCItemTags.addIdsToItemTag(BLOCK_BRONZE, CBCTags.alloyed("bronze_block"));
            CBCItemTags.addIdsToItemTag(BLOCK_STEEL, CBCTags.alloyed("steel_block"));
            CBCItemTags.addIdsToItemTag(BLOCK_CAST_IRON, CBCTags.createdeco("cast_iron_block"));
            CBCItemTags.addTagsToItemTag(INEXPENSIVE_BIG_CARTRIDGE_SHEET, SHEET_GOLD, SHEET_COPPER);
            CBCItemTags.addTagsToItemTag(BIG_CANNON_PROPELLANT, BIG_CANNON_PROPELLANT_BAGS, BIG_CANNON_CARTRIDGES);
            CBCItemTags.addItemsToItemTag(CAN_BE_NITRATED, Items.f_42516_);
            CBCItemTags.addItemsToItemTag(GELATINIZERS, Items.f_42518_);
            CBCItemTags.addTagsToItemTag(NITRO_ACIDIFIERS, DUSTS_REDSTONE);
        }
    }

    public static class CBCFluidTags {
        public static final TagKey<Fluid> MOLTEN_METAL = CBCFluidTags.makeTag("molten_metal");

        public static TagKey<Fluid> makeTag(String loc) {
            TagKey tag = TagKey.m_203882_(CBCRegistryUtils.getFluidRegistryKey(), (ResourceLocation)CreateBigCannons.resource(loc));
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, prov -> prov.m_206424_(tag));
            return tag;
        }
    }
}

