/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.cannon_mount;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;

public class CannonMountInstance
extends KineticBlockEntityInstance<CannonMountBlockEntity>
implements DynamicInstance {
    private OrientedData rotatingMount;
    private OrientedData rotatingMountShaft;
    private RotatingData pitchShaft;
    private RotatingData yawShaft;

    public CannonMountInstance(MaterialManager dispatcher, CannonMountBlockEntity tile) {
        super(dispatcher, (KineticBlockEntity)tile);
    }

    public void init() {
        super.init();
        int blockLight = this.world.m_45517_(LightLayer.BLOCK, this.pos);
        int skyLight = this.world.m_45517_(LightLayer.SKY, this.pos);
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        Direction.Axis pitchAxis = facing.m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        Material rotatingMaterial = this.getRotatingMaterial();
        Instancer shaftInstance = rotatingMaterial.getModel((BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)pitchAxis));
        this.rotatingMount = (OrientedData)this.materialManager.defaultCutout().material(Materials.ORIENTED).getModel(CBCBlockPartials.ROTATING_MOUNT, this.blockState).createInstance();
        this.rotatingMount.setPosition(this.getInstancePosition().m_7494_());
        this.rotatingMountShaft = (OrientedData)this.materialManager.defaultCutout().material(Materials.ORIENTED).getModel(CBCBlockPartials.CANNON_CARRIAGE_AXLE, this.blockState, Direction.NORTH).createInstance();
        this.rotatingMountShaft.setPosition(this.getInstancePosition().m_6630_(2));
        this.pitchShaft = (RotatingData)shaftInstance.createInstance();
        this.pitchShaft.setRotationAxis(pitchAxis).setRotationOffset(this.getRotationOffset(pitchAxis)).setColor((KineticBlockEntity)this.blockEntity).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
        this.yawShaft = (RotatingData)rotatingMaterial.getModel(CBCBlockPartials.YAW_SHAFT, this.blockState, Direction.DOWN).createInstance();
        this.yawShaft.setRotationAxis(Direction.Axis.Y).setRotationOffset(this.getRotationOffset(Direction.Axis.Y)).setColor((KineticBlockEntity)this.blockEntity).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
        this.transformModels();
    }

    public void remove() {
        this.rotatingMount.delete();
        this.rotatingMountShaft.delete();
        this.pitchShaft.delete();
        this.yawShaft.delete();
    }

    private void transformModels() {
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        Direction.Axis pitchAxis = facing.m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        this.updateRotation(this.pitchShaft, pitchAxis, this.getBlockEntitySpeed());
        this.updateRotation(this.yawShaft, Direction.Axis.Y, ((CannonMountBlockEntity)this.blockEntity).getYawSpeed());
    }

    public void beginFrame() {
        this.transformModels();
        float partialTicks = AnimationTickHolder.getPartialTicks();
        float yaw = ((CannonMountBlockEntity)this.blockEntity).getYawOffset(partialTicks);
        Quaternion qyaw = Vector3f.f_122224_.m_122240_(yaw);
        this.rotatingMount.setRotation(qyaw);
        float pitch = ((CannonMountBlockEntity)this.blockEntity).getPitchOffset(partialTicks);
        Quaternion qpitch = Vector3f.f_122223_.m_122240_(-pitch);
        Quaternion qyaw1 = qyaw.m_80161_();
        qyaw1.m_80148_(qpitch);
        this.rotatingMountShaft.setRotation(qyaw1);
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos.m_121945_(Direction.UP), new FlatLit[]{this.rotatingMount});
        this.relight(this.pos.m_5484_(Direction.UP, 2), new FlatLit[]{this.rotatingMountShaft});
        this.relight(this.pos, new FlatLit[]{this.pitchShaft});
        this.relight(this.pos, new FlatLit[]{this.yawShaft});
    }
}

