/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.contraption;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.StructureTransform;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.cannon_types.CBCCannonContraptionTypes;
import rbasamoyai.createbigcannons.cannon_control.cannon_types.ICannonContraptionType;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.BigCannonBreechStrengthHandler;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech.QuickfiringBreechBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.cannon_end.BigCannonEnd;
import rbasamoyai.createbigcannons.cannons.big_cannons.material.BigCannonMaterial;
import rbasamoyai.createbigcannons.cannons.big_cannons.material.BigCannonMaterialProperties;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.effects.particles.explosions.CannonBlastWaveEffectParticleData;
import rbasamoyai.createbigcannons.effects.particles.plumes.BigCannonPlumeParticleData;
import rbasamoyai.createbigcannons.effects.particles.plumes.DropMortarPlumeParticleData;
import rbasamoyai.createbigcannons.index.CBCBigCannonMaterials;
import rbasamoyai.createbigcannons.index.CBCContraptionTypes;
import rbasamoyai.createbigcannons.index.CBCSoundEvents;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.AbstractBigCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.DropMortarMunition;
import rbasamoyai.createbigcannons.munitions.big_cannon.DropMortarProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.ProjectileBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.config.DropMortarProjectilePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCannonPropellantBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.IntegratedPropellantProjectile;
import rbasamoyai.createbigcannons.munitions.config.BigCannonPropellantCompatibilities;
import rbasamoyai.createbigcannons.munitions.config.BigCannonPropellantCompatibilityHandler;
import rbasamoyai.createbigcannons.utils.CBCUtils;
import rbasamoyai.ritchiesprojectilelib.RitchiesProjectileLib;

public class MountedBigCannonContraption
extends AbstractMountedCannonContraption {
    private BigCannonMaterial cannonMaterial;
    public boolean hasFired = false;
    public boolean hasWeldedPenalty = false;
    protected int mortarDelay = 0;
    protected ItemStack cachedMortarRound = ItemStack.f_41583_;

    public boolean assemble(Level level, BlockPos pos) throws AssemblyException {
        if (!this.collectCannonBlocks(level, pos)) {
            return false;
        }
        this.bounds = this.createBoundsFromExtensionLengths();
        return !this.blocks.isEmpty();
    }

    private boolean collectCannonBlocks(Level level, BlockPos pos) throws AssemblyException {
        BlockPos negativeEndPos;
        BlockState startState = level.m_8055_(pos);
        Block block = startState.m_60734_();
        if (!(block instanceof BigCannonBlock)) {
            return false;
        }
        BigCannonBlock startCannon = (BigCannonBlock)block;
        if (!startCannon.isComplete(startState)) {
            throw MountedBigCannonContraption.hasIncompleteCannonBlocks(pos);
        }
        if (this.hasCannonLoaderInside((LevelAccessor)level, startState, pos)) {
            throw MountedBigCannonContraption.cannonLoaderInsideDuringAssembly(pos);
        }
        BigCannonMaterial material = startCannon.getCannonMaterial();
        BigCannonEnd startEnd = startCannon.getOpeningType(level, startState, pos);
        ArrayList<StructureTemplate.StructureBlockInfo> cannonBlocks = new ArrayList<StructureTemplate.StructureBlockInfo>();
        cannonBlocks.add(new StructureTemplate.StructureBlockInfo(pos, startState, this.getBlockEntityNBT(level, pos)));
        int cannonLength = 1;
        Direction cannonFacing = startCannon.getFacing(startState);
        Direction positive = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)cannonFacing.m_122434_());
        Direction negative = positive.m_122424_();
        BlockPos start = pos;
        BlockState nextState = level.m_8055_(pos.m_121945_(positive));
        BigCannonEnd positiveEnd = startEnd;
        while (this.isValidCannonBlock((LevelAccessor)level, nextState, start.m_121945_(positive)) && this.isConnectedToCannon((LevelAccessor)level, nextState, start.m_121945_(positive), positive, material)) {
            start = start.m_121945_(positive);
            if (!((BigCannonBlock)nextState.m_60734_()).isComplete(nextState)) {
                throw MountedBigCannonContraption.hasIncompleteCannonBlocks(start);
            }
            cannonBlocks.add(new StructureTemplate.StructureBlockInfo(start, nextState, this.getBlockEntityNBT(level, start)));
            ++this.frontExtensionLength;
            ++cannonLength;
            positiveEnd = ((BigCannonBlock)nextState.m_60734_()).getOpeningType(level, nextState, start);
            if (this.hasCannonLoaderInside((LevelAccessor)level, nextState, start)) {
                throw MountedBigCannonContraption.cannonLoaderInsideDuringAssembly(start);
            }
            nextState = level.m_8055_(start.m_121945_(positive));
            if (cannonLength > MountedBigCannonContraption.getMaxCannonLength()) {
                throw MountedBigCannonContraption.cannonTooLarge();
            }
            if (positiveEnd == BigCannonEnd.OPEN) continue;
        }
        BlockPos positiveEndPos = positiveEnd == BigCannonEnd.OPEN ? start : start.m_121945_(negative);
        start = pos;
        nextState = level.m_8055_(pos.m_121945_(negative));
        BigCannonEnd negativeEnd = startEnd;
        while (this.isValidCannonBlock((LevelAccessor)level, nextState, start.m_121945_(negative)) && this.isConnectedToCannon((LevelAccessor)level, nextState, start.m_121945_(negative), negative, material)) {
            start = start.m_121945_(negative);
            if (!((BigCannonBlock)nextState.m_60734_()).isComplete(nextState)) {
                throw MountedBigCannonContraption.hasIncompleteCannonBlocks(start);
            }
            cannonBlocks.add(new StructureTemplate.StructureBlockInfo(start, nextState, this.getBlockEntityNBT(level, start)));
            ++this.backExtensionLength;
            ++cannonLength;
            negativeEnd = ((BigCannonBlock)nextState.m_60734_()).getOpeningType(level, nextState, start);
            if (this.hasCannonLoaderInside((LevelAccessor)level, nextState, start)) {
                throw MountedBigCannonContraption.cannonLoaderInsideDuringAssembly(start);
            }
            nextState = level.m_8055_(start.m_121945_(negative));
            if (cannonLength > MountedBigCannonContraption.getMaxCannonLength()) {
                throw MountedBigCannonContraption.cannonTooLarge();
            }
            if (negativeEnd == BigCannonEnd.OPEN) continue;
        }
        BlockPos blockPos = negativeEndPos = negativeEnd == BigCannonEnd.OPEN ? start : start.m_121945_(positive);
        if (positiveEnd == negativeEnd) {
            throw MountedBigCannonContraption.invalidCannon();
        }
        boolean openEndFlag = positiveEnd == BigCannonEnd.OPEN;
        this.initialOrientation = openEndFlag ? positive : negative;
        this.startPos = openEndFlag ? negativeEndPos : positiveEndPos;
        this.anchor = pos;
        this.startPos = this.startPos.m_121996_((Vec3i)pos);
        for (StructureTemplate.StructureBlockInfo blockInfo : cannonBlocks) {
            IBigCannonBlockEntity cbe;
            BlockPos localPos = blockInfo.f_74675_.m_121996_((Vec3i)pos);
            StructureTemplate.StructureBlockInfo localBlockInfo = new StructureTemplate.StructureBlockInfo(localPos, blockInfo.f_74676_, blockInfo.f_74677_);
            this.getBlocks().put(localPos, localBlockInfo);
            if (blockInfo.f_74677_ == null) continue;
            BlockEntity be = BlockEntity.m_155241_((BlockPos)localPos, (BlockState)blockInfo.f_74676_, (CompoundTag)blockInfo.f_74677_);
            this.presentBlockEntities.put(localPos, be);
            if (!(be instanceof IBigCannonBlockEntity) || !((BigCannonBehavior)((Object)(cbe = (IBigCannonBlockEntity)be).cannonBehavior())).isWelded()) continue;
            this.hasWeldedPenalty = true;
        }
        this.cannonMaterial = material;
        return true;
    }

    private boolean isValidCannonBlock(LevelAccessor level, BlockState state, BlockPos pos) {
        return state.m_60734_() instanceof BigCannonBlock;
    }

    private boolean hasCannonLoaderInside(LevelAccessor level, BlockState state, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof IBigCannonBlockEntity)) {
            return false;
        }
        IBigCannonBlockEntity cannon = (IBigCannonBlockEntity)be;
        BlockState containedState = ((BigCannonBehavior)((Object)cannon.cannonBehavior())).block().f_74676_;
        return IBigCannonBlockEntity.isValidLoader(null, new StructureTemplate.StructureBlockInfo(BlockPos.f_121853_, containedState, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConnectedToCannon(LevelAccessor level, BlockState state, BlockPos pos, Direction connection, BigCannonMaterial material) {
        BigCannonBlock cBlock = (BigCannonBlock)state.m_60734_();
        if (cBlock.getCannonMaterialInLevel(level, state, pos) != material) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof IBigCannonBlockEntity)) return false;
        IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)blockEntity;
        blockEntity = level.m_7702_(pos.m_121945_(connection.m_122424_()));
        if (!(blockEntity instanceof IBigCannonBlockEntity)) return false;
        IBigCannonBlockEntity cbe1 = (IBigCannonBlockEntity)blockEntity;
        if (!((BigCannonBehavior)((Object)cbe.cannonBehavior())).isConnectedTo(connection.m_122424_())) return false;
        if (!((BigCannonBehavior)((Object)cbe1.cannonBehavior())).isConnectedTo(connection)) return false;
        return true;
    }

    @Override
    public float getWeightForStress() {
        if (this.cannonMaterial == null) {
            return this.blocks.size();
        }
        return (float)this.blocks.size() * this.cannonMaterial.properties().weight();
    }

    @Override
    public void tick(Level level, PitchOrientedContraptionEntity entity) {
        super.tick(level, entity);
        BlockPos endPos = this.startPos.m_121945_(this.initialOrientation.m_122424_());
        Object v = this.presentBlockEntities.get(endPos);
        if (v instanceof QuickfiringBreechBlockEntity) {
            QuickfiringBreechBlockEntity qfbreech = (QuickfiringBreechBlockEntity)v;
            qfbreech.tickAnimation();
        }
        if (!level.f_46443_ && this.isDropMortar() && this.mortarDelay > 0) {
            --this.mortarDelay;
            if (this.mortarDelay == 0) {
                this.actuallyFireDropMortar();
            }
        }
    }

    @Override
    public void onRedstoneUpdate(ServerLevel level, PitchOrientedContraptionEntity entity, boolean togglePower, int firePower, ControlPitchContraption controller) {
        if (!togglePower || firePower <= 0) {
            return;
        }
        this.fireShot(level, entity);
    }

    public int getMaxSafeCharges() {
        BigCannonMaterialProperties properties = this.cannonMaterial.properties();
        StructureTemplate.StructureBlockInfo breech = (StructureTemplate.StructureBlockInfo)this.blocks.get(this.startPos.m_121945_(this.initialOrientation.m_122424_()));
        if (breech == null) {
            return 0;
        }
        int materialStrength = properties.maxSafePropellantStress();
        int maxSafeCharges = Math.min(materialStrength, BigCannonBreechStrengthHandler.getStrength(breech.f_74676_.m_60734_(), materialStrength));
        if (this.hasWeldedPenalty) {
            maxSafeCharges -= properties.weldStressPenalty();
        }
        return Math.max(maxSafeCharges, 0);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void fireShot(ServerLevel level, PitchOrientedContraptionEntity entity) {
        endPos = this.startPos.m_121945_(this.initialOrientation.m_122424_());
        var5_4 = this.presentBlockEntities.get(endPos);
        if (var5_4 instanceof QuickfiringBreechBlockEntity && (qfbreech = (QuickfiringBreechBlockEntity)var5_4).getOpenProgress() > 0) {
            return;
        }
        if (this.isDropMortar()) {
            return;
        }
        controller = entity.getController();
        rand = level.m_213780_();
        currentPos = this.startPos.m_7949_();
        count = 0;
        maxSafeCharges = this.getMaxSafeCharges();
        canFail = (Boolean)CBCConfigs.SERVER.failure.disableAllFailure.get() == false;
        spreadSub = this.cannonMaterial.properties().spreadReductionPerBarrel();
        emptyNoProjectile = false;
        propelCtx = new PropellantContext();
        projectileBlocks = new ArrayList<StructureTemplate.StructureBlockInfo>();
        projectile = null;
        assemblyPos = null;
        minimumSpread = this.cannonMaterial.properties().minimumSpread();
        while ((var18_18 = this.presentBlockEntities.get(currentPos)) instanceof IBigCannonBlockEntity) {
            block48: {
                block49: {
                    block47: {
                        cbe = (IBigCannonBlockEntity)var18_18;
                        behavior = (BigCannonBehavior)cbe.cannonBehavior();
                        containedBlockInfo = behavior.block();
                        cannonInfo = (StructureTemplate.StructureBlockInfo)this.blocks.get(currentPos);
                        if (cannonInfo == null) break;
                        block = containedBlockInfo.f_74676_.m_60734_();
                        if (!containedBlockInfo.f_74676_.m_60795_()) break block47;
                        if (count == 0) {
                            return;
                        }
                        if (projectile == null) {
                            if (projectileBlocks.isEmpty()) {
                                emptyNoProjectile = true;
                                propelCtx.chargesUsed = Math.max(propelCtx.chargesUsed - 1.0f, 0.0f);
                            } else if (canFail) {
                                this.fail(currentPos, (Level)level, entity, (BlockEntity)behavior.blockEntity, (int)propelCtx.chargesUsed);
                                return;
                            }
                        } else {
                            ++propelCtx.barrelTravelled;
                            if (cannonInfo.f_74676_.m_204336_(CBCTags.CBCBlockTags.REDUCES_SPREAD)) {
                                propelCtx.spread = Math.max(propelCtx.spread - spreadSub, minimumSpread);
                            }
                            if (canFail && projectile.canSquib() && this.cannonMaterial.properties().mayGetStuck(propelCtx.chargesUsed, propelCtx.barrelTravelled) && MountedBigCannonContraption.rollSquib(rand)) {
                                this.squibBlocks(currentPos, projectileBlocks);
                                squibPos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos.m_121945_(this.initialOrientation)), 0.0f);
                                level.m_6263_(null, squibPos.f_82479_, squibPos.f_82480_, squibPos.f_82481_, cannonInfo.f_74676_.m_60827_().m_56775_(), SoundSource.BLOCKS, 10.0f, 0.0f);
                                return;
                            }
                        }
                        break block48;
                    }
                    if (!(block instanceof BigCannonPropellantBlock)) break block49;
                    cpropel = (BigCannonPropellantBlock)block;
                    if (block instanceof ProjectileBlock) break block49;
                    if (!cpropel.canBeIgnited(containedBlockInfo, this.initialOrientation)) {
                        return;
                    }
                    if (!propelCtx.addPropellant(cpropel, containedBlockInfo, this.initialOrientation) && canFail) {
                        this.fail(currentPos, (Level)level, entity, (BlockEntity)behavior.blockEntity, (int)propelCtx.chargesUsed);
                        return;
                    }
                    this.consumeBlock(behavior, currentPos, (Consumer<BigCannonBehavior>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, consumePropellant(rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior ), (Lrbasamoyai/createbigcannons/cannons/big_cannons/BigCannonBehavior;)V)((BigCannonPropellantBlock)cpropel));
                    if (canFail && (!cbe.blockCanHandle(cannonInfo) && MountedBigCannonContraption.rollBarrelBurst(rand) || propelCtx.stress > (float)maxSafeCharges && MountedBigCannonContraption.rollOverloadBurst(rand))) {
                        this.fail(currentPos, (Level)level, entity, (BlockEntity)behavior.blockEntity, (int)propelCtx.chargesUsed);
                        return;
                    }
                    if (emptyNoProjectile && canFail && MountedBigCannonContraption.rollFailToIgnite(rand)) {
                        failIgnitePos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos.m_121945_(this.initialOrientation)), 0.0f);
                        level.m_6263_(null, failIgnitePos.f_82479_, failIgnitePos.f_82480_, failIgnitePos.f_82481_, cannonInfo.f_74676_.m_60827_().m_56775_(), SoundSource.BLOCKS, 5.0f, 0.0f);
                        return;
                    }
                    emptyNoProjectile = false;
                    break block48;
                }
                if (!(block instanceof ProjectileBlock)) ** GOTO lbl-1000
                projBlock = (ProjectileBlock)block;
                if (projectile == null) {
                    if (canFail && emptyNoProjectile && MountedBigCannonContraption.rollFailToIgnite(rand)) {
                        failIgnitePos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos.m_121945_(this.initialOrientation)), 0.0f);
                        level.m_6263_(null, failIgnitePos.f_82479_, failIgnitePos.f_82480_, failIgnitePos.f_82481_, cannonInfo.f_74676_.m_60827_().m_56775_(), SoundSource.BLOCKS, 5.0f, 0.0f);
                        return;
                    }
                    projectileBlocks.add(containedBlockInfo);
                    if (assemblyPos == null) {
                        assemblyPos = currentPos.m_7949_();
                    }
                    copy = ImmutableList.copyOf(projectileBlocks);
                    projIter = projectileBlocks.listIterator();
                    while (projIter.hasNext()) {
                        i = projIter.nextIndex();
                        projInfo = (StructureTemplate.StructureBlockInfo)projIter.next();
                        var29_41 = projInfo.f_74676_.m_60734_();
                        if (var29_41 instanceof ProjectileBlock && (cproj1 = (ProjectileBlock)var29_41).isValidAddition((List<StructureTemplate.StructureBlockInfo>)copy, projInfo, i, this.initialOrientation)) continue;
                        if (canFail) {
                            this.fail(currentPos, (Level)level, entity, (BlockEntity)behavior.blockEntity, (int)propelCtx.chargesUsed);
                        }
                        return;
                    }
                    this.consumeBlock(behavior, currentPos);
                    if (cannonInfo.f_74676_.m_204336_(CBCTags.CBCBlockTags.REDUCES_SPREAD)) {
                        propelCtx.spread = Math.max(propelCtx.spread - spreadSub, minimumSpread);
                    }
                    if (projBlock.isComplete(projectileBlocks, this.initialOrientation)) {
                        projectile = projBlock.getProjectile((Level)level, projectileBlocks);
                        propelCtx.chargesUsed += projectile.addedChargePower();
                        if (propelCtx.chargesUsed <= 0.0f || canFail && propelCtx.chargesUsed < projectile.minimumChargePower()) {
                            this.squibBlocks(assemblyPos, projectileBlocks);
                            return;
                        }
                    }
                    emptyNoProjectile = false;
                } else lbl-1000:
                // 2 sources

                {
                    if (canFail) {
                        this.fail(currentPos, (Level)level, entity, (BlockEntity)behavior.blockEntity, (int)propelCtx.chargesUsed);
                        return;
                    }
                    this.consumeBlock(behavior, currentPos);
                }
            }
            currentPos = currentPos.m_121945_(this.initialOrientation);
            cannonState = cannonInfo.f_74676_;
            copy = cannonState.m_60734_();
            if (!(copy instanceof BigCannonBlock) || (cannon = (BigCannonBlock)copy).getOpeningType((Level)level, cannonState, currentPos) != BigCannonEnd.OPEN) continue;
            ++count;
        }
        if (projectile == null && !projectileBlocks.isEmpty()) {
            info = (StructureTemplate.StructureBlockInfo)projectileBlocks.get(0);
            containedBlockInfo = info.f_74676_.m_60734_();
            if (!(containedBlockInfo instanceof ProjectileBlock)) {
                if (canFail) {
                    this.fail(currentPos, (Level)level, entity, null, (int)propelCtx.chargesUsed);
                }
                return;
            }
            projBlock = (ProjectileBlock)containedBlockInfo;
            remaining = projBlock.getExpectedSize() - projectileBlocks.size();
            if (remaining < 1) {
                if (canFail) {
                    this.fail(currentPos, (Level)level, entity, null, (int)propelCtx.chargesUsed);
                }
                return;
            }
            for (i = 0; i < remaining; ++i) {
                additionalInfo = (StructureTemplate.StructureBlockInfo)this.blocks.remove(currentPos);
                if (additionalInfo == null) {
                    if (canFail) {
                        this.fail(currentPos, (Level)level, entity, null, (int)propelCtx.chargesUsed);
                    }
                    return;
                }
                projectileBlocks.add(additionalInfo);
                copy = ImmutableList.copyOf(projectileBlocks);
                projIter = projectileBlocks.listIterator();
                while (projIter.hasNext()) {
                    j = projIter.nextIndex();
                    projInfo = (StructureTemplate.StructureBlockInfo)projIter.next();
                    projInfo = projInfo.f_74676_.m_60734_();
                    if (projInfo instanceof ProjectileBlock && (cproj1 = (ProjectileBlock)projInfo).isValidAddition((List<StructureTemplate.StructureBlockInfo>)copy, projInfo, j, this.initialOrientation)) continue;
                    if (canFail) {
                        this.fail(currentPos, (Level)level, entity, null, (int)propelCtx.chargesUsed);
                    }
                    return;
                }
                currentPos = currentPos.m_121945_(this.initialOrientation);
            }
            assemblyPos = currentPos.m_7949_().m_121945_(this.initialOrientation.m_122424_());
            if (projBlock.isComplete(projectileBlocks, this.initialOrientation)) {
                projectile = projBlock.getProjectile((Level)level, projectileBlocks);
                propelCtx.chargesUsed += projectile.addedChargePower();
                if (propelCtx.chargesUsed <= 0.0f || canFail && propelCtx.chargesUsed < projectile.minimumChargePower()) {
                    this.squibBlocks(assemblyPos, projectileBlocks);
                    return;
                }
            } else if (canFail) {
                this.fail(currentPos, (Level)level, entity, null, (int)propelCtx.chargesUsed);
                return;
            }
        }
        spawnPos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos.m_121945_(this.initialOrientation)), 0.0f);
        vec = spawnPos.m_82546_(entity.toGlobalVector(Vec3.m_82512_((Vec3i)BlockPos.f_121853_), 0.0f)).m_82541_();
        spawnPos = spawnPos.m_82546_(vec.m_82490_(2.0));
        if (propelCtx.chargesUsed < minimumSpread) {
            propelCtx.chargesUsed = minimumSpread;
        }
        recoilMagnitude = 0.0f;
        if (projectile != null) {
            if (projectile instanceof IntegratedPropellantProjectile) {
                integPropel = (IntegratedPropellantProjectile)projectile;
                if (!projectileBlocks.isEmpty() && !propelCtx.addIntegratedPropellant(integPropel, (StructureTemplate.StructureBlockInfo)projectileBlocks.get(0), this.initialOrientation) && canFail) {
                    this.fail(currentPos, (Level)level, entity, null, (int)propelCtx.chargesUsed);
                    return;
                }
            }
            muzzleInfo = (StructureTemplate.StructureBlockInfo)this.blocks.get(currentPos);
            if (canFail && muzzleInfo != null && !muzzleInfo.f_74676_.m_60795_()) {
                this.fail(currentPos, (Level)level, entity, null, (int)propelCtx.chargesUsed);
                return;
            }
            projectile.m_146884_(spawnPos);
            projectile.setChargePower(propelCtx.chargesUsed);
            projectile.m_6686_(vec.f_82479_, vec.f_82480_, vec.f_82481_, propelCtx.chargesUsed, propelCtx.spread);
            projectile.f_19860_ = projectile.m_146909_();
            projectile.f_19859_ = projectile.m_146908_();
            level.m_7967_((Entity)projectile);
            recoilMagnitude += projectile.addedRecoil();
        }
        recoilMagnitude += propelCtx.recoil;
        recoilMagnitude *= CBCConfigs.SERVER.cannons.bigCannonRecoilScale.getF();
        if (controller != null) {
            controller.onRecoil(vec.m_82490_((double)(-recoilMagnitude)), (AbstractContraptionEntity)entity);
        }
        this.hasFired = true;
        soundPower = Mth.m_14036_((float)(propelCtx.chargesUsed / 16.0f), (float)0.0f, (float)1.0f);
        tone = 2.0f + soundPower * -8.0f + level.f_46441_.m_188501_() * 4.0f - 2.0f;
        pitch = (float)Mth.m_14008_((double)Math.pow(2.0, tone / 12.0f), (double)0.0, (double)2.0);
        shakeDistance = propelCtx.chargesUsed * CBCConfigs.SERVER.cannons.bigCannonBlastDistanceMultiplier.getF();
        volume = 10.0f + soundPower * 30.0f;
        plumePos = spawnPos.m_82546_(vec);
        propelCtx.smokeScale = Math.max(1.0f, propelCtx.smokeScale);
        plumeParticle = new BigCannonPlumeParticleData(propelCtx.smokeScale, propelCtx.chargesUsed, 10);
        blastEffect = new CannonBlastWaveEffectParticleData(shakeDistance, CBCSoundEvents.FIRE_BIG_CANNON.getMainEvent(), SoundSource.BLOCKS, volume, pitch, 2.0f, propelCtx.chargesUsed);
        blastWavePacket = new ClientboundLevelParticlesPacket((ParticleOptions)blastEffect, true, plumePos.f_82479_, plumePos.f_82480_, plumePos.f_82481_, 0.0f, 0.0f, 0.0f, 1.0f, 0);
        blastDistSqr = (double)(volume * volume * 256.0f) * 1.21;
        for (ServerPlayer player : level.m_6907_()) {
            level.m_8624_(player, (ParticleOptions)plumeParticle, true, plumePos.f_82479_, plumePos.f_82480_, plumePos.f_82481_, 0, vec.f_82479_, vec.f_82480_, vec.f_82481_, 1.0);
            if (!(player.m_20275_(plumePos.f_82479_, plumePos.f_82480_, plumePos.f_82481_) < blastDistSqr)) continue;
            player.f_8906_.m_9829_((Packet)blastWavePacket);
        }
        if (projectile != null && ((Boolean)CBCConfigs.SERVER.munitions.projectilesCanChunkload.get()).booleanValue()) {
            cpos1 = new ChunkPos(new BlockPos(projectile.m_20182_()));
            RitchiesProjectileLib.queueForceLoad((ServerLevel)level, (int)cpos1.f_45578_, (int)cpos1.f_45579_);
        }
    }

    private void consumeBlock(BigCannonBehavior behavior, BlockPos pos) {
        this.consumeBlock(behavior, pos, BigCannonBehavior::removeBlock);
    }

    private void consumeBlock(BigCannonBehavior behavior, BlockPos pos, Consumer<BigCannonBehavior> action) {
        action.accept(behavior);
        CompoundTag tag = behavior.blockEntity.m_187480_();
        tag.m_128473_("x");
        tag.m_128473_("y");
        tag.m_128473_("z");
        StructureTemplate.StructureBlockInfo oldInfo = (StructureTemplate.StructureBlockInfo)this.blocks.get(pos);
        if (oldInfo == null) {
            return;
        }
        StructureTemplate.StructureBlockInfo consumedInfo = new StructureTemplate.StructureBlockInfo(oldInfo.f_74675_, oldInfo.f_74676_, tag);
        this.blocks.put(oldInfo.f_74675_, consumedInfo);
    }

    private static boolean rollSquib(RandomSource random) {
        float f = CBCConfigs.SERVER.failure.squibChance.getF();
        return f != 0.0f && random.m_188501_() <= f;
    }

    private void squibBlocks(BlockPos currentPos, List<StructureTemplate.StructureBlockInfo> projectileBlocks) {
        for (int i = 0; i < projectileBlocks.size(); ++i) {
            BlockPos pos = currentPos.m_5484_(this.initialOrientation, i);
            StructureTemplate.StructureBlockInfo cannonInfo1 = (StructureTemplate.StructureBlockInfo)this.blocks.get(pos);
            BlockEntity be1 = (BlockEntity)this.presentBlockEntities.get(pos);
            StructureTemplate.StructureBlockInfo projBlock = projectileBlocks.get(i);
            if (cannonInfo1 != null && be1 instanceof IBigCannonBlockEntity) {
                IBigCannonBlockEntity cbe1 = (IBigCannonBlockEntity)be1;
                BigCannonBehavior behavior1 = (BigCannonBehavior)((Object)cbe1.cannonBehavior());
                behavior1.loadBlock(projBlock);
                CompoundTag tag = behavior1.blockEntity.m_187480_();
                tag.m_128473_("x");
                tag.m_128473_("y");
                tag.m_128473_("z");
                StructureTemplate.StructureBlockInfo squibInfo = new StructureTemplate.StructureBlockInfo(cannonInfo1.f_74675_, cannonInfo1.f_74676_, tag);
                this.blocks.put(cannonInfo1.f_74675_, squibInfo);
                continue;
            }
            CompoundTag tag = projBlock.f_74677_;
            if (tag != null) {
                tag.m_128473_("x");
                tag.m_128473_("y");
                tag.m_128473_("z");
            }
            this.blocks.put(pos, new StructureTemplate.StructureBlockInfo(pos, projBlock.f_74676_, tag));
        }
    }

    private static boolean rollBarrelBurst(RandomSource random) {
        float f = CBCConfigs.SERVER.failure.barrelChargeBurstChance.getF();
        return f != 0.0f && random.m_188501_() <= f;
    }

    private static boolean rollOverloadBurst(RandomSource random) {
        float f = CBCConfigs.SERVER.failure.overloadBurstChance.getF();
        return f != 0.0f && random.m_188501_() <= f;
    }

    private static boolean rollFailToIgnite(RandomSource random) {
        float f = CBCConfigs.SERVER.failure.interruptedIgnitionChance.getF();
        return f != 0.0f && random.m_188501_() <= f;
    }

    public void fail(BlockPos localPos, Level level, PitchOrientedContraptionEntity entity, @Nullable BlockEntity failed, int charges) {
        Vec3 failurePoint = entity.toGlobalVector(Vec3.m_82512_((Vec3i)localPos), 1.0f);
        float failScale = CBCConfigs.SERVER.failure.failureExplosionPower.getF();
        if (this.cannonMaterial.properties().failureMode() == BigCannonMaterialProperties.FailureMode.RUPTURE) {
            int failInt = Mth.m_14167_((float)failScale);
            BlockPos startPos = localPos.m_5484_(this.initialOrientation.m_122424_(), failInt);
            for (int i = 0; i < failInt * 2 + 1; ++i) {
                BlockPos pos = startPos.m_5484_(this.initialOrientation, i);
                this.blocks.remove(pos);
                this.presentBlockEntities.remove(pos);
            }
            ControlPitchContraption controller = entity.getController();
            if (controller != null) {
                controller.disassemble();
            }
            level.m_46511_(null, failurePoint.f_82479_, failurePoint.f_82480_, failurePoint.f_82481_, 2.0f * failScale + 1.0f, Explosion.BlockInteraction.NONE);
        } else {
            Iterator iter = this.blocks.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.presentBlockEntities.remove(entry.getKey());
                iter.remove();
            }
            float power = (float)charges * failScale;
            level.m_46511_(null, failurePoint.f_82479_, failurePoint.f_82480_, failurePoint.f_82481_, power, Explosion.BlockInteraction.DESTROY);
            entity.m_146870_();
        }
    }

    public void addPassengersToWorld(Level world, StructureTransform transform, List<Entity> seatedEntities) {
        super.addPassengersToWorld(world, transform, seatedEntities);
        if (!world.f_46443_ && this.isDropMortar() && this.cachedMortarRound != null && !this.cachedMortarRound.m_41619_() && this.entity != null) {
            Vec3 pos = this.entity.toGlobalVector(Vec3.m_82512_((Vec3i)this.startPos), 0.0f);
            world.m_7967_((Entity)new ItemEntity(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, this.cachedMortarRound.m_41777_()));
        }
    }

    @Override
    public Vec3 getInteractionVec(PitchOrientedContraptionEntity poce) {
        return poce.toGlobalVector(Vec3.m_82512_((Vec3i)this.startPos.m_121945_(this.initialOrientation.m_122424_())), 1.0f);
    }

    @Override
    public ICannonContraptionType getCannonType() {
        return this.isDropMortar() ? CBCCannonContraptionTypes.DROP_MORTAR : CBCCannonContraptionTypes.BIG_CANNON;
    }

    @Override
    public CompoundTag writeNBT(boolean clientData) {
        CompoundTag tag = super.writeNBT(clientData);
        tag.m_128359_("CannonMaterial", this.cannonMaterial == null ? CBCBigCannonMaterials.CAST_IRON.name().toString() : this.cannonMaterial.name().toString());
        if (this.hasWeldedPenalty) {
            tag.m_128379_("WeldedCannon", true);
        }
        if (this.mortarDelay > 0) {
            tag.m_128405_("MortarDelay", this.mortarDelay);
        }
        if (this.cachedMortarRound != null && !this.cachedMortarRound.m_41619_()) {
            tag.m_128365_("CachedMortarRound", (Tag)this.cachedMortarRound.m_41739_(new CompoundTag()));
        }
        return tag;
    }

    @Override
    public void readNBT(Level level, CompoundTag tag, boolean clientData) {
        super.readNBT(level, tag, clientData);
        this.cannonMaterial = BigCannonMaterial.fromNameOrNull(CBCUtils.location(tag.m_128461_("CannonMaterial")));
        this.hasWeldedPenalty = tag.m_128441_("WeldedCannon");
        if (this.cannonMaterial == null) {
            this.cannonMaterial = CBCBigCannonMaterials.CAST_IRON;
        }
        this.mortarDelay = Math.max(0, tag.m_128451_("MortarDelay"));
        this.cachedMortarRound = tag.m_128425_("CachedMortarRound", 10) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("CachedMortarRound")) : ItemStack.f_41583_;
    }

    public ContraptionType getType() {
        return CBCContraptionTypes.MOUNTED_CANNON;
    }

    public boolean isDropMortar() {
        BigCannonBlock cblock;
        Block block;
        StructureTemplate.StructureBlockInfo breech = (StructureTemplate.StructureBlockInfo)this.blocks.get(this.startPos.m_121945_(this.initialOrientation.m_122424_()));
        return breech != null && (block = breech.f_74676_.m_60734_()) instanceof BigCannonBlock && (cblock = (BigCannonBlock)block).getCannonShape() == CannonCastShape.DROP_MORTAR_END;
    }

    public boolean tryDroppingMortarRound(ItemStack stack) {
        Object v;
        if (!this.isDropMortar() || this.cachedMortarRound != null && !this.cachedMortarRound.m_41619_() || !(Block.m_49814_((Item)stack.m_41720_()) instanceof DropMortarMunition)) {
            return false;
        }
        BlockPos currentPos = this.startPos.m_7949_();
        while ((v = this.presentBlockEntities.get(currentPos)) instanceof IBigCannonBlockEntity) {
            IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)v;
            BigCannonBehavior behavior = (BigCannonBehavior)((Object)cbe.cannonBehavior());
            if (!behavior.block().f_74676_.m_60795_()) {
                return false;
            }
            currentPos = currentPos.m_121945_(this.initialOrientation);
        }
        this.cachedMortarRound = stack.m_41777_();
        this.cachedMortarRound.m_41764_(1);
        this.mortarDelay = (Integer)CBCConfigs.SERVER.cannons.dropMortarDelay.get();
        if (this.mortarDelay <= 0) {
            this.actuallyFireDropMortar();
        }
        return true;
    }

    public void actuallyFireDropMortar() {
        Object v;
        PitchOrientedContraptionEntity poce;
        AbstractContraptionEntity abstractContraptionEntity;
        block9: {
            block8: {
                abstractContraptionEntity = this.entity;
                if (!(abstractContraptionEntity instanceof PitchOrientedContraptionEntity)) break block8;
                poce = (PitchOrientedContraptionEntity)abstractContraptionEntity;
                abstractContraptionEntity = poce.f_19853_;
                if (abstractContraptionEntity instanceof ServerLevel) break block9;
            }
            return;
        }
        ServerLevel slevel = (ServerLevel)abstractContraptionEntity;
        ItemStack stack = this.cachedMortarRound;
        this.cachedMortarRound = ItemStack.f_41583_;
        Block block = Block.m_49814_((Item)stack.m_41720_());
        if (!(block instanceof DropMortarMunition)) {
            return;
        }
        DropMortarMunition munition = (DropMortarMunition)block;
        ControlPitchContraption controller = poce.getController();
        Object projectile = munition.getDropMortarProjectile((Level)slevel, stack);
        BlockPos currentPos = this.startPos.m_7949_();
        while ((v = this.presentBlockEntities.get(currentPos)) instanceof IBigCannonBlockEntity) {
            IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)v;
            BigCannonBehavior behavior = (BigCannonBehavior)((Object)cbe.cannonBehavior());
            if (!behavior.block().f_74676_.m_60795_()) {
                return;
            }
            currentPos = currentPos.m_121945_(this.initialOrientation);
        }
        DropMortarProjectilePropertiesComponent properties = ((DropMortarProjectile)projectile).getDropMortarProperties().dropMortarProperties();
        float recoilMagnitude = properties.mortarRecoil();
        float power = properties.mortarPower();
        float spread = properties.mortarSpread();
        Vec3 spawnPos = this.entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos.m_121945_(this.initialOrientation)), 1.0f);
        Vec3 vec = spawnPos.m_82546_(this.entity.toGlobalVector(Vec3.m_82512_((Vec3i)BlockPos.f_121853_), 1.0f)).m_82541_();
        spawnPos = spawnPos.m_82546_(vec.m_82490_(2.0));
        projectile.m_146884_(spawnPos);
        ((AbstractCannonProjectile)projectile).setChargePower(power);
        projectile.m_6686_(vec.f_82479_, vec.f_82480_, vec.f_82481_, power, spread);
        ((AbstractBigCannonProjectile)projectile).f_19860_ = projectile.m_146909_();
        ((AbstractBigCannonProjectile)projectile).f_19859_ = projectile.m_146908_();
        slevel.m_7967_(projectile);
        recoilMagnitude *= CBCConfigs.SERVER.cannons.bigCannonRecoilScale.getF();
        if (controller != null) {
            controller.onRecoil(vec.m_82490_((double)(-recoilMagnitude)), this.entity);
        }
        Vec3 plumePos = spawnPos.m_82546_(vec);
        for (ServerPlayer player : slevel.m_6907_()) {
            slevel.m_8624_(player, (ParticleOptions)new DropMortarPlumeParticleData(1.0f), true, plumePos.f_82479_, plumePos.f_82480_, plumePos.f_82481_, 0, vec.f_82479_, vec.f_82480_, vec.f_82481_, 1.0);
        }
        CBCSoundEvents.FIRE_DROP_MORTAR.playOnServer((Level)slevel, (Vec3i)new BlockPos(spawnPos), 4.0f, slevel.m_213780_().m_188501_() * 0.05f + 0.97f);
        this.hasFired = true;
    }

    protected static class PropellantContext {
        public float chargesUsed = 0.0f;
        public float recoil = 0.0f;
        public float stress = 0.0f;
        public float smokeScale = 0.0f;
        public int barrelTravelled = 0;
        public float spread = 0.0f;
        public List<StructureTemplate.StructureBlockInfo> propellantBlocks = new ArrayList<StructureTemplate.StructureBlockInfo>();

        protected PropellantContext() {
        }

        public boolean addPropellant(BigCannonPropellantBlock propellant, StructureTemplate.StructureBlockInfo info, Direction initialOrientation) {
            this.propellantBlocks.add(info);
            if (!PropellantContext.safeLoad((List<StructureTemplate.StructureBlockInfo>)ImmutableList.copyOf(this.propellantBlocks), initialOrientation)) {
                return false;
            }
            float power = Math.max(0.0f, propellant.getChargePower(info));
            this.chargesUsed += power;
            this.smokeScale += power;
            this.recoil = Math.max(0.0f, propellant.getRecoil(info));
            this.stress += propellant.getStressOnCannon(info);
            this.spread += propellant.getSpread(info);
            return true;
        }

        public boolean addIntegratedPropellant(IntegratedPropellantProjectile propellant, StructureTemplate.StructureBlockInfo firstInfo, Direction initialOrientation) {
            ImmutableList copy = ImmutableList.builder().addAll(this.propellantBlocks).add((Object)firstInfo).build();
            if (!PropellantContext.safeLoad((List<StructureTemplate.StructureBlockInfo>)copy, initialOrientation)) {
                return false;
            }
            float power = Math.max(0.0f, propellant.getChargePower());
            this.chargesUsed += power;
            this.smokeScale += power;
            this.stress += propellant.getStressOnCannon();
            this.spread += propellant.getSpread();
            return true;
        }

        public static boolean safeLoad(List<StructureTemplate.StructureBlockInfo> propellant, Direction orientation) {
            HashMap<Block, Integer> allowedCounts = new HashMap<Block, Integer>();
            HashMap<Block, Integer> actualCounts = new HashMap<Block, Integer>();
            ListIterator<StructureTemplate.StructureBlockInfo> iter = propellant.listIterator();
            while (iter.hasNext()) {
                BigCannonPropellantBlock cpropel;
                int index = iter.nextIndex();
                StructureTemplate.StructureBlockInfo info = iter.next();
                Block block = info.f_74676_.m_60734_();
                if (!(block instanceof BigCannonPropellantBlock) || !(cpropel = (BigCannonPropellantBlock)block).isValidAddition(info, index, orientation)) {
                    return false;
                }
                if (actualCounts.containsKey(block)) {
                    actualCounts.put(block, (Integer)actualCounts.get(block) + 1);
                } else {
                    actualCounts.put(block, 1);
                }
                BigCannonPropellantCompatibilities compatibilities = BigCannonPropellantCompatibilityHandler.getCompatibilities(block);
                for (Map.Entry<Block, Integer> entry : compatibilities.validPropellantCounts().entrySet()) {
                    Block block1 = entry.getKey();
                    int oldCount = allowedCounts.getOrDefault(block1, -1);
                    int newCount = entry.getValue();
                    if (newCount < 0 || oldCount >= 0 && newCount >= oldCount) continue;
                    allowedCounts.put(block1, newCount);
                }
            }
            for (Map.Entry entry : actualCounts.entrySet()) {
                Block block = (Block)entry.getKey();
                if (!allowedCounts.containsKey(block) || (Integer)allowedCounts.get(block) >= (Integer)entry.getValue()) continue;
                return false;
            }
            return true;
        }
    }
}

