/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech.QuickfiringBreechBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech.QuickfiringBreechBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;

public class QuickfiringBreechInstance
extends BlockEntityInstance<QuickfiringBreechBlockEntity>
implements DynamicInstance {
    private OrientedData breechblock;
    private OrientedData shaft;
    private OrientedData lever;
    private Direction direction;
    private Direction blockRotation;

    public QuickfiringBreechInstance(MaterialManager materialManager, QuickfiringBreechBlockEntity blockEntity) {
        super(materialManager, (BlockEntity)blockEntity);
    }

    public void init() {
        super.init();
        Direction.Axis axis = QuickfiringBreechInstance.getRotationAxis(this.blockState);
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        this.blockRotation = facing.m_175364_(axis);
        if (this.blockRotation == Direction.DOWN) {
            this.blockRotation = Direction.UP;
        }
        this.breechblock = (OrientedData)this.materialManager.defaultSolid().material(Materials.ORIENTED).getModel(QuickfiringBreechInstance.getPartialModelForState(this.blockState), this.blockState, this.blockRotation).createInstance();
        this.shaft = (OrientedData)this.materialManager.defaultSolid().material(Materials.ORIENTED).getModel((BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis)).createInstance();
        this.direction = facing.m_175364_(this.blockRotation.m_122434_());
        this.lever = (OrientedData)this.materialManager.defaultSolid().material(Materials.ORIENTED).getModel(CBCBlockPartials.QUICKFIRING_BREECH_LEVER, this.blockState, this.direction).createInstance();
        boolean alongFirst = (Boolean)this.blockState.m_61143_((Property)QuickfiringBreechBlock.AXIS);
        if (facing.m_122434_().m_122479_() && !alongFirst) {
            Direction rotDir = facing.m_122434_() == Direction.Axis.X ? Direction.UP : Direction.EAST;
            Quaternion q = rotDir.m_122432_().m_122240_(90.0f);
            this.breechblock.setRotation(q);
        }
        if (facing.m_122434_() == Direction.Axis.X && alongFirst) {
            this.breechblock.setRotation(this.blockRotation.m_122432_().m_122240_(90.0f));
        }
        this.transformModels();
    }

    public void beginFrame() {
        this.transformModels();
    }

    private void transformModels() {
        float progress = ((QuickfiringBreechBlockEntity)this.blockEntity).getOpenProgress(AnimationTickHolder.getPartialTicks());
        BlockPos instancePos = this.getInstancePosition();
        float renderedBreechblockOffset = progress / 16.0f * 13.0f;
        Vector3f normal = this.blockRotation.m_122432_();
        normal.m_122261_(renderedBreechblockOffset);
        this.breechblock.setPosition(instancePos).nudge(normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
        float angle = progress * 90.0f;
        Quaternion qrot = this.direction.m_122432_().m_122240_(angle);
        this.shaft.setPosition(instancePos).setRotation(qrot);
        this.lever.setPosition(instancePos.m_121945_(this.direction)).setRotation(qrot);
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.breechblock});
        this.relight(this.pos, new FlatLit[]{this.shaft});
        this.relight(this.pos, new FlatLit[]{this.lever});
    }

    public void remove() {
        this.breechblock.delete();
        this.shaft.delete();
        this.lever.delete();
    }

    private static PartialModel getPartialModelForState(BlockState state) {
        PartialModel partialModel;
        Block block = state.m_60734_();
        if (block instanceof BigCannonBlock) {
            BigCannonBlock cBlock = (BigCannonBlock)block;
            partialModel = CBCBlockPartials.breechblockFor(cBlock.getCannonMaterial());
        } else {
            partialModel = CBCBlockPartials.CAST_IRON_SLIDING_BREECHBLOCK;
        }
        return partialModel;
    }

    private static Direction.Axis getRotationAxis(BlockState state) {
        boolean flag = (Boolean)state.m_61143_((Property)QuickfiringBreechBlock.AXIS);
        return switch (((Direction)state.m_61143_((Property)QuickfiringBreechBlock.f_52588_)).m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (flag) {
                    yield Direction.Axis.Y;
                }
                yield Direction.Axis.Z;
            }
            case Direction.Axis.Y -> {
                if (flag) {
                    yield Direction.Axis.X;
                }
                yield Direction.Axis.Z;
            }
            case Direction.Axis.Z -> flag ? Direction.Axis.X : Direction.Axis.Y;
        };
    }
}

