/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.compat.common_jei;

import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCItems;
import rbasamoyai.createbigcannons.munitions.FuzedItemMunition;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonCartridgeItem;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonRoundItem;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCartridgeBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCartridgeBlockItem;
import rbasamoyai.createbigcannons.munitions.fuzes.FuzeItem;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;

public class MunitionAssemblyRecipes {
    public static List<CraftingRecipe> getFuzingRecipes() {
        ArrayList fuzes = new ArrayList();
        ArrayList munitions = new ArrayList();
        CBCRegistryUtils.streamAllItems().forEach(i -> {
            if (i instanceof FuzeItem) {
                fuzes.add(i);
            } else if (i instanceof FuzedItemMunition) {
                munitions.add(i);
            }
        });
        Ingredient fuzeIngredient = Ingredient.m_43929_((ItemLike[])((ItemLike[])fuzes.toArray(new Item[0])));
        String group = "createbigcannons.fuzing";
        ListTag loreTag = new ListTag();
        String loc = I18n.m_118938_((String)"tooltip.createbigcannons.jei_info.added_fuze", (Object[])new Object[0]);
        loreTag.add((Object)StringTag.m_129297_((String)("\"" + loc + "\"")));
        CompoundTag displayTag = new CompoundTag();
        displayTag.m_128365_("Lore", (Tag)loreTag);
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        for (Item munition : munitions) {
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{munition}), fuzeIngredient});
            ResourceLocation id = CreateBigCannons.resource(group + "." + munition.m_5524_());
            ItemStack fuzedMunition = new ItemStack((ItemLike)munition);
            fuzedMunition.m_41784_().m_128365_("display", (Tag)displayTag.m_6426_());
            recipes.add((CraftingRecipe)new ShapelessRecipe(id, group, fuzedMunition, inputs));
            if (!(munition instanceof AutocannonRoundItem)) continue;
            AutocannonRoundItem round = (AutocannonRoundItem)munition;
            NonNullList inputs1 = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{round.getCreativeTabCartridgeItem()}), fuzeIngredient});
            ResourceLocation id1 = CreateBigCannons.resource(group + ".autocannon_round." + munition.m_5524_());
            ItemStack fuzedCartridge = round.getCreativeTabCartridgeItem();
            fuzedCartridge.m_41784_().m_128365_("display", (Tag)displayTag.m_6426_());
            recipes.add((CraftingRecipe)new ShapelessRecipe(id1, group + ".autocannon_round", fuzedCartridge, inputs1));
        }
        return recipes;
    }

    public static List<CraftingRecipe> getAutocannonRoundRecipes() {
        String group = "createbigcannons.autocannon_round";
        Ingredient cartridge = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CBCItems.FILLED_AUTOCANNON_CARTRIDGE.get()});
        ArrayList fuzes = new ArrayList();
        ArrayList munitions = new ArrayList();
        CBCRegistryUtils.streamAllItems().forEach(i -> {
            if (i instanceof FuzeItem) {
                fuzes.add(i);
            } else if (i instanceof AutocannonRoundItem) {
                AutocannonRoundItem acr = (AutocannonRoundItem)((Object)i);
                munitions.add(acr);
            }
        });
        Ingredient fuzeIngredient = Ingredient.m_43929_((ItemLike[])((ItemLike[])fuzes.toArray(new Item[0])));
        ListTag loreTag = new ListTag();
        String loc = I18n.m_118938_((String)"tooltip.createbigcannons.jei_info.added_fuze", (Object[])new Object[0]);
        loreTag.add((Object)StringTag.m_129297_((String)("\"" + loc + "\"")));
        CompoundTag displayTag = new CompoundTag();
        displayTag.m_128365_("Lore", (Tag)loreTag);
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        for (AutocannonRoundItem round : munitions) {
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{round}), cartridge});
            ResourceLocation id = CreateBigCannons.resource(group + "." + round.m_5524_());
            recipes.add((CraftingRecipe)new ShapedRecipe(id, group, 1, 2, inputs, round.getCreativeTabCartridgeItem()));
            if (!(round instanceof FuzedItemMunition)) continue;
            NonNullList inputs1 = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{fuzeIngredient, Ingredient.m_43929_((ItemLike[])new ItemLike[]{round}), cartridge});
            ResourceLocation id1 = CreateBigCannons.resource(group + ".fuzed." + round.m_5524_());
            ItemStack fuzedRound = round.getCreativeTabCartridgeItem();
            fuzedRound.m_41784_().m_128365_("display", (Tag)displayTag.m_6426_());
            recipes.add((CraftingRecipe)new ShapedRecipe(id1, group, 1, 3, inputs1, fuzedRound));
        }
        return recipes;
    }

    public static List<CraftingRecipe> getBigCartridgeFillingRecipe() {
        String group = "createbigcannons.big_cartridge_filling";
        ResourceLocation id = CreateBigCannons.resource(group + "." + ((BigCartridgeBlock)CBCBlocks.BIG_CARTRIDGE.get()).m_7705_());
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{BigCartridgeBlockItem.getWithPower(0)}), Ingredient.m_204132_(CBCTags.CBCItemTags.NITROPOWDER)});
        ItemStack result = BigCartridgeBlockItem.getWithPower(1);
        ListTag loreTag = new ListTag();
        String loc = I18n.m_118938_((String)"tooltip.createbigcannons.jei_info.added_power", (Object[])new Object[0]);
        loreTag.add((Object)StringTag.m_129297_((String)("\"" + loc + "\"")));
        CompoundTag displayTag = new CompoundTag();
        displayTag.m_128365_("Lore", (Tag)loreTag);
        result.m_41784_().m_128365_("display", (Tag)displayTag);
        return List.of(new ShapelessRecipe(id, group, result, inputs));
    }

    public static List<CraftingRecipe> getTracerRecipes() {
        ArrayList munitions = new ArrayList();
        CBCRegistryUtils.streamAllItems().forEach(i -> {
            if (i instanceof AutocannonRoundItem || CBCItems.MACHINE_GUN_ROUND.is(i)) {
                munitions.add(i);
            }
        });
        Ingredient tracerIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CBCItems.TRACER_TIP.get()});
        String group = "createbigcannons.tracer";
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        for (Item munition : munitions) {
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{munition}), tracerIngredient});
            ResourceLocation id = CreateBigCannons.resource(group + "." + munition.m_5524_());
            ItemStack tracerMunition = new ItemStack((ItemLike)munition);
            tracerMunition.m_41784_().m_128379_("Tracer", true);
            recipes.add((CraftingRecipe)new ShapelessRecipe(id, group, tracerMunition, inputs));
            if (!(munition instanceof AutocannonRoundItem)) continue;
            AutocannonRoundItem round = (AutocannonRoundItem)munition;
            NonNullList inputs1 = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{round.getCreativeTabCartridgeItem()}), tracerIngredient});
            ResourceLocation id1 = CreateBigCannons.resource(group + ".autocannon_round." + munition.m_5524_());
            ItemStack tracerCartridge = round.getCreativeTabCartridgeItem();
            ((AutocannonCartridgeItem)CBCItems.AUTOCANNON_CARTRIDGE.get()).setTracer(tracerCartridge, true);
            recipes.add((CraftingRecipe)new ShapelessRecipe(id1, group + ".autocannon_round", tracerCartridge, inputs1));
        }
        return recipes;
    }

    public static List<DeployerApplicationRecipe> getFuzingDeployerRecipes() {
        ArrayList fuzes = new ArrayList();
        ArrayList munitions = new ArrayList();
        CBCRegistryUtils.streamAllItems().forEach(i -> {
            if (i instanceof FuzeItem) {
                fuzes.add(i);
            } else if (i instanceof FuzedItemMunition) {
                munitions.add(i);
            }
        });
        Ingredient fuzeIngredient = Ingredient.m_43929_((ItemLike[])((ItemLike[])fuzes.toArray(new Item[0])));
        String group = "createbigcannons.fuzing_deployer";
        ListTag loreTag = new ListTag();
        String loc = I18n.m_118938_((String)"tooltip.createbigcannons.jei_info.added_fuze", (Object[])new Object[0]);
        loreTag.add((Object)StringTag.m_129297_((String)("\"" + loc + "\"")));
        CompoundTag displayTag = new CompoundTag();
        displayTag.m_128365_("Lore", (Tag)loreTag);
        ArrayList<DeployerApplicationRecipe> recipes = new ArrayList<DeployerApplicationRecipe>();
        for (Item munition : munitions) {
            ResourceLocation id = CreateBigCannons.resource(group + "." + munition.m_5524_());
            ItemStack fuzedMunition = new ItemStack((ItemLike)munition);
            fuzedMunition.m_41784_().m_128365_("display", (Tag)displayTag.m_6426_());
            recipes.add((DeployerApplicationRecipe)new ProcessingRecipeBuilder(DeployerApplicationRecipe::new, id).require(Ingredient.m_43929_((ItemLike[])new ItemLike[]{munition})).require(fuzeIngredient).output(fuzedMunition).build());
            if (!(munition instanceof AutocannonRoundItem)) continue;
            AutocannonRoundItem round = (AutocannonRoundItem)munition;
            ResourceLocation id1 = CreateBigCannons.resource(group + ".autocannon_round." + munition.m_5524_());
            ItemStack fuzedCartridge = round.getCreativeTabCartridgeItem();
            fuzedCartridge.m_41784_().m_128365_("display", (Tag)displayTag.m_6426_());
            recipes.add((DeployerApplicationRecipe)new ProcessingRecipeBuilder(DeployerApplicationRecipe::new, id1).require(Ingredient.m_43927_((ItemStack[])new ItemStack[]{round.getCreativeTabCartridgeItem()})).require(fuzeIngredient).output(fuzedCartridge).build());
        }
        return recipes;
    }

    public static List<DeployerApplicationRecipe> getAutocannonRoundDeployerRecipes() {
        String group = "createbigcannons.autocannon_round_deployer";
        ArrayList munitions = new ArrayList();
        CBCRegistryUtils.streamAllItems().forEach(i -> {
            if (i instanceof AutocannonRoundItem) {
                AutocannonRoundItem acr = (AutocannonRoundItem)((Object)i);
                munitions.add(acr);
            }
        });
        ArrayList<DeployerApplicationRecipe> recipes = new ArrayList<DeployerApplicationRecipe>();
        for (AutocannonRoundItem round : munitions) {
            ResourceLocation id = CreateBigCannons.resource(group + "." + round.m_5524_());
            recipes.add((DeployerApplicationRecipe)new ProcessingRecipeBuilder(DeployerApplicationRecipe::new, id).require((ItemLike)CBCItems.FILLED_AUTOCANNON_CARTRIDGE.get()).require((ItemLike)round).output(round.getCreativeTabCartridgeItem()).build());
        }
        return recipes;
    }

    public static List<DeployerApplicationRecipe> getBigCartridgeDeployerRecipe() {
        String group = "createbigcannons.big_cartridge_filling_deployer";
        ResourceLocation id = CreateBigCannons.resource(group + "." + ((BigCartridgeBlock)CBCBlocks.BIG_CARTRIDGE.get()).m_7705_());
        ItemStack result = BigCartridgeBlockItem.getWithPower(1);
        ListTag loreTag = new ListTag();
        String loc = I18n.m_118938_((String)"tooltip.createbigcannons.jei_info.added_power", (Object[])new Object[0]);
        loreTag.add((Object)StringTag.m_129297_((String)("\"" + loc + "\"")));
        CompoundTag displayTag = new CompoundTag();
        displayTag.m_128365_("Lore", (Tag)loreTag);
        result.m_41784_().m_128365_("display", (Tag)displayTag);
        return List.of((DeployerApplicationRecipe)new ProcessingRecipeBuilder(DeployerApplicationRecipe::new, id).require(Ingredient.m_43927_((ItemStack[])new ItemStack[]{BigCartridgeBlockItem.getWithPower(0)})).require(CBCTags.CBCItemTags.NITROPOWDER).output(result).build());
    }

    public static List<DeployerApplicationRecipe> getTracerDeployerRecipes() {
        ArrayList munitions = new ArrayList();
        CBCRegistryUtils.streamAllItems().forEach(i -> {
            if (i instanceof AutocannonRoundItem || CBCItems.MACHINE_GUN_ROUND.is(i)) {
                munitions.add(i);
            }
        });
        Ingredient tracerIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CBCItems.TRACER_TIP.get()});
        String group = "createbigcannons.tracer_deployer";
        ArrayList<DeployerApplicationRecipe> recipes = new ArrayList<DeployerApplicationRecipe>();
        for (Item munition : munitions) {
            ResourceLocation id = CreateBigCannons.resource(group + "." + munition.m_5524_());
            ItemStack tracerMunition = new ItemStack((ItemLike)munition);
            tracerMunition.m_41784_().m_128379_("Tracer", true);
            recipes.add((DeployerApplicationRecipe)new ProcessingRecipeBuilder(DeployerApplicationRecipe::new, id).require(Ingredient.m_43929_((ItemLike[])new ItemLike[]{munition})).require(tracerIngredient).output(tracerMunition).build());
            if (!(munition instanceof AutocannonRoundItem)) continue;
            AutocannonRoundItem round = (AutocannonRoundItem)munition;
            ResourceLocation id1 = CreateBigCannons.resource(group + ".autocannon_round." + munition.m_5524_());
            ItemStack tracerCartridge = round.getCreativeTabCartridgeItem();
            ((AutocannonCartridgeItem)CBCItems.AUTOCANNON_CARTRIDGE.get()).setTracer(tracerCartridge, true);
            recipes.add((DeployerApplicationRecipe)new ProcessingRecipeBuilder(DeployerApplicationRecipe::new, id1).require(Ingredient.m_43927_((ItemStack[])new ItemStack[]{round.getCreativeTabCartridgeItem()})).require(tracerIngredient).output(tracerCartridge).build());
        }
        return recipes;
    }

    public static List<CraftingRecipe> getFuzeRemovalRecipes() {
        ArrayList fuzes = new ArrayList();
        ArrayList munitions = new ArrayList();
        CBCRegistryUtils.streamAllItems().forEach(i -> {
            if (i instanceof FuzeItem) {
                fuzes.add(i);
            } else if (i instanceof FuzedItemMunition) {
                munitions.add(i);
            }
        });
        String group = "createbigcannons.fuze_removal";
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        for (Item munition : munitions) {
            for (Item fuze : fuzes) {
                ItemStack fuzeStack = new ItemStack((ItemLike)fuze);
                ItemStack fuzedMunitionStack = new ItemStack((ItemLike)munition);
                fuzedMunitionStack.m_41784_().m_128365_("Fuze", (Tag)fuzeStack.m_41739_(new CompoundTag()));
                String subid = munition.m_5524_() + "." + fuze.m_5524_();
                NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{fuzedMunitionStack})});
                ResourceLocation id = CreateBigCannons.resource(group + "." + subid);
                recipes.add((CraftingRecipe)new ShapelessRecipe(id, group, fuzeStack, inputs));
                if (!(munition instanceof AutocannonRoundItem)) continue;
                ItemStack fuzedCartridge = CBCItems.AUTOCANNON_CARTRIDGE.asStack();
                AutocannonCartridgeItem.writeProjectile(fuzedMunitionStack, fuzedCartridge);
                NonNullList inputs1 = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{fuzedCartridge})});
                ResourceLocation id1 = CreateBigCannons.resource(group + ".autocannon_round." + subid);
                recipes.add((CraftingRecipe)new ShapelessRecipe(id1, group + ".autocannon_round", fuzeStack, inputs1));
            }
        }
        return recipes;
    }

    public static List<CraftingRecipe> getTracerRemovalRecipes() {
        ArrayList munitions = new ArrayList();
        CBCRegistryUtils.streamAllItems().forEach(i -> {
            if (i instanceof AutocannonRoundItem || CBCItems.MACHINE_GUN_ROUND.is(i)) {
                munitions.add(i);
            }
        });
        String group = "createbigcannons.tracer_removal";
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        for (Item munition : munitions) {
            ItemStack tracerMunition = new ItemStack((ItemLike)munition);
            tracerMunition.m_41784_().m_128379_("Tracer", true);
            ResourceLocation id = CreateBigCannons.resource(group + "." + munition.m_5524_());
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{tracerMunition})});
            recipes.add((CraftingRecipe)new ShapelessRecipe(id, group, CBCItems.TRACER_TIP.asStack(), inputs));
            if (!(munition instanceof AutocannonRoundItem)) continue;
            AutocannonRoundItem round = (AutocannonRoundItem)munition;
            ItemStack tracerCartridge = round.getCreativeTabCartridgeItem();
            ((AutocannonCartridgeItem)CBCItems.AUTOCANNON_CARTRIDGE.get()).setTracer(tracerCartridge, true);
            NonNullList inputs1 = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{tracerCartridge})});
            ResourceLocation id1 = CreateBigCannons.resource(group + ".autocannon_round." + munition.m_5524_());
            recipes.add((CraftingRecipe)new ShapelessRecipe(id1, group + ".autocannon_round", CBCItems.TRACER_TIP.asStack(), inputs1));
        }
        return recipes;
    }

    private MunitionAssemblyRecipes() {
    }
}

