/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.datagen.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.crafting.BlockRecipeIngredient;
import rbasamoyai.createbigcannons.crafting.BlockRecipeSerializer;
import rbasamoyai.createbigcannons.datagen.recipes.BlockRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.FinishedBlockRecipe;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class BuiltUpHeatingRecipeProvider
extends BlockRecipeProvider {
    BuiltUpHeatingRecipeProvider(DataGenerator gen) {
        this("createbigcannons", gen);
    }

    public BuiltUpHeatingRecipeProvider(String modid, DataGenerator gen) {
        super(modid, gen);
        this.info = CreateBigCannons.resource("built_up_heating");
    }

    @Override
    protected void registerRecipes(Consumer<FinishedBlockRecipe> cons) {
        this.builder("steel_cannon_barrel").addLayer((Block)CBCBlocks.VERY_SMALL_STEEL_CANNON_LAYER.get()).result((Block)CBCBlocks.STEEL_CANNON_BARREL.get()).save(cons);
        this.builder("built_up_steel_cannon_barrel").addLayer((Block)CBCBlocks.VERY_SMALL_STEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.SMALL_STEEL_CANNON_LAYER.get()).result((Block)CBCBlocks.BUILT_UP_STEEL_CANNON_BARREL.get()).save(cons);
        this.builder("steel_cannon_chamber").addLayer((Block)CBCBlocks.VERY_SMALL_STEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.SMALL_STEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.MEDIUM_STEEL_CANNON_LAYER.get()).result((Block)CBCBlocks.STEEL_CANNON_CHAMBER.get()).save(cons);
        this.builder("built_up_steel_cannon_chamber").addLayer((Block)CBCBlocks.VERY_SMALL_STEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.SMALL_STEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.MEDIUM_STEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.LARGE_STEEL_CANNON_LAYER.get()).result((Block)CBCBlocks.BUILT_UP_STEEL_CANNON_CHAMBER.get()).save(cons);
        this.builder("thick_steel_cannon_chamber").addLayer((Block)CBCBlocks.VERY_SMALL_STEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.SMALL_STEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.MEDIUM_STEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.LARGE_STEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.VERY_LARGE_STEEL_CANNON_LAYER.get()).result((Block)CBCBlocks.THICK_STEEL_CANNON_CHAMBER.get()).save(cons);
        this.builder("nethersteel_cannon_barrel").addLayer((Block)CBCBlocks.VERY_SMALL_NETHERSTEEL_CANNON_LAYER.get()).result((Block)CBCBlocks.NETHERSTEEL_CANNON_BARREL.get()).save(cons);
        this.builder("built_up_nethersteel_cannon_barrel").addLayer((Block)CBCBlocks.VERY_SMALL_NETHERSTEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.SMALL_NETHERSTEEL_CANNON_LAYER.get()).result((Block)CBCBlocks.BUILT_UP_NETHERSTEEL_CANNON_BARREL.get()).save(cons);
        this.builder("nethersteel_cannon_chamber").addLayer((Block)CBCBlocks.VERY_SMALL_NETHERSTEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.SMALL_NETHERSTEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.MEDIUM_NETHERSTEEL_CANNON_LAYER.get()).result((Block)CBCBlocks.NETHERSTEEL_CANNON_CHAMBER.get()).save(cons);
        this.builder("built_up_nethersteel_cannon_chamber").addLayer((Block)CBCBlocks.VERY_SMALL_NETHERSTEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.SMALL_NETHERSTEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.MEDIUM_NETHERSTEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.LARGE_NETHERSTEEL_CANNON_LAYER.get()).result((Block)CBCBlocks.BUILT_UP_NETHERSTEEL_CANNON_CHAMBER.get()).save(cons);
        this.builder("thick_nethersteel_cannon_chamber").addLayer((Block)CBCBlocks.VERY_SMALL_NETHERSTEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.SMALL_NETHERSTEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.MEDIUM_NETHERSTEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.LARGE_NETHERSTEEL_CANNON_LAYER.get()).addLayer((Block)CBCBlocks.VERY_LARGE_NETHERSTEEL_CANNON_LAYER.get()).result((Block)CBCBlocks.THICK_NETHERSTEEL_CANNON_CHAMBER.get()).save(cons);
    }

    protected Builder builder(String name) {
        return new Builder(name);
    }

    private class Builder {
        private final ResourceLocation id;
        private Set<BlockRecipeIngredient> layers = new LinkedHashSet<BlockRecipeIngredient>();
        private Block result = null;

        private Builder(String name) {
            this.id = CBCUtils.location(BuiltUpHeatingRecipeProvider.this.modid, name);
        }

        public Builder addLayer(Block block) {
            this.layers.add(BlockRecipeIngredient.of(block));
            return this;
        }

        public Builder addLayer(TagKey<Block> tag) {
            this.layers.add(BlockRecipeIngredient.of(tag));
            return this;
        }

        public Builder result(Block result) {
            this.result = result;
            return this;
        }

        public void save(Consumer<FinishedBlockRecipe> cons) {
            if (this.layers.isEmpty()) {
                throw new IllegalStateException("Recipe " + this.id + " has no layers specified");
            }
            Objects.requireNonNull(this.result, "Recipe " + this.id + " has no result specified");
            cons.accept(new Result(this.layers, this.result, this.id));
        }
    }

    private record Result(Set<BlockRecipeIngredient> layers, Block result, ResourceLocation id) implements FinishedBlockRecipe
    {
        @Override
        public void serializeRecipeData(JsonObject obj) {
            JsonArray layersArr = new JsonArray();
            this.layers.stream().map(BlockRecipeIngredient::stringForSerialization).forEach(arg_0 -> ((JsonArray)layersArr).add(arg_0));
            obj.add("layers", (JsonElement)layersArr);
            obj.addProperty("result", CBCRegistryUtils.getBlockLocation(this.result).toString());
        }

        @Override
        public BlockRecipeSerializer<?> getSerializer() {
            return BlockRecipeSerializer.BUILT_UP_HEATING;
        }
    }
}

