/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.index;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllSoundEvents;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import rbasamoyai.createbigcannons.CreateBigCannons;

public class CBCSoundEvents {
    public static final Map<ResourceLocation, AllSoundEvents.SoundEntry> ALL = new HashMap<ResourceLocation, AllSoundEvents.SoundEntry>();
    public static final AllSoundEvents.SoundEntry AUTOCANNON_ROUND_FLYBY = CBCSoundEvents.create("autocannon_round_flyby").subtitle("Autocannon round flies by").category(SoundSource.NEUTRAL).build();
    public static final AllSoundEvents.SoundEntry FIRE_BIG_CANNON = CBCSoundEvents.create("fire_big_cannon").subtitle("Big cannon fires").category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry FIRE_AUTOCANNON = CBCSoundEvents.create("fire_autocannon").subtitle("Autocannon fires").category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry FIRE_MACHINE_GUN = CBCSoundEvents.create("fire_machine_gun").subtitle("Machine gun fires").category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry FIRE_DROP_MORTAR = CBCSoundEvents.create("fire_drop_mortar").subtitle("Drop mortar fires").addVariant("fire_drop_mortar1").category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry FLAK_ROUND_EXPLOSION = CBCSoundEvents.create("flak_round_explosion").subtitle("Flak round explodes").category(SoundSource.NEUTRAL).build();
    public static final AllSoundEvents.SoundEntry FLUID_SHELL_EXPLOSION = CBCSoundEvents.create("fluid_shell_explosion").subtitle("Fluid shell explodes").category(SoundSource.NEUTRAL).build();
    public static final AllSoundEvents.SoundEntry HOT_PROJECTILE_SPLASH = CBCSoundEvents.create("hot_projectile_splash").subtitle("Projectile splashes").playExisting(SoundEvents.f_11778_).build();
    public static final AllSoundEvents.SoundEntry LAVA_FLUID_RELEASE = CBCSoundEvents.create("lava_fluid_release").noSubtitle().playExisting(SoundEvents.f_11874_).category(SoundSource.NEUTRAL).build();
    public static final AllSoundEvents.SoundEntry MACHINE_GUN_ROUND_FLYBY = CBCSoundEvents.create("machine_gun_round_flyby").subtitle("Machine gun round flies by").category(SoundSource.NEUTRAL).build();
    public static final AllSoundEvents.SoundEntry MORTAR_STONE_EXPLODE = CBCSoundEvents.create("mortar_stone_explode").subtitle("Mortar stone explodes").addVariant("mortar_stone_explode1").addVariant("mortar_stone_explode2").category(SoundSource.NEUTRAL).build();
    public static final AllSoundEvents.SoundEntry PLACE_AUTOCANNON_AMMO_CONTAINER = CBCSoundEvents.create("place_autocannon_ammo_container").noSubtitle().playExisting(SoundEvents.f_11677_, 0.25f, 1.0f).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry POTION_FLUID_RELEASE = CBCSoundEvents.create("potion_fluid_release").noSubtitle().playExisting(SoundEvents.f_11914_).category(SoundSource.NEUTRAL).build();
    public static final AllSoundEvents.SoundEntry PROJECTILE_IMPACT = CBCSoundEvents.create("projectile_impact").subtitle("Projectile impacts").playExisting(() -> ((AllSoundEvents.SoundEntry)MORTAR_STONE_EXPLODE).getMainEvent(), 1.0f, 1.0f).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry PROJECTILE_SPLASH = CBCSoundEvents.create("projectile_splash").subtitle("Projectile splashes").addVariant("projectile_splash1").category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry SHELL_EXPLOSION = CBCSoundEvents.create("shell_explosion").subtitle("Artillery shell explodes").addVariant("shell_explosion1").addVariant("shell_explosion2").category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry SHELL_FLYING = CBCSoundEvents.create("shell_flying").subtitle("Incoming artillery shell").category(SoundSource.NEUTRAL).attenuationDistance(256).build();
    public static final AllSoundEvents.SoundEntry SHRAPNEL_SHELL_EXPLOSION = CBCSoundEvents.create("shrapnel_shell_explosion").subtitle("Shrapnel shell explodes").category(SoundSource.NEUTRAL).build();
    public static final AllSoundEvents.SoundEntry SMOKE_SHELL_DETONATE = CBCSoundEvents.create("smoke_shell_detonate").subtitle("Smoke shell bursts").playExisting(SoundEvents.f_11914_).category(SoundSource.NEUTRAL).build();
    public static final AllSoundEvents.SoundEntry WATER_FLUID_RELEASE = CBCSoundEvents.create("water_fluid_release").noSubtitle().playExisting(SoundEvents.f_11778_).category(SoundSource.NEUTRAL).build();
    public static final AllSoundEvents.SoundEntry WOOD_SPLINTERS = CBCSoundEvents.create("wood_splinters").noSubtitle().addVariant("wood_splinters1").addVariant("wood_splinters2").addVariant("wood_splinters3").category(SoundSource.BLOCKS).build();

    private static AllSoundEvents.SoundEntryBuilder create(String id) {
        return new CBCSoundEntryBuilder(CreateBigCannons.resource(id));
    }

    public static void prepare() {
        for (AllSoundEvents.SoundEntry entry : ALL.values()) {
            entry.prepare();
        }
    }

    public static void register(Consumer<AllSoundEvents.SoundEntry> consumer) {
        for (AllSoundEvents.SoundEntry entry : ALL.values()) {
            consumer.accept(entry);
        }
    }

    public static void registerLangEntries() {
        for (AllSoundEvents.SoundEntry entry : ALL.values()) {
            if (!entry.hasSubtitle()) continue;
            CreateBigCannons.REGISTRATE.addRawLang(entry.getSubtitleKey(), entry.getSubtitle());
        }
    }

    public static SoundEntryProvider provider(DataGenerator generator) {
        return new SoundEntryProvider(generator);
    }

    public static class CBCSoundEntryBuilder
    extends AllSoundEvents.SoundEntryBuilder {
        public CBCSoundEntryBuilder(ResourceLocation id) {
            super(id);
        }

        public AllSoundEvents.SoundEntryBuilder addVariant(String name) {
            return this.addVariant(CreateBigCannons.resource(name));
        }

        public AllSoundEvents.SoundEntry build() {
            AllSoundEvents.SoundEntry entry = super.build();
            ALL.put(entry.getId(), entry);
            return entry;
        }
    }

    private static class SoundEntryProvider
    implements DataProvider {
        private DataGenerator generator;

        public SoundEntryProvider(DataGenerator generator) {
            this.generator = generator;
        }

        public void m_213708_(CachedOutput cache) throws IOException {
            this.generate(this.generator.m_123916_(), cache);
        }

        public String m_6055_() {
            return "Create Big Cannons custom sounds";
        }

        public void generate(Path path, CachedOutput cache) {
            path = path.resolve("assets/createbigcannons");
            try {
                JsonObject json = new JsonObject();
                ALL.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((AllSoundEvents.SoundEntry)entry.getValue()).write(json));
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

