/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import rbasamoyai.createbigcannons.effects.particles.smoke.GasCloudParticleData;
import rbasamoyai.createbigcannons.equipment.gas_mask.GasMaskItem;
import rbasamoyai.createbigcannons.munitions.big_cannon.smoke_shell.SmokeEmitterEntity;

public class GasCloudEntity
extends SmokeEmitterEntity {
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(GasCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int waitTime;
    private Potion potion = Potions.f_43598_;
    private final List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private boolean fixedColor;
    private int reapplicationDelay = 20;

    public GasCloudEntity(EntityType<? extends GasCloudEntity> type, Level level) {
        super(type, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COLOR, (Object)0);
    }

    public void setPotion(Potion potion) {
        this.potion = potion;
        if (!this.fixedColor) {
            this.updateColor();
        }
    }

    private void updateColor() {
        if (this.potion == Potions.f_43598_ && this.effects.isEmpty()) {
            this.m_20088_().m_135381_(DATA_COLOR, (Object)0);
        } else {
            this.m_20088_().m_135381_(DATA_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
        }
    }

    public void addEffect(MobEffectInstance effectInstance) {
        this.effects.add(effectInstance);
        if (!this.fixedColor) {
            this.updateColor();
        }
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(DATA_COLOR);
    }

    public void setFixedColor(int color) {
        this.fixedColor = true;
        this.m_20088_().m_135381_(DATA_COLOR, (Object)color);
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.age >= this.waitTime && this.canDoStuff()) {
            this.victims.entrySet().removeIf(entry -> this.f_19797_ >= (Integer)entry.getValue());
            ArrayList<MobEffectInstance> toApply = new ArrayList<MobEffectInstance>();
            for (MobEffectInstance potionEffect : this.potion.m_43488_()) {
                toApply.add(new MobEffectInstance(potionEffect.m_19544_(), potionEffect.m_19557_() / 4, potionEffect.m_19564_(), potionEffect.m_19571_(), potionEffect.m_19572_()));
            }
            toApply.addAll(this.effects);
            if (toApply.isEmpty()) {
                this.victims.clear();
            } else {
                for (LivingEntity target : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_())) {
                    if (this.victims.containsKey(target) || !target.m_5801_() || this.isBlockedBy(target)) continue;
                    this.victims.put((Entity)target, this.f_19797_ + this.reapplicationDelay);
                    for (MobEffectInstance appliedEffect : toApply) {
                        if (appliedEffect.m_19544_().m_8093_()) {
                            appliedEffect.m_19544_().m_19461_((Entity)this, null, target, appliedEffect.m_19564_(), 0.5);
                            continue;
                        }
                        target.m_147207_(new MobEffectInstance(appliedEffect), (Entity)this);
                    }
                }
            }
        }
    }

    @Override
    public boolean canMergeWithOther(SmokeEmitterEntity other) {
        if (!super.canMergeWithOther(other) || !(other instanceof GasCloudEntity)) {
            return false;
        }
        GasCloudEntity otherGas = (GasCloudEntity)other;
        return this.potion == otherGas.potion || this.potion == null || otherGas.potion == null;
    }

    @Override
    public void mergeWith(SmokeEmitterEntity other) {
        if (!(other instanceof GasCloudEntity)) {
            return;
        }
        GasCloudEntity otherGas = (GasCloudEntity)other;
        boolean flag = this.age >= this.waitTime || otherGas.age >= otherGas.waitTime;
        super.mergeWith(other);
        if (flag) {
            this.age = Math.max(this.age, Math.min(this.waitTime, otherGas.waitTime));
        }
        if (this.potion != otherGas.potion && this.potion == null) {
            this.potion = otherGas.potion;
        }
        this.effects.addAll(otherGas.effects);
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("WaitTime", this.waitTime);
        tag.m_128405_("ReapplicationDelay", this.reapplicationDelay);
        if (this.fixedColor) {
            tag.m_128405_("Color", this.getColor());
        }
        if (this.potion != Potions.f_43598_) {
            tag.m_128359_("Potion", Registry.f_122828_.m_7981_((Object)this.potion).toString());
        }
        if (!this.effects.isEmpty()) {
            ListTag listTag = new ListTag();
            for (MobEffectInstance mobEffectInstance : this.effects) {
                listTag.add((Object)mobEffectInstance.m_19555_(new CompoundTag()));
            }
            tag.m_128365_("Effects", (Tag)listTag);
        }
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.waitTime = tag.m_128451_("WaitTime");
        this.reapplicationDelay = tag.m_128451_("ReapplicationDelay");
        if (tag.m_128425_("Color", 99)) {
            this.setFixedColor(tag.m_128451_("Color"));
        }
        if (tag.m_128425_("Potion", 8)) {
            this.setPotion(PotionUtils.m_43577_((CompoundTag)tag));
        }
        if (tag.m_128425_("Effects", 9)) {
            ListTag listTag = tag.m_128437_("Effects", 10);
            this.effects.clear();
            for (int i = 0; i < listTag.size(); ++i) {
                MobEffectInstance mobEffectInstance = MobEffectInstance.m_19560_((CompoundTag)listTag.m_128728_(i));
                if (mobEffectInstance == null) continue;
                this.addEffect(mobEffectInstance);
            }
        }
    }

    @Override
    protected ParticleOptions getParticle() {
        int packed = this.getColor();
        float r = (float)(packed >> 16 & 0xFF) / 255.0f;
        float g = (float)(packed >> 8 & 0xFF) / 255.0f;
        float b = (float)(packed & 0xFF) / 255.0f;
        return new GasCloudParticleData(2.0f, r, g, b);
    }

    @Override
    protected int getLifetime() {
        return super.getLifetime() + this.waitTime;
    }

    public boolean isBlockedBy(LivingEntity target) {
        return GasMaskItem.isWearingWorkingMask(target);
    }
}

