/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesProvider;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.smoke.TrailSmokeParticleData;
import rbasamoyai.createbigcannons.index.CBCSoundEvents;
import rbasamoyai.createbigcannons.multiloader.EnvExecute;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.CannonDamageSource;
import rbasamoyai.createbigcannons.munitions.ImpactExplosion;
import rbasamoyai.createbigcannons.munitions.ProjectileContext;
import rbasamoyai.createbigcannons.munitions.big_cannon.config.BigCannonProjectilePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;
import rbasamoyai.createbigcannons.network.ClientboundPlayBlockHitEffectPacket;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class AbstractBigCannonProjectile
extends AbstractCannonProjectile {
    private static final EntityDataAccessor<ItemStack> TRACER = SynchedEntityData.m_135353_(AbstractBigCannonProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    protected AbstractBigCannonProjectile(EntityType<? extends AbstractBigCannonProjectile> type, Level level) {
        super(type, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRACER, (Object)ItemStack.f_41583_);
    }

    @Override
    public void m_8119_() {
        ChunkPos cpos = new ChunkPos(this.m_20183_());
        if (this.f_19853_.f_46443_ || this.f_19853_.m_7232_(cpos.f_45578_, cpos.f_45579_)) {
            Vec3 oldPos = this.m_20182_();
            super.m_8119_();
            if (!this.isInGround()) {
                TrailType trailType = (TrailType)((Object)CBCConfigs.SERVER.munitions.bigCannonTrailType.get());
                if (trailType != TrailType.NONE) {
                    int lifetime = trailType == TrailType.SHORT ? 100 : 280 + this.f_19853_.f_46441_.m_188503_(50);
                    TrailSmokeParticleData options = new TrailSmokeParticleData(lifetime);
                    for (int i = 0; i < 10; ++i) {
                        double partial = (float)i * 0.1f;
                        double dx = Mth.m_14139_((double)partial, (double)this.f_19790_, (double)this.m_20185_());
                        double dy = Mth.m_14139_((double)partial, (double)this.f_19791_, (double)this.m_20186_());
                        double dz = Mth.m_14139_((double)partial, (double)this.f_19792_, (double)this.m_20189_());
                        double sx = this.f_19853_.f_46441_.m_188500_() * 0.004 - 0.002;
                        double sy = this.f_19853_.f_46441_.m_188500_() * 0.004 - 0.002;
                        double sz = this.f_19853_.f_46441_.m_188500_() * 0.004 - 0.002;
                        this.f_19853_.m_6485_((ParticleOptions)options, true, dx, dy, dz, sx, sy, sz);
                    }
                }
                Vec3 newPos = this.m_20182_();
                if (this.f_19853_.f_46443_ && this.localSoundCooldown == 0) {
                    Vec3 displacement = newPos.m_82546_(oldPos);
                    double dispLen = displacement.m_82553_();
                    Vec3 originPos = newPos.m_82546_(displacement.m_82490_(0.5));
                    double radius = Math.min(200.0, dispLen * 30.0);
                    EnvExecute.executeOnClient(() -> () -> CBCClientCommon.playShellFlyingSoundOnClient(this, CBCSoundEvents.SHELL_FLYING.getMainEvent(), player -> {
                        if (!((Boolean)CBCConfigs.CLIENT.enableBigCannonFlybySounds.get()).booleanValue()) {
                            return false;
                        }
                        if (player.m_20238_(originPos) > radius * radius) {
                            return false;
                        }
                        Vec3 diff = player.m_20182_().m_82546_(originPos);
                        return displacement.m_82541_().m_82526_(diff.m_82541_()) >= 0.0;
                    }, radius));
                }
            }
        }
    }

    public boolean hasTracer() {
        return (!this.getTracer().m_41619_() || (Boolean)CBCConfigs.SERVER.munitions.allBigCannonProjectilesAreTracers.get() != false) && !this.isInGround();
    }

    public void setTracer(ItemStack stack) {
        this.f_19804_.m_135381_(TRACER, (Object)(stack == null || stack.m_41619_() ? ItemStack.f_41583_ : stack));
    }

    public ItemStack getTracer() {
        return (ItemStack)this.f_19804_.m_135370_(TRACER);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (!this.getTracer().m_41619_()) {
            tag.m_128365_("Tracer", (Tag)this.getTracer().m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setTracer(tag.m_128425_("Tracer", 10) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Tracer")) : ItemStack.f_41583_);
    }

    @Override
    protected void onTickRotate() {
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        if (!this.isInGround()) {
            Vec3 vel = this.m_20184_();
            if (vel.m_82556_() > 0.005) {
                this.m_146922_((float)(Mth.m_14136_((double)vel.f_82479_, (double)vel.f_82481_) * 57.2957763671875));
                this.m_146926_((float)(Mth.m_14136_((double)vel.f_82480_, (double)vel.m_165924_()) * 57.2957763671875));
            }
            this.m_146922_(AbstractBigCannonProjectile.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            this.m_146926_(AbstractBigCannonProjectile.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
        }
    }

    public abstract BlockState getRenderedBlockState();

    @Override
    protected AbstractCannonProjectile.ImpactResult calculateBlockPenetration(ProjectileContext projectileContext, BlockState state, BlockHitResult blockHitResult) {
        boolean blockBroken;
        BlockPos pos = blockHitResult.m_82425_();
        Vec3 hitLoc = blockHitResult.m_82450_();
        BallisticPropertiesComponent ballistics = this.getBallisticProperties();
        BlockArmorPropertiesProvider blockArmor = BlockArmorPropertiesHandler.getProperties(state);
        boolean unbreakable = projectileContext.griefState() == CBCCfgMunitions.GriefState.NO_DAMAGE || state.m_60800_((BlockGetter)this.f_19853_, pos) == -1.0f;
        Vec3 accel = this.getForces(this.m_20182_(), this.m_20184_());
        Vec3 curVel = this.m_20184_().m_82549_(accel);
        Vec3 normal = CBCUtils.getSurfaceNormalVector(this.f_19853_, blockHitResult);
        double incidence = Math.max(0.0, curVel.m_82541_().m_82526_(normal.m_82548_()));
        double velMag = curVel.m_82553_();
        double mass = this.getProjectileMass();
        double bonusMomentum = 1.0 + Math.max(0.0, (velMag - (double)CBCConfigs.SERVER.munitions.minVelocityForPenetrationBonus.getF()) * (double)CBCConfigs.SERVER.munitions.penetrationBonusScale.getF());
        double incidentVel = velMag * incidence;
        double momentum = mass * incidentVel * bonusMomentum;
        double toughness = blockArmor.toughness(this.f_19853_, state, pos, true);
        double toughnessPenalty = toughness - momentum;
        double hardnessPenalty = blockArmor.hardness(this.f_19853_, state, pos, true) - (double)ballistics.penetration();
        double bounceBonus = Math.max(1.0 - hardnessPenalty, 0.0);
        double projectileDeflection = ballistics.deflection();
        double baseChance = CBCConfigs.SERVER.munitions.baseProjectileBounceChance.getF();
        double bounceChance = projectileDeflection < 0.01 || incidence > projectileDeflection ? 0.0 : Math.max(baseChance, 1.0 - incidence / projectileDeflection) * bounceBonus;
        boolean surfaceImpact = this.canHitSurface();
        boolean canBounce = (Boolean)CBCConfigs.SERVER.munitions.projectilesCanBounce.get();
        boolean bl = blockBroken = toughnessPenalty < 0.01 && !unbreakable;
        AbstractCannonProjectile.ImpactResult.KinematicOutcome outcome = surfaceImpact && canBounce && this.f_19853_.m_213780_().m_188500_() < bounceChance ? AbstractCannonProjectile.ImpactResult.KinematicOutcome.BOUNCE : (blockBroken && !this.f_19853_.f_46443_ ? AbstractCannonProjectile.ImpactResult.KinematicOutcome.PENETRATE : AbstractCannonProjectile.ImpactResult.KinematicOutcome.STOP);
        boolean shatter = surfaceImpact && outcome != AbstractCannonProjectile.ImpactResult.KinematicOutcome.BOUNCE && hardnessPenalty > (double)ballistics.toughness();
        float durabilityPenalty = ((float)Math.max(0.0, hardnessPenalty) + 1.0f) * (float)toughness / (float)incidentVel;
        state.m_60669_(this.f_19853_, state, blockHitResult, (Projectile)this);
        if (!this.f_19853_.f_46443_) {
            Vec3 effectNormal;
            boolean bounced;
            boolean bl2 = bounced = outcome == AbstractCannonProjectile.ImpactResult.KinematicOutcome.BOUNCE;
            if (bounced) {
                double elasticity = 1.7f;
                effectNormal = curVel.m_82546_(normal.m_82490_(normal.m_82526_(curVel) * elasticity));
            } else {
                effectNormal = curVel.m_82548_();
            }
            for (BlockState state1 : blockArmor.containedBlockStates(this.f_19853_, state, pos.m_7949_(), true)) {
                projectileContext.addPlayedEffect(new ClientboundPlayBlockHitEffectPacket(state1, this.m_6095_(), bounced, true, hitLoc.f_82479_, hitLoc.f_82480_, hitLoc.f_82481_, (float)effectNormal.f_82479_, (float)effectNormal.f_82480_, (float)effectNormal.f_82481_));
            }
        }
        if (blockBroken) {
            this.setProjectileMass(incidentVel < 1.0E-4 ? 0.0f : Math.max(this.getProjectileMass() - durabilityPenalty, 0.0f));
            this.f_19853_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            if (surfaceImpact) {
                float overPenetrationPower;
                float f = (float)toughness / (float)momentum;
                float f2 = overPenetrationPower = f < 0.15f ? 2.0f - 2.0f * f : 0.0f;
                if (overPenetrationPower > 0.0f && outcome == AbstractCannonProjectile.ImpactResult.KinematicOutcome.PENETRATE) {
                    projectileContext.queueExplosion(pos, overPenetrationPower);
                }
            }
        } else {
            if (outcome == AbstractCannonProjectile.ImpactResult.KinematicOutcome.STOP) {
                this.setProjectileMass(0.0f);
            } else {
                this.setProjectileMass(incidentVel < 1.0E-4 ? 0.0f : Math.max(this.getProjectileMass() - durabilityPenalty / 2.0f, 0.0f));
            }
            Vec3 spallLoc = hitLoc.m_82549_(curVel.m_82541_().m_82490_(2.0));
            if (!this.f_19853_.f_46443_) {
                ImpactExplosion explosion = new ImpactExplosion(this.f_19853_, (Entity)this, this.indirectArtilleryFire(), spallLoc.f_82479_, spallLoc.f_82480_, spallLoc.f_82481_, 2.0f, Explosion.BlockInteraction.NONE);
                CreateBigCannons.handleCustomExplosion(this.f_19853_, explosion);
            }
            SoundType sound = state.m_60827_();
            if (!this.f_19853_.f_46443_) {
                this.f_19853_.m_6263_(null, spallLoc.f_82479_, spallLoc.f_82480_, spallLoc.f_82481_, sound.m_56775_(), SoundSource.BLOCKS, sound.m_56773_(), sound.m_56774_());
            }
        }
        shatter |= this.onImpact((HitResult)blockHitResult, new AbstractCannonProjectile.ImpactResult(outcome, shatter), projectileContext);
        return new AbstractCannonProjectile.ImpactResult(outcome, shatter);
    }

    protected boolean onImpact(HitResult hitResult, AbstractCannonProjectile.ImpactResult impactResult, ProjectileContext projectileContext) {
        return false;
    }

    @Override
    protected void onHitEntity(Entity entity, ProjectileContext projectileContext) {
        super.onHitEntity(entity, projectileContext);
        this.onImpact((HitResult)new EntityHitResult(entity), new AbstractCannonProjectile.ImpactResult(AbstractCannonProjectile.ImpactResult.KinematicOutcome.PENETRATE, this.getProjectileMass() <= 0.0f), projectileContext);
    }

    @Override
    protected DamageSource getEntityDamage() {
        return new CannonDamageSource("createbigcannons.big_cannon_projectile", (Entity)this, null, this.getDamageProperties().ignoresEntityArmor());
    }

    public float addedChargePower() {
        return this.getBigCannonProjectileProperties().addedChargePower();
    }

    public float minimumChargePower() {
        return this.getBigCannonProjectileProperties().minimumChargePower();
    }

    public boolean canSquib() {
        return this.getBigCannonProjectileProperties().canSquib();
    }

    public float addedRecoil() {
        return this.getBigCannonProjectileProperties().addedRecoil();
    }

    @Nonnull
    protected abstract BigCannonProjectilePropertiesComponent getBigCannonProjectileProperties();

    public static enum TrailType {
        NONE,
        LONG,
        SHORT;

    }
}

