/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobEffectRegistry;
import rbasamoyai.createbigcannons.network.ClientboundFluidExplodePacket;
import rbasamoyai.createbigcannons.remix.CustomExplosion;

public class FluidExplosion
extends CustomExplosion.Impl {
    private final Fluid fluid;
    private final float radius;

    public FluidExplosion(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, double toBlowX, double toBlowY, double toBlowZ, float radius, Explosion.BlockInteraction interaction, Fluid fluid) {
        super(level, source, damageSource, null, toBlowX, toBlowY, toBlowZ, radius, false, interaction);
        this.fluid = fluid;
        this.radius = radius;
    }

    public FluidExplosion(Level level, ClientboundFluidExplodePacket packet) {
        super(level, packet.asCBCExplodePacket());
        this.fluid = packet.fluid();
        this.radius = packet.power();
    }

    @Override
    public void playLocalSound(Level level, double x, double y, double z) {
        if (FluidBlobEffectRegistry.effectOnFluidShellExplode(this.fluid, level, x, y, z, this.radius)) {
            return;
        }
        level.m_7785_(x, y, z, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        if (this.radius >= 2.0f && this.interaction != Explosion.BlockInteraction.NONE) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, x, y, z, 1.0, 0.0, 0.0);
        } else {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, x, y, z, 1.0, 0.0, 0.0);
        }
    }

    @Override
    public void sendExplosionToClient(ServerPlayer player) {
        if (player.m_20275_(this.x, this.y, this.z) < 16400.0) {
            Vec3 knockback = this.m_46078_().getOrDefault(player, Vec3.f_82478_);
            NetworkPlatform.sendToClientPlayer(new ClientboundFluidExplodePacket(this.x, this.y, this.z, this.size, this.m_46081_(), (float)knockback.f_82479_, (float)knockback.f_82480_, (float)knockback.f_82481_, this.fluid), player);
        }
    }
}

