/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCEntityTypes;
import rbasamoyai.createbigcannons.index.CBCMunitionPropertiesHandlers;
import rbasamoyai.createbigcannons.multiloader.IndexPlatform;
import rbasamoyai.createbigcannons.munitions.big_cannon.FuzedBigCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.config.BigCannonFuzePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.big_cannon.config.BigCannonProjectilePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.EndFluidStack;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobBurst;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidExplosion;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidShellProperties;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;
import rbasamoyai.createbigcannons.munitions.config.components.EntityDamagePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.fragment_burst.CBCProjectileBurst;

public class FluidShellProjectile
extends FuzedBigCannonProjectile {
    private EndFluidStack fluidStack;

    public FluidShellProjectile(EntityType<? extends FluidShellProjectile> type, Level level) {
        super((EntityType<? extends FuzedBigCannonProjectile>)type, level);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Fluid", (Tag)this.fluidStack.writeTag(new CompoundTag()));
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.fluidStack = EndFluidStack.readTag(tag.m_128469_("Fluid"));
    }

    public void setFluidStack(EndFluidStack fstack) {
        this.fluidStack = fstack;
    }

    @Override
    protected void detonate(Position position) {
        Vec3 oldDelta = this.m_20184_();
        FluidExplosion explosion = new FluidExplosion(this.f_19853_, null, this.indirectArtilleryFire(), position.m_7096_(), position.m_7098_(), position.m_7094_(), this.getAllProperties().explosion().explosivePower(), ((CBCCfgMunitions.GriefState)((Object)CBCConfigs.SERVER.munitions.damageRestriction.get())).explosiveInteraction(), this.fluidStack.fluid());
        CreateBigCannons.handleCustomExplosion(this.f_19853_, explosion);
        if (!this.fluidStack.isEmpty()) {
            FluidShellProperties properties = this.getAllProperties();
            int mbPerBlob = properties.mBPerFluidBlob();
            byte blobSize = (byte)((double)mbPerBlob / (double)properties.mBPerAoeRadius());
            int convertCount = IndexPlatform.convertFluid(mbPerBlob);
            int count = (int)Math.ceil((double)this.fluidStack.amount() / (double)convertCount);
            FluidBlobBurst burst = (FluidBlobBurst)((Object)CBCProjectileBurst.spawnConeBurst(this.f_19853_, (EntityType)CBCEntityTypes.FLUID_BLOB_BURST.get(), new Vec3(position.m_7096_(), position.m_7098_(), position.m_7094_()), oldDelta, count, properties.fluidBlobSpread()));
            burst.setFluidStack(this.fluidStack.copy(convertCount));
            burst.setBlobSize(blobSize);
        }
    }

    @Override
    public BlockState getRenderedBlockState() {
        return (BlockState)CBCBlocks.FLUID_SHELL.getDefaultState().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH);
    }

    @Override
    @Nonnull
    protected BigCannonFuzePropertiesComponent getFuzeProperties() {
        return this.getAllProperties().fuze();
    }

    @Override
    @Nonnull
    protected BigCannonProjectilePropertiesComponent getBigCannonProjectileProperties() {
        return this.getAllProperties().bigCannonProperties();
    }

    @Override
    @Nonnull
    public EntityDamagePropertiesComponent getDamageProperties() {
        return this.getAllProperties().damage();
    }

    @Override
    @Nonnull
    protected BallisticPropertiesComponent getBallisticProperties() {
        return this.getAllProperties().ballistics();
    }

    protected FluidShellProperties getAllProperties() {
        return (FluidShellProperties)CBCMunitionPropertiesHandlers.FLUID_SHELL.getPropertiesOf((Entity)this);
    }
}

