/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.remix;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import rbasamoyai.createbigcannons.network.ClientboundCBCExplodePacket;

public interface CustomExplosion {
    default public void playLocalSound(Level level, double x, double y, double z) {
    }

    default public void editBlock(Level level, BlockPos pos, BlockState blockState, FluidState fluidState, float power) {
    }

    public void sendExplosionToClient(ServerPlayer var1);

    public Explosion.BlockInteraction getBlockInteraction();

    public static abstract class Impl
    extends Explosion
    implements CustomExplosion {
        protected final Level level;
        protected final double x;
        protected final double y;
        protected final double z;
        protected final float size;
        protected final Explosion.BlockInteraction interaction;

        public Impl(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator calculator, double toBlowX, double toBlowY, double toBlowZ, float radius, boolean fire, Explosion.BlockInteraction interaction) {
            super(level, source, damageSource, calculator, toBlowX, toBlowY, toBlowZ, radius, fire, interaction);
            this.level = level;
            this.x = toBlowX;
            this.y = toBlowY;
            this.z = toBlowZ;
            this.size = radius;
            this.interaction = interaction;
        }

        public Impl(Level level, ClientboundCBCExplodePacket packet) {
            super(level, null, packet.x(), packet.y(), packet.z(), packet.power(), packet.toBlow());
            this.level = level;
            this.x = packet.x();
            this.y = packet.y();
            this.z = packet.z();
            this.size = packet.power();
            this.interaction = Explosion.BlockInteraction.DESTROY;
        }

        public void m_46075_(boolean spawnParticles) {
            super.m_46075_(false);
            if (spawnParticles) {
                this.spawnParticles();
            }
        }

        protected void spawnParticles() {
        }

        @Override
        public Explosion.BlockInteraction getBlockInteraction() {
            return this.interaction;
        }
    }
}

