/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.culinaryconstruct.client.model;

import com.google.common.collect.ImmutableList;
import com.illusivesoulworks.culinaryconstruct.client.model.CulinaryOverrides;
import com.illusivesoulworks.culinaryconstruct.client.model.color.ColorMixer;
import com.illusivesoulworks.culinaryconstruct.client.model.color.ColoredQuadTransformer;
import com.illusivesoulworks.culinaryconstruct.common.util.CulinaryNBT;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;

public final class SandwichGeometry
implements IUnbakedGeometry<SandwichGeometry> {
    private final List<TextureAtlasSprite> ingredients;
    private final List<Integer> layers;

    public SandwichGeometry() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    private SandwichGeometry(List<TextureAtlasSprite> ingredients, List<Integer> layers) {
        this.ingredients = ingredients;
        this.layers = layers;
    }

    private SandwichGeometry withStack(ItemStack stack) {
        ImmutableList.Builder builder = ImmutableList.builder();
        NonNullList<ItemStack> ingredients = CulinaryNBT.getIngredientsList(stack);
        for (ItemStack ing : ingredients) {
            builder.add((Object)Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(ing).getParticleIcon(ModelData.EMPTY));
        }
        int size = CulinaryNBT.getSize(stack);
        ArrayList<Integer> list = new ArrayList<Integer>();
        switch (size) {
            case 2: {
                list.addAll(Arrays.asList(1, 2));
                break;
            }
            case 3: {
                list.addAll(Arrays.asList(1, 2, 3));
                break;
            }
            case 4: {
                list.addAll(Arrays.asList(0, 1, 2, 3));
                break;
            }
            case 5: {
                list.addAll(Arrays.asList(0, 1, 2, 3, 4));
                break;
            }
            default: {
                list.add(2);
            }
        }
        return new SandwichGeometry((List<TextureAtlasSprite>)builder.build(), list);
    }

    public static RenderTypeGroup getLayerRenderTypes() {
        return new RenderTypeGroup(RenderType.m_110466_(), ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        int index = Math.max(0, this.ingredients.size() - 1);
        TextureAtlasSprite baseSprite = spriteGetter.apply(context.getMaterial("bread" + index));
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(modelLocation);
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)baseSprite, (ItemOverrides)new BakedSandwichOverrides(this, context, bakery, spriteGetter, modelState, modelLocation), (ItemTransforms)context.getTransforms());
        ArrayList ingredientColors = new ArrayList();
        this.ingredients.forEach(sprite -> ingredientColors.add(ColorMixer.getDominantColor(sprite)));
        List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)baseSprite);
        List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, material -> baseSprite, (ModelState)modelState, (ResourceLocation)modelLocation);
        RenderTypeGroup normalRenderTypes = SandwichGeometry.getLayerRenderTypes();
        modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        ColoredQuadTransformer coloredQuadTransformer = new ColoredQuadTransformer();
        for (int i = 0; i < this.ingredients.size(); ++i) {
            TextureAtlasSprite sprite2 = spriteGetter.apply(context.getMaterial("layer" + this.layers.get(i)));
            unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)sprite2);
            quads = UnbakedGeometryHelper.bakeElements((List)unbaked, material -> sprite2, (ModelState)modelState, (ResourceLocation)modelLocation);
            coloredQuadTransformer.color(quads, (Integer)ingredientColors.get(i));
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        }
        modelBuilder.setParticle(baseSprite);
        return modelBuilder.build();
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<Material> textures = new HashSet<Material>();
        for (int i = 0; i < 5; ++i) {
            textures.add(context.getMaterial("layer" + i));
            textures.add(context.getMaterial("bread" + i));
        }
        return textures;
    }

    private static final class BakedSandwichOverrides
    extends CulinaryOverrides<SandwichGeometry> {
        public BakedSandwichOverrides(SandwichGeometry model, IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ResourceLocation modelLocation) {
            super(model, context, bakery, spriteGetter, modelState, modelLocation);
        }

        @Override
        protected BakedModel getBakedModel(BakedModel originalModel, ItemStack stack, @Nullable Level world, @Nullable LivingEntity entity) {
            SandwichGeometry unbaked = ((SandwichGeometry)this.model).withStack(stack);
            return unbaked.bake(this.context, this.bakery, this.spriteGetter, this.modelState, this, new ResourceLocation("culinaryconstruct", "sandwich"));
        }
    }
}

