/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.culinaryconstruct.common.config;

import com.illusivesoulworks.culinaryconstruct.api.CulinaryConstructApi;
import com.illusivesoulworks.culinaryconstruct.api.ICulinaryIngredient;
import com.illusivesoulworks.culinaryconstruct.platform.Services;
import com.illusivesoulworks.spectrelib.config.SpectreConfigSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class CulinaryConstructConfig {
    public static final SpectreConfigSpec serverSpec;
    public static final Server SERVER;
    private static final String CONFIG_PREFIX = "gui.culinaryconstruct.config.";
    public static int maxFoodPerSandwich;
    public static double maxIngredientSaturation;
    public static int maxIngredientFood;
    public static List<Item> ingredientBlacklist;
    public static boolean showNutritionInfo;

    public static void bake() {
        maxFoodPerSandwich = (Integer)CulinaryConstructConfig.SERVER.maxFoodPerSandwich.get();
        maxIngredientFood = (Integer)CulinaryConstructConfig.SERVER.maxIngredientFood.get();
        maxIngredientSaturation = (Double)CulinaryConstructConfig.SERVER.maxIngredientSaturation.get();
        showNutritionInfo = (Boolean)CulinaryConstructConfig.SERVER.showNutritionInfo.get();
        ingredientBlacklist = new ArrayList<Item>();
        ((List)CulinaryConstructConfig.SERVER.ingredientBlacklist.get()).forEach(item -> Services.REGISTRY.getItem(new ResourceLocation(item)).ifPresent(ingredientBlacklist::add));
    }

    public static boolean isValidIngredient(ItemStack stack) {
        Item item = stack.m_41720_();
        FoodProperties food = item.m_41473_();
        Optional<ICulinaryIngredient> culinary = CulinaryConstructApi.getCulinaryIngredient(stack);
        int foodAmount = 0;
        float saturationAmount = 0.0f;
        if (culinary.isPresent()) {
            foodAmount = culinary.map(ICulinaryIngredient::getFoodAmount).orElse(0);
            saturationAmount = culinary.map(ICulinaryIngredient::getSaturation).orElse(Float.valueOf(0.0f)).floatValue();
        } else if (food != null) {
            foodAmount = food.m_38744_();
            saturationAmount = food.m_38745_();
        }
        int maxFood = maxIngredientFood;
        double maxSaturation = maxIngredientSaturation;
        List<Item> blacklist = ingredientBlacklist;
        boolean blacklisted = false;
        if (!blacklist.isEmpty()) {
            blacklisted = blacklist.contains(item);
        }
        return (maxFood < 0 || foodAmount <= maxFood) && (maxSaturation < 0.0 || (double)saturationAmount <= maxSaturation) && !blacklisted;
    }

    static {
        Pair specPair = new SpectreConfigSpec.Builder().configure(Server::new);
        serverSpec = (SpectreConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final SpectreConfigSpec.IntValue maxFoodPerSandwich;
        public final SpectreConfigSpec.DoubleValue maxIngredientSaturation;
        public final SpectreConfigSpec.IntValue maxIngredientFood;
        public final SpectreConfigSpec.ConfigValue<List<? extends String>> ingredientBlacklist;
        public final SpectreConfigSpec.BooleanValue showNutritionInfo;

        public Server(SpectreConfigSpec.Builder builder) {
            builder.push("server");
            this.maxFoodPerSandwich = builder.comment("The maximum amount of food that a single sandwich can give").translation("gui.culinaryconstruct.config.maxFoodPerSandwich").defineInRange("maxFoodPerSandwich", 10, 1, 100);
            this.maxIngredientSaturation = builder.comment("Blacklist ingredients with more than this max saturation modifier, -1 to disable").translation("gui.culinaryconstruct.config.maxIngredientSaturation").defineInRange("maxIngredientSaturation", -1.0, -1.0, 100.0);
            this.maxIngredientFood = builder.comment("Blacklist ingredients with more than this max food value, -1 to disable").translation("gui.culinaryconstruct.config.maxIngredientFood").defineInRange("maxIngredientFood", -1, -1, 100);
            this.ingredientBlacklist = builder.comment("List of items to blacklist as ingredients").translation("gui.culinaryconstruct.config.ingredientBlacklist").defineList("ingredientBlacklist", new ArrayList(), s -> s instanceof String);
            this.showNutritionInfo = builder.comment("Set to true to show nutrition and saturation information in the extended tooltip").translation("gui.culinaryconstruct.config.showNutritionInfo").define("showNutritionInfo", false);
        }
    }
}

