/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.culinaryconstruct.common.item;

import com.illusivesoulworks.culinaryconstruct.api.CulinaryConstructApi;
import com.illusivesoulworks.culinaryconstruct.common.config.CulinaryConstructConfig;
import com.illusivesoulworks.culinaryconstruct.common.util.CulinaryNBT;
import com.illusivesoulworks.culinaryconstruct.platform.Services;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CulinaryItemBase
extends Item {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat(".#");

    public CulinaryItemBase() {
        super(new Item.Properties().m_41491_(CreativeModeTab.f_40755_).m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(1.0f).m_38767_()));
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.m_38760_(CulinaryNBT.getFoodAmount(stack));
        builder.m_38758_(CulinaryNBT.getSaturation(stack));
        ArrayList<ItemStack> foods = new ArrayList<ItemStack>((Collection<ItemStack>)CulinaryNBT.getIngredientsList(stack));
        foods.add(CulinaryNBT.getBase(stack));
        for (ItemStack food : foods) {
            FoodProperties props = Services.REGISTRY.getFoodProperties(food, entity);
            if (props != null) {
                if (props.m_38746_()) {
                    builder.m_38757_();
                }
                for (Pair effect : props.m_38749_()) {
                    builder.m_38762_((MobEffectInstance)effect.getFirst(), ((Float)effect.getSecond()).floatValue());
                }
            }
            CulinaryConstructApi.getCulinaryIngredient(food).ifPresent(culinary -> {
                for (Pair<MobEffectInstance, Float> effect : culinary.getEffects()) {
                    builder.m_38762_((MobEffectInstance)effect.getFirst(), ((Float)effect.getSecond()).floatValue());
                }
            });
        }
        return builder.m_38767_();
    }

    protected static void generateCreativeNBT(ItemStack sub) {
        CulinaryNBT.setSize(sub, 5);
        CulinaryNBT.setIngredientsList(sub, (NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42686_), new ItemStack((ItemLike)Items.f_42686_), new ItemStack((ItemLike)Items.f_42686_), new ItemStack((ItemLike)Items.f_42686_), new ItemStack((ItemLike)Items.f_42686_)}));
        CulinaryNBT.setFoodAmount(sub, 20);
        CulinaryNBT.setSaturation(sub, 1.0f);
        CulinaryNBT.setQuality(sub, 4);
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, @Nonnull Level worldIn, @Nonnull LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ArrayList<ItemStack> consumed = new ArrayList<ItemStack>((Collection<ItemStack>)CulinaryNBT.getIngredientsList(stack));
            consumed.add(CulinaryNBT.getBase(stack));
            consumed.forEach(itemstack -> {
                if (!itemstack.m_41619_()) {
                    CulinaryConstructApi.getCulinaryIngredient(itemstack).ifPresent(culinary -> culinary.onEaten(player));
                }
            });
        }
        return super.m_5922_(stack, worldIn, livingEntity);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        StringBuilder fullName = new StringBuilder();
        NonNullList<ItemStack> ingredients = CulinaryNBT.getIngredientsList(stack);
        if (!ingredients.isEmpty()) {
            Map<Item, Long> countMap = ingredients.stream().collect(Collectors.groupingBy(ItemStack::m_41720_, Collectors.counting()));
            ArrayList names = new ArrayList();
            countMap.forEach((item, count) -> {
                StringBuilder builder = new StringBuilder();
                if (count > 1L) {
                    MutableComponent trans = Component.m_237115_((String)("tooltip.culinaryconstruct.count." + count));
                    builder.append(trans.getString());
                    builder.append(" ");
                }
                builder.append(Component.m_237115_((String)item.m_5524_()).getString());
                names.add(builder.toString());
            });
            fullName.append(Component.m_237110_((String)("tooltip.culinaryconstruct.list." + names.size()), (Object[])names.toArray()).getString());
        }
        fullName.append(" ");
        fullName.append(Component.m_237115_((String)this.m_5671_(stack)).getString());
        return Component.m_237113_((String)fullName.toString());
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        ItemStack base = CulinaryNBT.getBase(stack);
        int quality = CulinaryNBT.getQuality(stack);
        tooltip.add((Component)Component.m_237115_((String)("tooltip.culinaryconstruct.quality." + quality)).m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237115_((String)base.m_41778_()).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237119_());
        long windowId = Minecraft.m_91087_().m_91268_().m_85439_();
        if (InputConstants.m_84830_((long)windowId, (int)340) || InputConstants.m_84830_((long)windowId, (int)344)) {
            NonNullList<ItemStack> ingredients = CulinaryNBT.getIngredientsList(stack);
            tooltip.add((Component)Component.m_237115_((String)"tooltip.culinaryconstruct.ingredients.name").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.UNDERLINE));
            for (ItemStack ing : ingredients) {
                if (ing.m_41619_()) continue;
                tooltip.add((Component)Component.m_237115_((String)ing.m_41778_()).m_130940_(ChatFormatting.GRAY));
            }
            if (CulinaryConstructConfig.showNutritionInfo) {
                tooltip.add((Component)Component.m_237119_());
                int food = CulinaryNBT.getFoodAmount(stack);
                tooltip.add((Component)Component.m_237115_((String)"tooltip.culinaryconstruct.nutrition").m_130946_(": " + food).m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.culinaryconstruct.saturation").m_130946_(": " + DECIMAL_FORMAT.format((float)food * 2.0f * CulinaryNBT.getSaturation(stack))).m_130940_(ChatFormatting.YELLOW));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.culinaryconstruct.ingredients").m_130940_(ChatFormatting.GRAY));
        }
    }
}

