/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.common.block.entity.container;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import umpaz.farmersrespite.FarmersRespite;
import umpaz.farmersrespite.common.block.KettleBlock;
import umpaz.farmersrespite.common.block.entity.KettleBlockEntity;
import umpaz.farmersrespite.common.block.entity.container.KettleResultSlot;
import umpaz.farmersrespite.common.registry.FRBlocks;
import umpaz.farmersrespite.common.registry.FRMenuTypes;
import vectorwing.farmersdelight.common.block.entity.container.CookingPotMealSlot;

public class KettleMenu
extends RecipeBookMenu<RecipeWrapper> {
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_BOTTLE = new ResourceLocation("farmersrespite", "item/empty_container_slot_bottle");
    public final KettleBlockEntity tileEntity;
    public final ItemStackHandler inventory;
    private final ContainerData kettleData;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    public KettleMenu(int windowId, Inventory playerInventory, KettleBlockEntity tileEntity, ContainerData kettleDataIn) {
        super((MenuType)FRMenuTypes.KETTLE.get(), windowId);
        int column;
        this.tileEntity = tileEntity;
        this.inventory = tileEntity.getInventory();
        this.kettleData = kettleDataIn;
        this.level = playerInventory.f_35978_.f_19853_;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)tileEntity.m_58904_(), (BlockPos)tileEntity.m_58899_());
        int startX = 8;
        int startY = 18;
        int inputStartX = 42;
        int inputStartY = 17;
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (column = 0; column < 1; ++column) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, row * 1 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.m_38897_((Slot)new CookingPotMealSlot((IItemHandler)this.inventory, 2, 118, 26));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, 3, 86, 55){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_CONTAINER_SLOT_BOTTLE);
            }
        });
        this.m_38897_((Slot)new KettleResultSlot(playerInventory.f_35978_, tileEntity, (IItemHandler)this.inventory, 4, 118, 55));
        int startPlayerInvY = startY * 4 + 12;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.m_38897_(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 142));
        }
        this.m_38884_(kettleDataIn);
    }

    private static KettleBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        if (tileAtPos instanceof KettleBlockEntity) {
            return (KettleBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public KettleMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, KettleMenu.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(4));
    }

    public boolean m_6875_(Player playerIn) {
        return KettleMenu.m_38889_((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)FRBlocks.KETTLE.get()));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        int indexMealDisplay = 2;
        int indexContainerInput = 3;
        int indexOutput = 4;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == indexOutput) {
                if (!this.m_38903_(itemstack1, startPlayerInv, endPlayerInv, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index > indexOutput) {
                if (itemstack1.m_41720_() == Items.f_42590_ && !this.m_38903_(itemstack1, indexContainerInput, indexContainerInput + 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, 0, indexMealDisplay, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, indexContainerInput, indexOutput, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(itemstack1, startPlayerInv, endPlayerInv, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrewProgressionScaled() {
        int i = this.kettleData.m_6413_(0);
        int j = this.kettleData.m_6413_(1);
        return j != 0 && i != 0 ? i * 40 / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isHeated() {
        return this.tileEntity.isHeated();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int waterLevel() {
        BlockState state = this.tileEntity.m_58904_().m_8055_(this.tileEntity.m_58899_());
        int water_level = (Integer)state.m_61143_((Property)KettleBlock.WATER_LEVEL);
        return water_level;
    }

    public void m_5816_(StackedContents helper) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            helper.m_36466_(this.inventory.getStackInSlot(i));
        }
    }

    public void m_6650_() {
        for (int i = 0; i < 2; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public boolean m_6032_(Recipe<? super RecipeWrapper> recipe) {
        return recipe.m_5818_((Container)new RecipeWrapper((IItemHandlerModifiable)this.inventory), this.level);
    }

    public int m_6636_() {
        return 3;
    }

    public int m_6635_() {
        return 1;
    }

    public int m_6656_() {
        return 2;
    }

    public int m_6653_() {
        return 3;
    }

    public RecipeBookType m_5867_() {
        return FarmersRespite.RECIPE_TYPE_BREWING;
    }

    public boolean m_142157_(int slot) {
        return slot < this.m_6635_() * this.m_6656_();
    }
}

